<?php
/**
 * cms_template_data.php - Data class to store the template data structures.
 *
 * @author $Author: dtong $
 * @version $Id: cms_template_data.php,v 1.9 2011/05/10 16:11:56 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

class cms_template_data {

	//The data structures should be able to hanlde anything you can ask for from the templates.
	//Please ask David if you want to add a new array.
	//We could have one array and have the code to parse it but it is much faster to index separate arrays
	//Think of it as multiple hashes

	//Make sure we are using the right cache even if we switch site. ISB,ZMS, ISBBKK etc.
	public $cms_unit_org = '';

	//All types by filename (pyp,ubd,sbd etc) or by filename and stage number
	//Index is $filename or stage$i_$filename
	public $type_array = array();
	//Get filename,stage,temp_id by type, index is type
	public $type_reference_array = array();
	//Tells template uses paging or not
	public $template_paging_array = array();
	//contains multi-diemension array of stages and types, needed by unit compare
	//Index is filename like pyp, ubd, myp
	public $template_stage_array = array();
	//stores types by modules
	//Index is filename and then modules
	public $template_module_array = array();
	//First level is file_part, 2nd level is stage number, third is module name and then array of types
	public $template_stagemodule_types = array();
	//This one is like $template_stagemodule_types but includes invisible types like reflection
	//Invisible types are defined by _hidden_typeid in the templates
	public $template_stagemodule_types_special = array();

	//This should be the last array we need. This is like $template_stagemodule_types_special,
	//but adds a top level of template_id. Basically this has everything but will take some code to search thru it
	//May be we can have another array like this but with out the hidden types.
	public $template_all_levels_hashidden = array();

	//Keeps track what templates were avaiable when the cache was created
	//We use this to determine did we add or delete templates so we can update the cache
	public $file_array = array();

	//Meta types are not actual types but a refernce to the template, btnsort needs this.
	//Indexed by typeid and each element contains data indexed by
	//'stage', 'file_part', 'file_part_hash' and 'template_id'
	public $meta_types = array();

	//file_hash on the file_part. Indexed by file_part (ubd pyp...) and contains the file hash value - a 19 digit number
	public $file_part_hash = array();

	//Contains all the static types. The type is the array index key and the value is
	//an array with indexs: 'file_part', 'template_id'=>$template_id and 'file_part_hash'
	//Right now, only the resource module supports static
	public $static_types = array();
}