<?php
/**
 * OSA_init.php - File for CMS system wide constants. If you are writing code and only your code uses the constants
 * 					then please keep the constants in your own code.
 * 					Thes constants are for the system and are important and the list is getting long so do not put too many here.
 *
 * @author $Author: dtong $
 * @version $Id: Osa_init.php,v 1.99 2011/06/06 14:17:19 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

Class Osa_init {
	function Osa_init() {
		$CI =& get_instance();

		//Some template actions
		define ('CMS_ACTION_READ', 'read');
		define ('CMS_ACTION_ADD', 'add');
		define ('CMS_ACTION_EDIT', 'edit');
		define ('CMS_ACTION_ALL', 'all');
		define ('CMS_ACTION_MY', 'my');
		//TODO: This has to go away. Fix the code first
		define ('CMS_ACTION_GOAL', 'edit_goal');

		//This is used in the user role table
		define ('CMS_ICT_USER_TYPE', 1);
		define ('CMS_GOAL_ADMIN_USER_TYPE', 2);
		define ('CMS_GC_USER_TYPE', 3);
		define ('CMS_TAIL_USER_TYPE', 4);
		define ('CMS_GOAL_APPRAISER_USER_TYPE', 5);//Goal and Appraisal
		define ('CMS_CAL_USER_TYPE', 6);//Curriculum Area Leader
		define ('CMS_GLL_USER_TYPE', 7);//Grade Level Leader

		//Admin user access db id
		define ('CMS_ACCESS_ADMIN', 1);

		//This one is totally differnt from the above
		define ('CMS_ACCESS_ICT', 6);

		// flag enable courses
		//define ('CMS_ENABLE_COURSE', 1);
		// flag Publish
		//define ('CMS_PUBLISH_STATUS', 1);

		//Define all DB constants here
		define ('CMS_DB_BOOLEAN_FALSE', 0);
		define ('CMS_DB_BOOLEAN_TRUE', 1);
		define ('CMS_DB_NULL', 'null');

		//Some admin db values for enable and disable
		define ('CMS_ADMIN_DISABLE' , 0);
		define ('CMS_ADMIN_ENABLE'  , 1);
		//This flag is to ignore the 2 above and show all
		define ('CMS_ADMIN_ALL'     , 2);

		define ('CMS_SELECT_ALL', 'all');
		//No data in display_grade so use course_grade for now
		//Change to display_grade when we have data in display_grade
		define ('CMS_GRADE_TABLE', $CI->config->item('cms_grade_table'));

		/*
		define ('CMS_GOAL_TYPE', 'goal_type');
		define ('CMS_MODULE_TYPE', 'stage_type');
		define ('CMS_SORT_TYPE', 'sort_type');
		define ('CMS_COMPARE_TYPE', 'compare_type');
		*/

		//Admin menu types.
		define ('CMS_ADMIN_USER_TYPE'        , 1);
		define ('CMS_ADMIN_COURSE_TYPE'      , 2);
		define ('CMS_ADMIN_DEPARTMENT_TYPE'  , 3);
		define ('CMS_ADMIN_STRAND_TYPE'      , 4);
		define ('CMS_ADMIN_STANDARD_TYPE'    , 5);
		define ('CMS_ADMIN_BENCHMARK_TYPE'   , 6);
		define ('CMS_ADMIN_USERCOURSE_TYPE'  , 7);
		define ('CMS_ADMIN_COURSEGRADE_TYPE' , 8);
		define ('CMS_ADMIN_UNITCOPY_TYPE' 	 , 9);
		define ('CMS_ADMIN_EQ_TYPE'   , 10);
		define ('CMS_ADMIN_SUBJECTAREA_TYPE'   , 11);

		//Flags for goal admin controller /goal/goal/load_goal
		define ('CMS_GOALALL', 1);
		define ('CMS_MYGOAL' , 2);

		//Flags for db value hidden. Can be used for any tables
		define ('CMS_HIDDEN_YES', 1);
		define ('CMS_HIDDEN_NO' , 0);

		//Status values in unit.status column
		define ('CMS_UNIT_STATUS_ALL'      , 0);
		define ('CMS_UNIT_STATUS_PUBLISH'  , 1);
		define ('CMS_UNIT_STATUS_EDIT'     , 2);
		define ('CMS_UNIT_STATUS_ARCHIVE', 3);
		define ('CMS_UNIT_STATUS_DELETE', 4);
		define ('CMS_UNIT_STATUS_NOTACTIVE', 5);

		//Just some values for the code in the admin section.
		//Do not use them in other places
		define ('CMS_ADMIN_ADD', 'add');
		define ('CMS_ADMIN_EDIT', 'edit');
		define ('CMS_ADMIN_INSERT'   	,  'insert');
		define ('CMS_ADMIN_UPDATE'   	,  'update');
		define ('CMS_ADMIN_DELETE'   	,  'delete');
		define ('CMS_ADMIN_REFRESH'  	,  'refresh');
		define ('CMS_ADMIN_SELECT' 	 	,  'select');
		define ('CMS_ADMIN_COURSEGRADE' ,  'coursegrade');

		//Some session types for mapping search that can have multiple layouts
		define ('CMS_MAPPING_NORMAL' , 1);
		define ('CMS_MAPPING_COURSE' , 2);
		define ('CMS_MAPPING_GRADE'  , 3);

		//Various unit status. These values goes to unit.status column.
		define ('CMS_UNIT_TYPE_NORMAL', 1);
		define ('CMS_UNIT_TYPE_META', 2);
		define ('CMS_UNIT_TYPE_INTEGRATED', 3);
		define ('CMS_UNIT_TYPE_INTEGRATED_CHILD', 4);
		define ('CMS_UNIT_TYPE_UNIFIED', 5);
		define ('CMS_UNIT_TYPE_UNIFIED_CHILD', 6);

		//LT history flags used in unit LT and mapping
		define('CMS_LT_HIST_ADD_TYPE', 1);
		define('CMS_LT_HIST_MODIFY_TYPE', 2);
		define('CMS_LT_HIST_DELETE_TYPE', 3);
		//LT history flags used in mapping only
		define('CMS_LT_HIST_LAST', 1);
		define('CMS_LT_HIST_All', 2);
		define('CMS_LT_HIST_K', 1);
		define('CMS_LT_HIST_S', 2);

		//Flags used to tell left or right compare data
		//Note, these flags can be used as funtion parameters for other purposes. Should clean it up later.
		define ('CMS_UNIT_COMPARE_LEFT', 'unit_left');
		define ('CMS_UNIT_COMPARE_RIGHT', 'unit_right');
		//The HTML id name used with compare highlight. The value usually contains the DB id plus a prefix
		define ('CMS_UNIT_COMPARE_CSSID', 'cssid');

		//Module compare type
		define ('CMS_MODULE_RESOURCE', 'resource');
		define ('CMS_MODULE_SELECT', 'select');
		define ('CMS_MODULE_STD_BENCH', 'std_bench');
		define ('CMS_MODULE_LEARNING_TARGETS', 'lt_list');
		define ('CMS_MODULE_ITSTANDARDS', 'itstd');
		define ('CMS_MODULE_ZMS_OUTCOMES', 'os');

		//Some more types for compare feature. Need more details here.
		//Various compare modules. Need to update the compare code if a new module is added
 		define ('CMS_CSS_MISUNDERSTANDINGS', 'ltben');
		define ('CMS_CSS_TEACHER_EQ', 'res');
 		define ('CMS_CSS_REFLECTIONS', '');
		define ('CMS_CSS_ITSTANDARDS_RESOURCE'	, 'it'); //IT STD upload resource type
		define ('CMS_CSS_RESOURCE_UPLOAD', 'resup'); // resource upload type
		define ('CMS_CSS_STAGE1_RESOURCE', 'res');
		define ('CMS_CSS_STAGE2_RESOURCE_URL', 'resurl');
		define ('CMS_CSS_STAGE2_RESOURCE_SELECT', 'ressel');
		define ('CMS_CSS_STAGE2_UPLOAD', 'resup');
		define ('CMS_CSS_ZMS_SUBJECTAREA'	, 'last');
		define ('CMS_CSS_LEARNING_TARGETS_STRAND', 'ltstr');
		define ('CMS_CSS_LEARNING_TARGETS_STANDARD', 'ltsta');
		define ('CMS_CSS_LEARNING_TARGETS_BENCHMARK', 'ltben');
		define ('CMS_CSS_LEARNING_TARGETS_TARGET', 'lttar');
		define ('CMS_CSS_ITSTANDARDS_STRAND', 'itstr');
		define ('CMS_CSS_ITSTANDARDS_STANDARD', 'itsta');
		define ('CMS_CSS_ITSTANDARDS_BENCHMARK', 'itben');
		//TODO: Don't think this is necessary
	   define ('CMS_UNIT_STAGE1', 'stage1');
		define ('CMS_UNIT_STAGE2', 'stage2');
		define ('CMS_UNIT_STAGE3', 'stage3');
		define ('CMS_UNIT_STAGE4', 'stage4');
		define ('CMS_UNIT_STAGE5', 'stage5');
		define ('CMS_UNIT_STAGE6', 'stage6');
		define ('CMS_UNIT_STAGE7', 'stage7');
		define ('CMS_UNIT_STAGE8', 'stage8');
		define ('CMS_UNIT_STAGE9', 'stage9');

		//Flag to tell compare controller to compare parent history.
		define ('CMS_PARENT_HISTORY' , 1);

		//All the CMS template types
		define ('CMS_PYP_TEMPLATE', 'pyp');
		define ('CMS_MYP_TEMPLATE', 'myp');
		define ('CMS_UBD_TEMPLATE', 'ubd');
		define ('CMS_GOAL_TEMPLATE', 'goal');
		define ('CMS_TEMPLATE_DEFAULT', 'ubd');

		//ICT/LIB Upload Resource Type
		define ('CMS_TEC_TYPE' , 5); //Technology
		define ('CMS_LIB_TYPE' , 6); //Library
		define ('CMS_LIBTEC_TYPE' , 11); //Technology+Library

		//ICT/LIB Upload Unit Type
		define ('CMS_UNIT_TEC_TYPE' , 1); //Technology
		define ('CMS_UNIT_LIB_TYPE' , 2); //Library
		define ('CMS_UNIT_LIBTEC_TYPE' , 3); //Technology+Library

		//TODO: Just true and false, constants not necessary and should delete them soon.
		define ('CMS_GOAL_USER_MEMBER' , FALSE);
		define ('CMS_GOAL_USER_EDITOR' , TRUE);

		//default entrypoint type
		define ('CMS_DEFAULT_ENTRYPOINT_TYPE' , 99999);
		//The separator for multiple filenames. If a filename has this string then the upload will break
		//* is not allowed in Windows filenames so they should be safe for separator
		define ('CMS_UPLOAD_SEPARATOR', '*');
		//Somehow having a plus breaks the download, replace + with the following string
		define ('CMS_PLUS_HACK_STR', '%252B');

		//To distinguish the differnt template types. The folders that store the templates also have the same names.
		//The DB table names should also be the same. Owner ID in the DB tables are always in 'creatorid' column.
		//This was done for access control on the template object level.
		define ('CMS_TEMPLATE_UNIT_IDENTIFIER', 'unit');
		define ('CMS_TEMPLATE_GOAL_IDENTIFIER', 'goal');
		define ('CMS_TEMPLATE_SURVEY_IDENTIFIER', 'survey');
		define ('CMS_TEMPLATE_SYSTEM_IDENTIFIER', 'system');
		//The array of template foldersd. Normal unit templates are in the default folder so not in here
		global $g_template_id_array;
		$g_template_id_array = array(CMS_TEMPLATE_UNIT_IDENTIFIER,CMS_TEMPLATE_GOAL_IDENTIFIER,CMS_TEMPLATE_SURVEY_IDENTIFIER,CMS_TEMPLATE_SYSTEM_IDENTIFIER);
/*
		define ('CMS_TEMPLATEPATH_BUILDER', APPPATH . 'templates/builder/');
		define ('CMS_TEMPLATEPATH_MAPPING', APPPATH . 'templates/mapping/');
		define ('CMS_TEMPLATEPATH_GOAL', APPPATH . 'templates/menu/goal/');
		define ('CMS_TEMPLATEPATH_HELP', APPPATH . 'templates/menu/help/');
		define ('CMS_TEMPLATEPATH_ADMIN', APPPATH . 'templates/menu/admin/');
		define ('CMS_TEMPLATEPATH_MENU', APPPATH . 'templates/menu/');
*/
		define ('CMS_TEMPLATEPATH_BUILDER', FCPATH . 'templates/builder/');
		define ('CMS_TEMPLATEPATH_MAPPING', FCPATH . 'templates/mapping/');
		define ('CMS_TEMPLATEPATH_GOAL', FCPATH . 'templates/menu/goal/');
		define ('CMS_TEMPLATEPATH_HELP', FCPATH . 'templates/menu/help/');
		define ('CMS_TEMPLATEPATH_ADMIN', FCPATH . 'templates/menu/admin/');
		define ('CMS_TEMPLATEPATH_MENU', FCPATH . 'templates/menu/');

		define('CMS_USERROLE_GROUP_GOAL', 'goal');
		define('CMS_USERROLE_GROUP_GOAL_NONADMIN', 'goalnonadmin');
		define('CMS_USERROLE_GROUP_ICT', 'ict');

		define('CMS_URLHISTORY_GOAL', 'goal');
		define('CMS_URLHISTORY_SURVEYLIST', 'surveylist');

		//Define all the session variables below
		//For the cms_security class
		define('CMS_SESSION_TEMPLATE_SECURITY', 'cms_template_security');
		//Keeps tracke of the last URL so we can go back to the previous page.
		//Only supported in the goal section for now
		define('CMS_SESSION_PREVIOUS_URL', 'previous_url');
		define('CMS_SESSION_URL_HISTORY', 'url_history');
		define('CMS_SESSION_BARCHART_JASON', 'barchartjason');
		define('CMS_SESSION_FAILED_LOGIN_LOCKOUT', 'login_lockout');
		define('CMS_SESSION_LOGIN_OBJECT', 'LOGIN');
		define('CMS_SESSION_ENCRYPTION_KEY', 'encryption_deskey');

		//One single template for all users
		define('CMS_SURVEY_TEMPLATE_SINGLE_TYPE', 1);
		//Template for teacher(s)
		define('CMS_SURVEY_TEMPLATE_TEACHER_TYPE', 2);
		//Template for students
		define('CMS_SURVEY_TEMPLATE_STUDENT_TYPE', 3);
		//All templates
		define('CMS_SURVEY_TEMPLATE_TYPE_ALL', 4);

		//data type for blocks
		define('CMS_SURVEY_EXTRA_BLOCK_TYPE', 1);

		//Don't expect the ids in the auth table would change and local is always 1
		//If the id can chnage then all the code that uses this has to be chnaged too.
		define('CMS_AUTH_ID_LOCAL', 1);

		define('CMS_ADMIN_USER_DB_ID', 1);

		//Put all the non-template btnsort filehash here
		//Do not assign a number bigger than the max value of int else it will overflow.
		//Btnsort stores it as bigint but we don't it this big and the code uses it will check for int
		//Give them values like 686000002, 686000003... This prevents conflict if people name their
		//templates as a number.
		//Learning Targets
		define('CMS_BTNSORT_FILEHASH_LT', 686000001);
		//Outcomes & Skills
		define('CMS_BTNSORT_FILEHASH_OS', 686000002);
		define('CMS_BTNSORT_SECURITY_TEMPLATE_NAME', '|sort|');
		// define name of menu tree
		define('CMS_MENU_COURSE_TREE', 'course_tree');
		define('CMS_MENU_DEPARTMENT_TREE', 'dept_tree');
		define('CMS_MENU_GRADE_TREE', 'grade_tree');
		//Include all the template constants
		require_once 'cms_template_const.php';
	}
}