<?php
/**
 * Osa_chartdata.php - The flash chart data object
 *
 * @author $Author: dtong $
 * @version $Id: Osa_chartdata.php,v 1.7 2011/02/11 14:09:30 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

Class Osa_chartdata {
	public $nodehead=NULL;
	private $nodetail=NULL;
	private $colorindex=0;
	private $colorcount;
	private $colorgen_obj=NULL;
	private $colorcodes =
		array('9999FF','FFCC00','3333FF','66FFCC','9900FF','FF99CC','339999','FF6600','990066','33CCFF',
				'669900','666699','FFCC99','FF0000','FF00FF','CC6666','6600CC','CC9999','66CCCC','996600');
	public $divid;
	public $title;
	public $count; //Count of total item
	public $url=NULL; //Not used yet

	function __construct() {
		$this->reset();
	}

	/*
	 * Resets the data
	 */
	function reset() {
		$this->divid = 'div_chart'; //Default name, can override
		$this->title = 'Graph';
		$this->nodehead = NULL;
		$this->nodetail = NULL;
		$this->colorindex = 0;
		$this->colorcount = count($this->colorcodes);
		$this_count = 0;
		if ( $this->colorgen_obj != NULL )
			$colorgen_obj->reset();
	}

	/*
	 * Adds one piece of data, for pie chart, this is one slice
	 */
	function addslice($value='', $label='', $link='', $color='') {
		$label = wordwrap($label, 25);
		if ( $color == '' ) {
			if ( $this->colorcount > $this->colorindex) {
				$color = $this->colorcodes[$this->colorindex++];
			}
			else {
				if ( $this->colorgen_obj == NULL )
					$this->colorgen_obj = new randomColorGenerator();
				$color = $this->colorgen_obj->getColor();
			}
		}
		$tmp = new Osa_chartnode($value, $label, $link, $color);
		if ( $this->nodehead == NULL ) {
			$this->nodehead = $tmp;
			$this->nodetail = $tmp;
		}
		else {
			$this->nodetail->next = $tmp;
			$this->nodetail = $tmp;
		}
		$this->count++;
	}

	/*
	 * Gets all the values in an array
	 */
	function getvalues() {
		return $this->getarray('value');
	}

	/*
	 * Gets all the colors in an array
	 */
	function getcolors() {
		return $this->getarray('color');
	}

	/*
	 * Gets all the lables in an array
	 */
	function getlables() {
		return $this->getarray('lable');
	}

	/*
	 * Gets all the URL links in an array
	 */
	function getlinks() {
		return $this->getarray('link');
	}

	function getarray($field) {
		$result = array();
		$node = $this->nodehead;
		if ( $node == NULL || !isset($node->{$field}) )
			return $result;
		while ($node != NULL) {
			$result[] = $node->{$field};
			$node = $node->next;
		}
		return $result;
	}
}

/*
 * This is the class for a chart node
 */
Class Osa_chartnode {
	public $color=''; //Color code without the #
	public $value=''; //The pie value
	public $lable=''; //The pie lable
	public $link=''; //The URL link or Jscript code
	public $next=NULL; //Next node in the linked list

	function Osa_chartnode($value, $label='', $link='', $color='') {
		$this->value = $value;
		$this->lable = $label;
		$this->color = $color;
		$this->link = $link;
	}
}

/*
 * Copied from internet. This generates a random color
 */
Class randomColorGenerator {
	private $hexColor = array("0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F");
	private $newColor = "";
	private $colorBag = array();

	function reset() {
		$this->$colorBag = array();
	}

	function getColor() {
		while ( TRUE ) {
			//$this->newColor="#".$this->hexColor[$this->genRandom()].$this->hexColor[$this->genRandom()].$this->hexColor[$this->genRandom()].$this->hexColor[$this->genRandom()].$this->hexColor[$this->genRandom()].$this->hexColor[$this->genRandom()];
			$this->newColor=$this->hexColor[$this->genRandom()].$this->hexColor[$this->genRandom()].
				$this->hexColor[$this->genRandom()].$this->hexColor[$this->genRandom()].
				$this->hexColor[$this->genRandom()].$this->hexColor[$this->genRandom()];
			if(!in_array($this->newColor,$this->colorBag)) {
				$this->colorBag[] = $this->newColor;
				return $this->newColor;
			}
		}
	}

	private function genRandom() {
		srand((float) microtime() * 10000000);
		$random_col_keys = array_rand($this->hexColor, 2);
		return $random_col_keys[0];
	}
}

?>