<?php
/**
 * Osa_barchart.php - Generic OFC bacr chart library interface. This can be used for any bar chart and not just the surveys
 * 						 This interface allows you to add bars in a barchart and then print the OFC JSON.
 *
 * @author $Author: dtong $
 * @version $Id: Osa_barchart.php,v 1.2 2011/02/11 14:09:30 dtong Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/
require_once('php-ofc-library/open-flash-chart.php');

class Osa_barchart {
	private $CI = NULL;
	private $hbar;
	private $divider;
	private $title;
	private $x_labels;
	private $y_labels;
	private $colorindex;
	private $colorcount;
	//Don't expect to have more than 20 bars. If we do then have to add random generation like the pie chart
	private $colorcodes =
		array('9999FF','FFCC00','3333FF','66FFCC','9900FF','FF99CC','339999','FF6600','990066','33CCFF',
				'669900','666699','FFCC99','FF0000','FF00FF','CC6666','6600CC','CC9999','66CCCC','996600');

	function __construct () {
		$this->CI =& get_instance();
		$this->reset();
	}

	//This is needed for a new chart since CodeIgnitor library objects are singletons
	function reset() {
		$this->colorcount = count($this->colorcodes);
		$this->hbar = new hbar( '#86BBEF' );
		//$this->hbar->set_tooltip( 'Testyyyyyyy' );
		//$this->hbar->set_key('test', '#333333');
		$this->divider = 2;
		$this->x_labels = array('0','2','4','6','8','10','12','14','16','18','20');
		$this->y_labels = array();
		$this->colorindex = 0;
		$this->title = '';
	}

	//This is the last step when all the bars are added.
	//Writes the JSON data to session
	function prepare($sessionindex) {
		//Create chart object and add the hbar object
		$chart = new open_flash_chart();
		$chart->add_element( $this->hbar );
		if ( !empty($this->title) ) {
			$chart->set_title(new title($this->title));
		}

		//Set the x axis
		$x = new x_axis();
		$x->set_offset( false );
		$x->set_labels_from_array( $this->x_labels );
		$chart->set_x_axis( $x );

		//Set the y axis
		$y = new y_axis();
		$y->set_offset( true );
		//Need to reverse the array else the label and bars are not in sync
		$y->set_labels( array_reverse($this->y_labels) );
		$chart->add_y_axis( $y );

		//$json = $chart->toPrettyString();
		$json = $chart->toString();
		$json_array = $this->CI->session->userdata(CMS_SESSION_BARCHART_JASON);
		if ( empty($json_array) ) {
			$json_array = array();
		}
		$json_array[$sessionindex] = $json;
		$this->CI->session->set_userdata(CMS_SESSION_BARCHART_JASON, $json_array);
	}

	function set_title($text) {
		$this->title = $text;
	}

	//Optional
	function set_x_label_array($labels) {
		$this->x_labels = $labels;
	}

	//Optional
	function set_label_divider($number) {
		$this->divider = $number;
	}

	//Adds a new bar to the chart
	function add_bar($y_label, $start, $end, $tooltip=FALSE) {
		$this->y_labels[] = $y_label;
		if ( $tooltip === FALSE ) {
			$tooltip = $y_label;
		}
		$h = new hbar_value($start/$this->divider, $end/$this->divider);
		$h->set_tooltip($tooltip . " : ($end)");
		$h->set_colour($this->colorcodes[$this->colorindex]);
		$this->colorindex++;
		$this->hbar->append_value($h);
	}

}