<?php
/**
 * Cms_cache.php - Cache library for caching DB results and PHP objects globally.
 * 					 This cache is per request. This means once the request is done, the cache goes away.
 * 					 This actually makes it cleaner and less problems.
 *
 * @author $Author: dtong $
 * @version $Id: Cms_cache.php,v 1.4 2011/05/09 04:48:53 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

class Cms_cache {

	//static not really necessary since Codeignitor always keeps one copy of the library
	//Keep it as static anyway since it enforces only one copy no matter what.
	private static $object_container = array();
	private static $db_container = array();
	private static $general_container = array();
	private static $cache_enable = TRUE;

	function __construct() {
	}

	//This is a major system class so protect it from lazy coders...
	function __set($var, $value) {
		echo __METHOD__ . " - You are not allowed to set undeclared class property '$var', bye bye.";
		exit;
	}

	//This is necessary if changed some DB values and then continue on in the same request would need
	//to reset the cache
	function db_reset() {
		self::$db_container = array();
	}

	//Don't think we would ever need to use this but put it here anyway
	function object_reset() {
		self::$object_container = array();
	}

	function gen_reset() {
		self::$general_container = array();
	}

	//Adds a db result, always overwrite existing cache with same id
	//$id, should add all the model parameters and separate by '_'
	function db_add($method, $key, $data) {
		if ( !self::$cache_enable )
			return;
		$key = $method . '_' . $key;
		self::$db_container[$key] = $data;
	}

	//Using the method name and $id we can get the cached DB result
	function db_get($method, $key) {
		if ( !self::$cache_enable )
			return NULL;
		$key = $method . '_' . $key;
		if ( !array_key_exists($key, self::$db_container))
			return NULL;
		return self::$db_container[$key];
	}

	//Initiate object and store in cache
	//object_add function is not necessary
	//Any object creation can use this as long as the class names are unique.
	//This improves performance if objects are being created often
	//This works across the entire request
	function object_get($classname) {
		if ( !self::$cache_enable ) {
			if ( class_exists($classname) ) {
			return new $classname;
			}
			return NULL;
		}
		if ( array_key_exists($classname, self::$object_container) ) {
			return self::$object_container[$classname];
		}
		if ( class_exists($classname) ) {
		$object = new $classname;
		self::$object_container[$classname] = $object;
		return $object;
	}
		return NULL;
	}

	function gen_add($method, $key, $data) {
		if ( !self::$cache_enable )
			return;
		$key = $method . '_' . $key;
		self::$general_container[$key] = $data;
	}

	function gen_get($method, $key) {
		if ( !self::$cache_enable )
			return NULL;
		$key = $method . '_' . $key;
		if ( !array_key_exists($key, self::$general_container))
			return NULL;
		return self::$general_container[$key];
	}
}