<?php
/**
 * batch_main.php - The main entry point for the batch job
 *
 * @author $Author: sathaporn $
 * @version $Id: batch_main.php,v 1.4 2010/06/30 06:38:08 sathaporn Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class batch_main {
	private $driver = NULL;
	private $CI = NULL;
	//private $config = NULL;

	function __construct($driver) {
		$this->driver = $driver;
		$this->CI = & get_instance();
		$this->CI->load->model('batch/cms_model');
		//$this->config = $driver->get_config();
	}

	function runit() {
 		$this->update_department();
		$this->update_courses();
		$this->update_users();
		//$this->update_course_grade();
		$this->update_user_course();
	}

	private function update_department() {
		$this->driver->update_department();
	}
	
	private function update_courses() {
		$this->driver->update_courses();
	}

	private function update_users() {
		$this->driver->update_users();
	}	

	private function update_course_grade() {
		$this->driver->update_course_grade();
	}

	private function update_user_course() {
		$this->driver->update_user_course();
	}
	
	//old code
	private function update_users2() {
		$users = $this->driver->get_users();
		if (count($users) < $this->config_value('batch_min_users')) {
			echo "Error, less than " . $this->config_value('batch_min_users') . ", not processing any users.\n";
			return FALSE;
		}
		$cms_users = $this->CI->cms_model->get_users();
		$cms_users = $this->hashit($cms_users, 'username');
		$users = $this->hashit($users, 'username');
		//Add or update users, loop sis and compare to cms
		foreach ($users as $sis_username=>$item) {
			if ( array_key_exists($sis_username, $cms_users) ) {
				$cms_user = $cms_users[$sis_username];
				if ( $cms_user['autogen'] == 0 ) {
					echo "Error, CMS username {$sis_username} was manually created but SIS also has this username.\n";
					continue;
				}
				if ( $cms_user['enabled'] == 0 ) {
					if ( $this->CI->cms_model->enable_user($cms_user['id']) )
						echo "Enabled username {$sis_username}.\n";
					else
						echo "Error, failed to enable username {$sis_username}.\n";
				}
				//Should update user info here
			}
			else {
				//user not in CMS so add it
				$data = new stdClass;
				$data->auth_id = $this->config_value('default_auth_id');
				$data->accessid = $this->config_value('default_access_id');
				$data->username = $sis_username;
				$data->enabled = 1;
				$data->autogen = 1;
				$data->password = $this->config_value('ldap_access_pw');
				$data->email = $item['email'];
				$data->firstname = $item['firstname'];
				$data->lastname = $item['lastname'];
				$data->middlename = $item['middlename'];
				$data->displayname = $item['displayname'];
				$data->title = $item['title'];
				$data->sis_teacher_number = $item['userid'];
				if ( $this->CI->cms_model->add_user($data) )
					echo "Added user $sis_username.\n";
				else
					echo "Error, failed to add user $sis_username.\n";
			}
		}
		//Disable CMS users whom are not active in BB
		foreach ($cms_users as $cms_user=>$item) {
		if ( $item['enabled'] == 1 && $item['autogen'] == 1 ) {
			if ( !array_key_exists($cms_user, $users) ) {
					if ( $this->CI->cms_model->disable_user($item['id']) )
						echo "Disabled user {$cms_user}.\n";
					else
						echo "Error, failed to disable user {$cms_user}.\n";
				}
			}
		}
	}
	
	//old code
	private function update_user_course2() {
		$sis_user_course = $this->driver->get_user_course();
		//var_dump($sis_user_course);
		if (count($sis_user_course) < $this->config_value('batch_min_user_courses')) {
			echo "Error, less than " . $this->config_value('batch_min_user_courses') . ", not processing any user_course.\n";
			return FALSE;
		}
		$cms_user_course = $this->CI->cms_model->get_user_course();
		$cms_users = $this->CI->cms_model->get_users();
		$sis_list = $this->hashit($sis_user_course, 'sis_courseid', 'username');
		$cms_list = $this->hashit($cms_user_course, 'sis_course_dbid', 'username');
		$user_list = $this->hashit($cms_users, 'username');
		$courses = $this->CI->cms_model->get_courses();
		$courses = $this->hashit($courses, 'sis_course_dbid');
		//var_dump($courses);
		//Loop thru the SIS result and compare to the CMS list to add to CMS
		foreach ($sis_list as $key=>$item) {
			if ( array_key_exists($key, $cms_list) ) {
				continue;
			}
			$sis_courseid = $item['sis_courseid'];
			$username = $item['username'];
			if ( !array_key_exists($username, $user_list))
				continue; //Can't find the username in CMS so skip
			$cms_user = $user_list[$username];
			if ( $cms_user['enabled'] != 1 )
				continue; //User is disbaled so skip
			$cms_userid = $cms_user['id'];
			if (!array_key_exists($sis_courseid, $courses))
				continue; //No course with the same SIS db id in CMS so skip
			$cms_courseid = $courses[$sis_courseid];
			$cms_courseid = $cms_courseid['id'];
			if ( $this->CI->cms_model->add_user_course($cms_userid, $cms_courseid) )
				echo "Added userid: $cms_userid/$username, courseid: $cms_courseid to user_course.\n";
			else
				echo "Wrror, failed to add userid: $cms_userid/$username, courseid: $cms_courseid to user_course.\n";
		}
		//Loop thru the CMS result and compare to SIS to delete from CMS if not in SIS
		foreach ($cms_list as $key=>$item) {
			if ( !array_key_exists($key, $sis_list) ) {
				if ( $item['is_from_sis'] != 1 )
					continue; //It was added manually so ignore
				$userid = $item['userid'];
				$courseid = $item['courseid'];
				if ( $this->CI->cms_model->delete_user_course($userid, $courseid) )
					echo "Deleted userid: $userid, courseid: $courseid from user_course.\n";
				else
					echo "Error, failed to delete userid: $userid, courseid: $courseid from user_course.\n";
			}
		}
	}

	//old code
	private function update_course_grade2() {
		$sis_course_grade = $this->driver->get_course_grade();
		if (count($sis_course_grade) < $this->config_value('batch_min_course_grades')) {
			echo "Error, less than " . $this->config_value('batch_min_course_grades') . ", not processing any course_grades.\n";
			return FALSE;
		}
		$cms_course_grade = $this->CI->cms_model->get_course_grade();
		//var_dump($cms_course_grade);
		/*foreach ($cms_course_grade as $item) {
			if ($item['gradeid']==NULL)
				var_dump($item);
		}*/
		$cms_list = $this->hashit($cms_course_grade, 'sis_course_dbid', 'gradeid');
		$sis_list = $this->hashit($sis_course_grade, 'sis_courseid', 'cms_gradeid');
		//This is for finding the CMS course id based on the sis course id
		$sis_courseid_trans = $this->hashit($cms_course_grade, 'sis_course_dbid');
		//Add course_grade
		foreach ($sis_list as $key=>$item) {
			if (!array_key_exists("$key", $cms_list)) {
				$sis_courseid = $item['sis_courseid'];
				$cms_gradeid = $item['cms_gradeid'];
				if ( !array_key_exists("$sis_courseid", $sis_courseid_trans) ) {
					//echo "Warning, SIS DB course ID from CourseGrade: {$sis_courseid} is not in CMS.\n";
					continue;
				}
				$cms_courseid = $sis_courseid_trans["$sis_courseid"];
				$cms_courseid = $cms_courseid['courseid'];
				if ( $this->CI->cms_model->add_course_grade($cms_courseid,$cms_gradeid) )
					echo "Added to course_grade table - courseid: $cms_courseid gradeid: $cms_gradeid.\n";
				else
					echo "Error, failed to add course_grade table - courseid: $cms_courseid gradeid: $cms_gradeid.\n";
			}
		}
		//Delete course_grade
		foreach ($cms_list as $key=>$item) {
			if (!array_key_exists("$key", $sis_list)) {
				$courseid = $item['courseid'];
				$gradeid = $item['gradeid'];
				if ( is_null($gradeid) || trim($gradeid) == '' )
					continue;
				if ( $this->CI->cms_model->delete_course_grade($courseid,$gradeid) )
					echo "Deleted from course_grade table - courseid: $courseid gradeid: $gradeid.\n";
				else
					echo "Error, failed to delete from course_grade table - courseid: $courseid gradeid: $gradeid.\n";
			}
		}
	}

	private function config_value($name) {
		return $this->driver->config_value($name);
	}

	private function hashit($array, $index, $index2='') {
		$ret=array();
		if ( !is_array($array) )
			return $ret;
		foreach($array as $item) {
			if ( $index2 == '' )
				$newindex = $item[$index];
			else
				$newindex = $item[$index] . '-' . $item[$index2];
			$ret[$newindex] = $item;
		}
		return $ret;
	}
	
}

?>