<?php
/**
 * config_functions - Functions for the value handling. Function names are the variable names.
 * 						 A function is not required for any variable if not required.
 *
 * @author $Author: wichai $
 * @version $Id: config_functions.php,v 1.10 2011/05/19 09:57:12 wichai Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/
require_once 'config_data.php';

class config_functions {
	private $CI;
	public $error_msg = FALSE;
	//Right now just STATUS_DISABLE, greys out the words and no MODIFY link
	public $last_status = FALSE;

	function __construct() {
		$this->CI = &get_instance();
	}

	/*
	 * Interface to all functions for getting and setting the value
	 * READ action should preprocess the value
	 * WRITE and DELETE actions should process extra code needed, need to supply the new value
	 *
	 * A retun of FALSE from a function will cause the row not to display
	 */
	function value_handle($function, $value, $action=config_data::ACTION_READ) {
		$this->error_msg = FALSE;
		$this->last_status = FALSE;
		if ( method_exists($this, $function) ) {
			return $this->$function($value, $action);
		}
		return $value;
	}

	//Put blank value if all unit types is set
	private function cms_use_unit_unified($value, $action) {
		if ( $action == config_data::ACTION_READ ) {
			//Disable if cms_all_unittypes is true
			if ( $this->CI->config->item('cms_use_all_unit_types') ) {
				$this->last_status = config_data::STATUS_BLANK_VALUE;
				//$this->last_status = config_data::STATUS_SKIP;
			}
		}
		return $value;
	}

	private function cms_use_unit_integrated($value, $action) {
		return $this->cms_use_unit_unified($value, $action);
	}

	private function cms_use_unit_meta($value, $action) {
		return $this->cms_use_unit_unified($value, $action);
	}

	//Clear sessions on write and refresh on new read
	private function cms_manage_mode($value, $action) {
		switch ($action) {
			case config_data::ACTION_POSTWRITE:
				//Maintenace mode check is now in the startup library
				/*if ( $value == TRUE ) {
					osa_clear_ci_sessions();
				}*/
				break;
			case config_data::ACTION_READ:
				$this->last_status = config_data::STATUS_REFRESH_PAGE;
				break;
		}
		return $value;
	}

	private function cms_header_message($value, $action){
		return $this->cms_header_image_bkcolor($value, $action);
	}

	//Do refresh on new read
	private function cms_header_image_bkcolor($value, $action) {
		if ($action == config_data::ACTION_READ) {
			$this->last_status = config_data::STATUS_REFRESH_PAGE;
		}
		return $value;
	}

	private function cms_header_image_left_align($value, $action) {
		return $this->cms_header_image_bkcolor($value, $action);
	}

	//Put blank value if not using category
	private function cms_category_not_show_empty_departments($value, $action) {
		if ($action == config_data::ACTION_READ && !$this->CI->config->item('cms_menutree_use_category') ) {
			$this->last_status = config_data::STATUS_BLANK_VALUE;
		}
		return $value;
	}

	private function cms_header_image($value, $action) {
		return $this->cms_header_image_bkcolor($value, $action);
	}

	private function cms_failed_login_lockout_check($value, $action) {
		//Always clear the count when option is disabled.
		if ( $action == config_data::ACTION_POSTWRITE && $value == FALSE ) {
			$this->CI->load->model('auth/login_model');
			$this->CI->login_model->clear_failedlogin_count();
		}
		return $value;
	}

	/*
	private function cms_use_all_unit_types($value, $action) {
		switch ($action) {
			case config_data::ACTION_POSTWRITE:
				if ( $value ) {
					//If turning all unit types to true then make all the types to be true too
					$this->CI->load->model('admin/config_model');
					$this->CI->config_model->update(config_data::SYSTEM_GENERAL, 'cms_use_unit_unified', TRUE);
					$this->CI->config_model->update(config_data::SYSTEM_GENERAL, 'cms_use_unit_integrated', TRUE);
					$this->CI->config_model->update(config_data::SYSTEM_GENERAL, 'cms_use_unit_meta', TRUE);
				}
				break;
			//No need for all these cases but just to show them since this is the first real handle
			case config_data::ACTION_PREDELETE:
			case config_data::ACTION_POSTDELETE:
			case config_data::ACTION_PREWRITE:
			case config_data::ACTION_READ:
			default:
				break;
		}
		//Only the read action really needs the return value.
		return $value;
	}
	*/

	private function cms_max_uploadsize($value, $action){
		if ( $action == config_data::ACTION_PREWRITE || $action == config_data::ACTION_READ ) {
			// cms_max_uploadsize uses megabytes unit but osa_maximum_uploadsize return bytes
			// so we must convert megabytes to bytes unit
			$megabytes2bytes = 1048576; // 1024 * 1024
			// $max_upload value will be megabytes unit.
			$max_upload = osa_maximum_uploadsize() / $megabytes2bytes;
			if ( $value < 1 || $max_upload < 1 ) {
				return 1; // upload size ALWAYS in megabyte so if value less than 1, set it to 1 (minimum value)
			}
			if ( $value > $max_upload ){
				return $max_upload;
			}
		}
		return $value;
	}

}