<?php
/**
 * config_data.php - Arrays for configuration
 *
 * @author $Author: wichai $
 * @version $Id: config_data.php,v 1.16 2011/05/20 12:39:00 wichai Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/

class config_data {
	//Add more array function names here for more configuration support
	//Do not change the order of this array else the whole thing will break!
	//If you need to delete a configuration array then make it an empty array instead
	static private $functions = array('system_array');
	const SYSTEM_GENERAL=1; //System configuration

	const TYPE_BOOLEAN=1;
	const TYPE_STRING=2;
	const TYPE_NUMERIC=3;
	const TYPE_TITLE=4;
	const TYPE_INT=5;
	const TYPE_BOOLEAN_NEGATE=6;
	const TYPE_LONGSTRING=7;

	const ACTION_READ=1;
	const ACTION_PREWRITE=2;
	const ACTION_POSTWRITE=3;
	const ACTION_PREDELETE=4;
	const ACTION_POSTDELETE=5;

	const FUNCTION_ERROR=NULL;
	const FORMAT_HUMAN_TYPE=1;
	const FORMAT_MACHINE_TYPE=2;
	const INPUT_WIN_WIDTH=550;
	const INPUT_WIN_HEIGHT=220;
	const INPUT_TEXT_SIZE=60;
	const INPUT_ROW_TEXT_SIZE=3;

	const INDEX_TYPE=0;
	const INDEX_VAR=1;
	const INDEX_TITLE=1;
	const INDEX_TEXT_SIZE=2;
	const INDEX_PURPOSE=3;
	const INDEX_DESC=4;
	const INDEX_WIN_WIDTH=5;
	const INDEX_WIN_HEIGHT=6;
	const INDEX_NO_DEFAULT=7;
	const INDEX_ROW_TEXT_SIZE=8;

	const STATUS_DISABLE=1;
	const STATUS_SKIP=2;
	const STATUS_BLANK_VALUE=3;
	const STATUS_REFRESH_PAGE=4;

	private static $config=NULL;
	private static $config_search=NULL;

	function __construct() {
	}

	//Have to call get_config() before this function
	static function find($var) {
		if ( array_key_exists($var, self::$config_search) ) {
			return self::$config_search[$var];
		}
		return FALSE;
	}

	/*
	 * Gets the configuration array.
	 *
	 * @param int $index
	 * 	The array index to which config always 1 for system general for now
	 * @param bool $hash_only
	 * 	If this true than it will skip assigning name and description from the language
	 * 	file and all arrays will not contain the titles.
	 * 	If false then it will assign name and desc and make 2 arrays. The return
	 * 	array will contain non-hashed array with titles and self::$config_search contains
	 * 	hashed array without titles. This was added for the config-load startup.
	 *
	 * @return array|bool
	 * 	A array containing the configuration array or false if invalid input.
	 */
	static function get_config($index=self::SYSTEM_GENERAL, $hash_only=FALSE) {
		if ( self::$config !== NULL && !$hash_only ) {
			return self::$config;
		}
		$config_all = self::config_array();
		if ( !isset($config_all[$index]) ) {
			//Invalid index so return false
			return FALSE;
		}
		if ( !$hash_only ) {
			osa_load_lang('syscfg');
		}
		//Automatically assign the language string for purpose and description
		//Have to make sure they are populated in the language file.
		//The syntax for the lang index is syscfg_VAR_name for purpose and syscfg_VAR_desc for description
		$mod_config = array();
		$config_search = array();
		$config = $config_all[$index];
		foreach ($config as $key=>$row) {
			if ( $hash_only ) {
				//Don't need name and desc from language file
				if ( $row[self::INDEX_TYPE] != self::TYPE_TITLE ) {
					//Use the address of the orginal element for speed
					$mod_config[$row[self::INDEX_VAR]] = & $config[$key];
				}
			}
			else {
				//Assigns name and desc to each row
				if ( $row[self::INDEX_TYPE] != self::TYPE_TITLE ) {
					if ( !array_key_exists(self::INDEX_PURPOSE, $row) || $row[self::INDEX_PURPOSE] === FALSE ) {
						$row[self::INDEX_PURPOSE] = lang("syscfg_{$row[self::INDEX_VAR]}_name");
					}
					if ( !array_key_exists(self::INDEX_DESC , $row) || $row[self::INDEX_DESC] === FALSE ) {
						$row[self::INDEX_DESC] = lang("syscfg_{$row[self::INDEX_VAR]}_desc");
					}
					$config_search[$row[self::INDEX_VAR]] = $row;
				}
				//This is not hashed and the hashed version is in $config_search
				$mod_config[] = $row;
			}
		}
		if ( $hash_only ) {
			return $mod_config;
		}
		self::$config = & $mod_config;
		//This is hashed index with name and desc assigned to each row
		self::$config_search = & $config_search;
		return self::$config;
	}

	/*
	 * 0 - type
	 * 1 - variable name
	 * 2 - Input text size (optional, default is false). Applies to all except booleans
	 * 3 - Name (auto assign from lang)
	 * 4 - Desc (auto assign from lang)
	 * 5 - Win width (optional, default is false)
	 * 6 - Win height (optional, default is false)
	 * 7 - Don't show system default button on the edit popup. Default is false
	 * 8 - Textarea row size (optional, default is false)
	 */
	static function config_array() {
		$configs = array();
		//Don't want to start the array from 0
		$count=1;
		foreach (self::$functions as $func) {
			$configs[$count++] = self::$func();
		}
		return $configs;
	}

	//System configuration
	static function system_array() {
		return array(
		//Maintenance mode
		array(self::TYPE_TITLE, lang('syscfg_maintenance_mode_title')),
		array(self::TYPE_BOOLEAN, 'cms_manage_mode'),
		array(self::TYPE_BOOLEAN, 'cms_failed_login_lockout_check'),
		array(self::TYPE_LONGSTRING, 'cms_loginheader_message', FALSE, FALSE, FALSE, FALSE, 270, FALSE, 5),
		array(self::TYPE_LONGSTRING, 'cms_header_message', FALSE, FALSE, FALSE, FALSE, 250, FALSE, 5),

		//LDAP
		array(self::TYPE_TITLE, 'LDAP Authentication Configuration'),
		array(self::TYPE_STRING, 'cms_ldap_server', 30, FALSE, FALSE, FALSE, FALSE, TRUE),
		array(self::TYPE_STRING, 'cms_ldap_serach_userattr', 20, FALSE, FALSE, FALSE, FALSE, TRUE),
		array(self::TYPE_STRING, 'cms_ldap_serach_dn', 30, FALSE, FALSE, FALSE, FALSE, TRUE),
		array(self::TYPE_STRING, 'cms_ldap_bind_userdn', FALSE, FALSE, FALSE, FALSE, FALSE, TRUE),
		array(self::TYPE_STRING, 'cms_ldap_bind_password', 18, FALSE, FALSE, FALSE, FALSE, TRUE),

		//Site Appearance
		array(self::TYPE_TITLE, lang('syscfg_cfg_site_title')),
		array(self::TYPE_LONGSTRING, 'cms_login_title'),
		array(self::TYPE_STRING, 'cms_site_title'),
		array(self::TYPE_LONGSTRING, 'cms_body_logo_text'),
		array(self::TYPE_STRING, 'cms_body_logo_text_color', 12),
		array(self::TYPE_STRING, 'cms_header_image'),
		array(self::TYPE_STRING, 'cms_body_image'),
		array(self::TYPE_STRING, 'cms_header_image_bkcolor', 12),
		array(self::TYPE_BOOLEAN, 'cms_header_image_left_align'),

		//General System Configuration
		array(self::TYPE_TITLE, lang('syscfg_cfg_general_title')),
		array(self::TYPE_INT, 'cms_max_uploadsize', 2),
		array(self::TYPE_INT, 'cms_max_perpage', 2),
		array(self::TYPE_INT, 'cms_max_showpage', 1),
		array(self::TYPE_BOOLEAN, 'cms_lt_importid_support'),
		array(self::TYPE_BOOLEAN_NEGATE, 'cms_single_unit_editor'),
		array(self::TYPE_BOOLEAN_NEGATE, 'cms_no_multi_course_lt'),
		array(self::TYPE_INT, 'cms_max_multi_url', 1),
		array(self::TYPE_BOOLEAN, 'cms_show_allgrades'),
		array(self::TYPE_BOOLEAN_NEGATE, 'cms_not_show_hide_course_button'),
		array(self::TYPE_BOOLEAN_NEGATE, 'cms_not_show_gradetree_button'),
		array(self::TYPE_BOOLEAN, 'cms_multiple_grade_display'),
		array(self::TYPE_BOOLEAN, 'cms_menutree_use_category'),
		array(self::TYPE_BOOLEAN_NEGATE, 'cms_category_not_show_empty_departments'),

		//Unit configuration
		array(self::TYPE_TITLE, lang('syscfg_unit_config_title')),
		array(self::TYPE_BOOLEAN, 'cms_use_all_unit_types'),
		array(self::TYPE_BOOLEAN, 'cms_use_unit_unified'),
		array(self::TYPE_BOOLEAN, 'cms_use_unit_integrated'),
		array(self::TYPE_BOOLEAN, 'cms_use_unit_meta'),
		array(self::TYPE_BOOLEAN, 'cms_unit_copyunit'),
		array(self::TYPE_BOOLEAN_NEGATE, 'cms_notuse_hide_unit_feature'),
		array(self::TYPE_INT, 'cms_unitlock_hour_expire', 2),
		array(self::TYPE_BOOLEAN_NEGATE, 'cms_unitcompare_multi_scroll'),
		);
	}
}