<?php
/**
 * admin_loadconfig - Load configurations
 *
 * @author $Author: wichai $
 * @version $Id: admin_loadconfig.php,v 1.7 2011/05/20 12:39:00 wichai Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/

require_once 'config_data.php';

class admin_loadconfig {
	//Add more functions as necessary
	private static $run_functions = array('timezone');
	private $CI;

	function __construct($init=TRUE) {
		if ( $init === TRUE ) {
			$this->load_config(config_data::SYSTEM_GENERAL);
		}
	}

	function load_config($index) {
		$this->CI = &get_instance();
		$this->CI->load->model('admin/config_model');
		$db_values = $this->CI->config_model->get_allconfig($index);
		$configdata_withhash = & config_data::get_config($index, TRUE);
		if ( $db_values ) {
			foreach ($db_values as $key=>$value) {
				if ( isset($configdata_withhash[$key]) && $configdata_withhash[$key][config_data::INDEX_TYPE] == config_data::TYPE_LONGSTRING ) {
					$value = html_entity_decode($value);
				}
				$this->CI->config->set_item($key, $value);
			}
		}
		//Run other startup functions
		$this->run();
	}

	//Main function to run all functions defined in class variable $run_functions
	private function run() {
		foreach (self::$run_functions as $function) {
			$this->$function();
		}
	}

	//Set the time zone if it is defined.
	private function timezone() {
		$zone = & $this->CI->config->item('cms_timezone');
		if ( !empty($zone) ) {
			@date_default_timezone_set($zone);
		}
		else {
			//Just to get rid of the annoying PHP warning message starting from 5.3
			//Could ask the user to enter the time zone during installation later
			@date_default_timezone_set(@date_default_timezone_get());
		}
	}
}