<?php
/**
 * osautil_ext_helper.php - Functions came from other sources
 *
 * @author $Author: dtong $
 * @version $Id: osautil_ext_helper.php,v 1.6 2011/02/14 03:38:38 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

/*
 * Never liked recursive functions, they're for college students only.
 * But, didn't want to waste time to write our own.
 */
function osa_remove_directory($directory, $empty=FALSE)
{
	// if the path has a slash at the end we remove it here
	if(substr($directory,-1) == '/')
	{
		$directory = substr($directory,0,-1);
	}

	// if the path is not valid or is not a directory ...
	if(!file_exists($directory) || !is_dir($directory))
	{
		// ... we return false and exit the function
		return FALSE;

	// ... if the path is not readable
	}elseif(!is_readable($directory))
	{
		// ... we return false and exit the function
		return FALSE;

	// ... else if the path is readable
	}else{

		// we open the directory
		$handle = opendir($directory);

		// and scan through the items inside
		while (FALSE !== ($item = readdir($handle)))
		{
			// if the filepointer is not the current directory
			// or the parent directory
			if($item != '.' && $item != '..')
			{
				// we build the new path to delete
				$path = $directory.'/'.$item;

				// if the new path is a directory
				if(is_dir($path))
				{
					// we call this function with the new path
					osa_remove_directory($path);

				// if the new path is a file
				}else{
					// we remove the file
					unlink($path);
				}
			}
		}
		// close the directory
		closedir($handle);

		// if the option to empty is not set to true
		if($empty == FALSE)
		{
			// try to delete the now empty directory
			if(!rmdir($directory))
			{
				// return false if not possible
				return FALSE;
			}
		}
		// return success
		return TRUE;
	}
}
// ------------------------------------------------------------

function osa_copy_directory($source, $dest) {
	if ( !is_dir($source) ) {
		return FALSE;
	}
	if (osa_copy_directory_actual($source, $dest) === FALSE) {
		osa_remove_directory($dest);
		return FALSE;
	}
	return TRUE;
}

/*
 * Skips copying any folder named '11deletedxx'
 * This was modified for better error handling and better file/directory permission settings
 */
function osa_copy_directory_actual($source, $dest){
	if(substr($source,-1) == '/')
		$source = substr($source,0,-1);
	if(substr($dest,-1) == '/')
		$dest = substr($dest,0,-1);
	// Simple copy for a file
	if (is_file($source)) {
		$c = copy($source, $dest);
		chmod($dest, 0666);
		return $c;
	}
	// Make destination directory
	if (!is_dir($dest)) {
		//$oldumask = umask(0);
		if ( mkdir($dest, 0777, TRUE) == FALSE )
			return FALSE;
		//umask($oldumask);
	}
	// Loop through the folder
	$dir = dir($source);
	while (false !== $entry = $dir->read()) {
		// Skip pointers
		if ($entry == "." || $entry == ".." ||
			($entry == '11deletedxx' && is_dir("$source/$entry"))) {
		continue;
	}
		// Deep copy directories
		if ($dest !== "$source/$entry") {
			if ( osa_copy_directory_actual("$source/$entry", "$dest/$entry") === FALSE )
				return FALSE;
		}
	}
	// Clean up
	$dir->close();
return true;
}
?>