<?php
/**
 * lt.php - Learning Targets controll file
 *
 * @author $Author: dtong $
 * @version $Id: outcomes.php,v 1.7 2011/05/09 04:48:52 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class outcomes extends CI_Controller {
//private $unitcontroller=NULL;

	function __construct() {
		parent::__construct();
		//$this->load->helper('form');
		$this->load->model('unit/unit_model');
		$this->load->model('unit/os_model');
		osa_load_lang('unit');
		if ( !$this->access_model->checkaccess_any('unit_read', FALSE, FALSE, FALSE) ) {
			//A view won't print to the client until this returns and an exist
			//would result in no output. So, just echo it here. Noticed the 3rd parameter in the load->view
			echo $this->load->view('unit/unit_htmlerror_view', array('errormsg'=>lang('unit_no_permissionmsg')),TRUE);
			exit;
		}
	}

	function add($unitid, $type) {
		if ( $this->config->item('cms_unit_outcomes_skills') != FALSE) {
			$this->add_zms($unitid, $type);
			return;
		}
	}

	//unit outcomes/skills add
	function add_zms($unitid, $type) {
		//Only editors can run this, exits if false
		if ( ($unit = $this->unit_model->check_unit_editaccess($unitid)) === FALSE) {
			$this->load->view('template/ajax_error_view',
				array('errormsg' => lang('gen_internalservererror'), 'divid' => 'learningtarget'));
			return;
		}

		$courseid = $unit->courseid;

		if ($courseid == FALSE) {
			echo osa_ajaxmsg(lang('gen_internalservererror'));
			return ;
		}

		$this->load->library('unit/unitmain',
			array('action'=>CMS_ACTION_ADD,'unitid'=>$unitid, 'courseid'=>$unit->courseid));
		$osobj = $this->unitmain->get_os_obj($type, $unitid);
		$data = new stdClass();
		$data->template = $osobj;

		$strandid       = $this->config->item('cms_outcomes_skills_strandid');
		$standardid     = $this->config->item('cms_outcomes_skills_standardid');

		$data->savelink = $this->config->item('cms_menu_unit_os_savelink');
		$data->editlink = $this->config->item('cms_menu_unit_editlink');

		$data->courseid = $courseid;
		$data->unitid   = $unitid;
		$data->type     = $type;

		$sort_type = osa_template_sort_type($this->unitmain->get_os_edittemplate());
		$data->sort_type = $sort_type;
		$this->os_model->sort_type = $sort_type;
		$this->os_model->sort_filehash = $this->unitmain->get_template_filepart();
		$this->os_model->sort_read_only = TRUE;

		$dept_obj = $this->unit_model->get_departbyparent($unitid);
		$multi_courseids = FALSE;
		if ( count($dept_obj) > 0 ) {
			$multi_courseids = array();
			foreach ($dept_obj as $value) {
				$multi_courseids[$value->courseid] = $value->courseid;
			}
		}
		$this->load->library('cms/cms_btnsort');
		$data->outcomes = $this->os_model->get_outcomes_skills_all($courseid, $type, 1, 1, FALSE, $multi_courseids);
		$data->selected = $this->os_model->get_selected($unitid, $type);

		$data->outcomes_dep = FALSE;
		$data->outcomes_dep = $this->os_model->get_outcomes_bydep($courseid, $type);
		$data->selected_dep = $this->os_model->get_selected($unitid, $type, true);

		//check skill(s) for unit page
		if ($data->outcomes !== false && !empty($data->outcomes) ) {
			$isnull = true;
			foreach ($data->outcomes as $rows ) {
				if (isset($rows->skillsid)) {
					if ($rows->skillsid != NULL)
						$isnull = false;
				}
			}
			if ($isnull)
				$data->outcomes = false;
		}

		/* don't check no data but show error in view file
		if ($data->outcomes === FALSE && $data->outcomes_dep === FALSE) {
			echo osa_ajaxmsg(lang('gen_internalservererror'));
			exit;
		}
		*/

		$this->load->view('unit/unit_osadd_view', $data);
	}

	function update ($unitid, $type) {
		if ( !is_numeric($unitid) || !is_numeric($type) ) {
			$this->load->view('template/ajax_error_view',
				array('errormsg' => lang('unit_no_permissionmsg'), 'divid' => 'learningtarget'));
			return;
		}
		//Only editors can run this, exits if false
		if ( ($unit = $this->unit_model->check_unit_editaccess($unitid)) === FALSE) {
			$this->load->view('template/ajax_error_view',
				array('errormsg' => lang('gen_internalservererror'), 'divid' => 'learningtarget'));
			return;
		}

		$keys = array_keys($_POST);
		$pattern = 'lt';
		$ids = array();
		$sep = '';
		foreach($keys as $key) {
			$tok = strtok($key,'_');
			if ($tok==$pattern) {
				$formid = strtok('_');
				if ( is_numeric($formid)) {
					//$ids .= $sep . $formid;
					//$sep=',';
					if ( is_numeric($_POST[$key]) )
						$ids[$formid] = $_POST[$key];
				}
			}
		}

		if ( ($this->lt_model->update($unitid, $type, $ids)) === FALSE ) {
			echo osa_ajaxmsg(lang('unit_failedtoadddata'));
			exit;
		}
		echo 'success';
		exit;
	}

	function delete($unitid, $targetid) {
		if ( !$this->os_model->delete($unitid,$targetid) ) {
			echo osa_ajaxmsg(lang('unit_failedtodeletedata'));
      	exit;
		}
	}

	function save($unitid, $type) {
		$keys = array_keys($_POST);
		$pattern = 'os';
		$addids = array();
		$sep = '';
		$result = '';
		foreach($keys as $key) {
			$tok = strtok($key,'_');
			if ($tok==$pattern) {
				$formid = strtok('_');
				if ( is_numeric($formid)) {
					if ( $_POST[$key] != '' ) {
						 $outcomeid    = str_replace( $tok.'_'.$formid.'_', "", $_POST[$key] );
						 $addids[$formid] = $outcomeid;
					} else
						 $delids[$formid]= $formid;
				}
			}
		}

		$result = $this->os_model->save($unitid, $type, $addids, $delids);

		return FALSE;
	}

}
?>