<?php
/**
 * table.php - Handles update of the display list table. The is generic code that applies to all implementations.
 *             Basically, this making all new feature that requires table list and paging extremely easy to implement.
 *             This was not meant to handle lasrge set of data and we don't expect to have large result sets
 *             due to the nature of the application. This is extremely fast for small result sets.
 *             Once it gets close to 10K records then things start to get slow :( ...
 *             We may need to implement database paging later and make it smart to switch between the 2 based on
 *             the size of the result set. This is not difficult once all the code clean up is done and everything is encapsulated...
 *
 * @author $Author: dtong $
 * @version $Id: table.php,v 1.2 2011/04/11 07:01:59 dtong Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/
require_once(APPPATH . 'libraries/mapping/display_list.php');

class Table extends CI_Controller {
   private $CI;

   function __construct() {
      parent::__construct();
      $this->CI = & get_instance();
      $this->CI->load->library('search/searchutil');
   }

   //Prints the displaylist table only, this gets call when the user sorts a column
   function index($session_name, $sort_col, $sort_action) {
      if ( empty($session_name) || !osa_is_int($sort_col) || !osa_is_int($sort_action) || $sort_col < 0 || $sort_action < 0) {
         echo osa_ajaxmsg(lang('gen_internalservererror'));
         exit;
      }
      $display = & $this->CI->searchutil->get_session($session_name);
      $display->default_col = $sort_col;
      $display->sort_direction = $sort_action;
      $display->change_sort_direction = TRUE;
      $display->prepare_page();
      $data = new stdClass();
      $data->display = $display;
      $this->load->view('mapping/display_list_view', $data);
      //$display->save_session();
   }

   //Prints the full view and refreshes the whole page, for paging
   function fullview($session_name, $page_number) {
   	if ( empty($session_name) || !osa_is_int($page_number) || $page_number < 1) {
   		echo osa_ajaxmsg(lang('gen_internalservererror'));
   		exit;
   	}
   	osa_load_lang('login');
      $this->CI->load->library('form_validation');

   	$display = & $this->CI->searchutil->get_session($session_name);
   	$display->current_page = $page_number;
      $display->prepare_page();
      $display->load_view();
      //$display->save_session();
   }
}