<?php
/**
 * search.php - FILE_DESCRIPTION_HERE
 *
 * @author $Author: dtong $
 * @version $Id: search.php,v 1.6 2011/02/11 09:09:27 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Search extends CI_Controller{
	function __construct() {
		parent::__construct();
		osa_nosession_ajax_redirect();
	}

	/*
	 * This uses dynamic library loading to handle the search.
	 * The dynamic library is designed to support saved searches.
	 * Save $_REQUEST and the library name in the DB and you can perform the same search again.
	 */
	function get($handle, $searchid, $flag_session=FALSE ) {
		//echo $flag_session;
		$this->CI = get_instance();
		$this->CI->load->model('sort/searchsort_model');
		//if ($flag_session==FALSE)
		//	$sql_array
		$sql_array = $this->CI->searchsort_model->getSqlSession('map_' . $handle);
		//VAR_DUMP('map_'.$handle);
		$sql_array['type'] = $flag_session;
		$this->CI->searchsort_model->setSqlSession('map_' . $handle, $sql_array);

		$lib = "mapping/Handle_{$handle}";
		$obj = "handle_{$handle}";
		if ( !osa_lib_exists($lib) ) {
			osa_errorlog(__METHOD__ . " - Invalid search handle $handle");
			echo osa_ajaxmsg(lang('gen_internalservererror'));
			exit;
		}
		$this->load->library($lib, array('request'=>$_REQUEST, 'searchid'=>$searchid));
		$this->$obj->process();
	}

	function normal($handle, $searchid ) {
		$this->get($handle, $searchid, CMS_MAPPING_NORMAL);
	}

	function course($handle, $searchid ) {
		$this->get($handle, $searchid, CMS_MAPPING_COURSE);
	}

	function grade($handle, $searchid ) {
		$this->get($handle, $searchid, CMS_MAPPING_GRADE);
	}
}
?>