<?php
/**
 * team.php - Controller for handling input pages.
 *
 * @author $Author: dtong $
 * @version $Id: team.php,v 1.6 2011/02/16 11:47:33 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
 */
require_once(APPPATH . 'libraries/mapping/display_list.php');

class Team extends CI_Controller{
	function __construct() {
		parent::__construct();
		$this->access_model->checkaccess_any('goal_read');
		osa_load_lang('admin');
		$this->load->model('admin/admin_course_model');
		$this->load->library('admin/admin_base');
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->load->model('sort/searchsort_model');
		osa_load_lang('goal');
		$this->load->model('goal/goal_model');
	}


	function select2($mode=FALSE,$goalid=FALSE,$type=FALSE, $editors=FALSE) {
		//$creatornameobj = $this->goal_model->get_goal_creator($goalid);
		$creatornameobj = $this->goal_model->get_creator($goalid);
		//return;
		$usertypeobj = $this->goal_model->get_goal_user_type($goalid,$this->get_userid());
		$goalobj = $this->goal_model->get_goal($goalid);
		$teammember = FALSE;
		$teammember = $this->goal_model->get_team_member($goalid);

		//	echo '<pre>'; print_r($teammember); echo '</pre>';
		$notin_ids  = array();
		//$creator_id[]  = $creatornameobj->id;

		if ($creatornameobj != FALSE) {
			foreach ($creatornameobj as $creator) {
				$notin_ids[] = $creator->id;
				$data->creatorname = $creator->displayname;
			}
		}

		if ( $teammember !=FALSE ) {
			foreach ($teammember as $value)
			$notin_ids[] = $value->id;
		}



		$data->type = $type;
		$data->title	= $goalobj->title;
		$data->descid 		= 0;
		$data->user       = $this->goal_model->get_user($notin_ids);

		$data->selectlistitem = $teammember;

		$data->show_editorbox = $this->config->item('cms_goal_show_editorbox');
		$data->iseditor = true;

		//	$checked = form_checkbox('editor[]', $teammember, FALSE, '');
		//$data->checked   	= $checked;

		//$data->usertype = $usertypeobj->iseditor;
		$data->goalid   	= $goalid;
		$data->mode   	= $mode;

		$this->load->view('goal/user_team_view',$data);
	}
	function select($goalid=FALSE, $action=FALSE) {
		//check number
		//$creatornameobj = $this->goal_model->get_goal_creator($goalid);
		$creatornameobj = $this->goal_model->get_creator($goalid);
		//return;
		$usertypeobj = $this->goal_model->get_goal_user_type($goalid,$this->get_userid());
		//$goalobj = $this->goal_model->get_goal($goalid);
		$goalobj = $this->goal_model->get_entry_bygoal($goalid);
		$teammember = FALSE;
		$teammember = $this->goal_model->get_team_member($goalid);

		//	echo '<pre>'; print_r($teammember); echo '</pre>';
		$notin_ids  = array();
		//$creator_id[]  = $creatornameobj->id;
		if ($creatornameobj != FALSE) {
			foreach ($creatornameobj as $creator) {
				$notin_ids[] = $creator->id;
				$data->creatorname = $creator->displayname;
			}
		}

		if ( $teammember !=FALSE ) {
			foreach ($teammember as $value)
			$notin_ids[] = $value->id;
		}
		$data->goalid = $goalobj->goalid;
		$data->type = $goalobj->type;
		$data->title = $goalobj->title;
		$data->descid = 0;
		$data->user = $this->goal_model->get_user($notin_ids);
		$data->selectlistitem = $teammember;
		$data->show_editorbox = $this->config->item('cms_goal_show_editorbox');
		$data->iseditor = true;
		$data->action = $action;

		if ($action == CMS_ACTION_READ)
			 $data->url_mode = 'read_goal';
		elseif ($action == CMS_ACTION_EDIT)
			 $data->url_mode = 'edit_goal';


		//	$checked = form_checkbox('editor[]', $teammember, FALSE, '');
		//$data->checked   	= $checked;

		//$data->usertype = $usertypeobj->iseditor;

		//$data->mode   	= $mode;

		$this->load->view('goal/user_team_view',$data);
	}

	function insert_member($goalid) {
		if (is_numeric($goalid) == FALSE)
			 return FALSE;
		$data = FALSE;
		$value = '';

		if (isset($_POST['userid'])){
			$sep = '';
			foreach ($_POST['userid'] as $row) {
				$userid = $row;
				$value .= $sep."($userid,$goalid)";
				$sep = ',';
			}
			$action = $_POST['action'];
		   $type = $_POST['type'];
			if ($this->goal_model->insert_team_member($value))
				 $this->select($goalid,$action);
		}
	}

	function delete_member($goalid, $userid) {
		$action = $_POST['action'];
		$type = $_POST['type'];
		if ($this->goal_model->delete_team_member($goalid,$userid))
		 $this->select($goalid,$action);
	}

	function set_editor_member($goalid) {
		if (is_numeric($goalid) == FALSE)
			return FALSE;

		$data = FALSE;
		$members = $_POST['editorlist'];
		$team = $this->goal_model->get_team_member($goalid);

		$iseditor = array();
		$editor_members = array();
		$normal_members = array();

		if (isset($team) && isset($members)){
			foreach ($team as $value)
				$iseditor[$value->id] = $value->iseditor;

			if (!$this->config->item('cms_goal_multi_editor')) {
				foreach ($iseditor as $id => $value) {
					if (in_array($id, $members) && !$value)
						 $editor_members[] = $id;
					else
						 $normal_members[] = $id;
				}
			}
			else {
				foreach ($iseditor as $id => $value) {
					 if (in_array($id, $members))
						 $editor_members[] = $id;
					 else
					 	 $normal_members[] = $id;
				}
			}
		}

		if (count($normal_members) > 0) {
			 $data->iseditor = FALSE; // set normal member
			 $this->goal_model->update_team_member($goalid,$normal_members,$data);
		}

		if (count($editor_members) > 0) {
			 $data->iseditor = TRUE; // set editor member
			 $this->goal_model->update_team_member($goalid,$editor_members,$data);
		}
		$action = $_POST['action'];
		$type = $_POST['type'];
		$this->select($goalid,$action);
	}

	private function get_userid(){
		$user = FALSE;
		if ( ($user = $this->login_model->getLogin()) !== FALSE )
		return $user->id;
		return FALSE;
	}
}
?>