<?php
/**
 * list_types.php - List all the template types, intended for developers.
 *
 * @author $Author: dtong $
 * @version $Id: list_types.php,v 1.2 2011/05/09 04:48:53 dtong Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/

class List_types extends CI_Controller{

	function __construct() {
		parent::__construct();
		//Have to login first and then run this controller manually.
		$this->access_model->checkaccess_any('admin_system_management', FALSE, FALSE);
		$this->load->library('cms/cms_template/cms_template');
	}

	function index() {
		global $g_template_id_array;
		$all_types = array();
		foreach($g_template_id_array as $templateid) {
			$filenames = $this->cms_template->templateid_filenames($templateid);
			if ( $filenames ) {
				foreach ($filenames as $filename) {
					$types = $this->cms_template->types($filename);
					echo "{$templateid}/{$filename} - " . $types . '<br /><br />';
					$all_types = array_merge($all_types, explode(',', $types));
				}
			}
		}

		$tmp = array();
		foreach($all_types as $value) {
			if ( array_key_exists($value, $tmp) ) {
				echo "<div style='color:red'>Duplicated type: $value</div>";
			}
			$tmp[$value] = $value;
		}
		sort($tmp);
		echo "<br />All Types:<br /><br /><div style='width:500px'>";
		echo implode(', ', $tmp) . '</div>';
	}
}