<?php
/**
 * chartlist.php - List units resulted from clicking on a pie slice
 *
 * @author $Author: dtong $
 * @version $Id: chartlist.php,v 1.21 2011/05/31 10:47:55 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Chartlist extends CI_Controller {

	function __construct() {
		parent::__construct();
		osa_nosession_ajax_redirect();
		$this->load->model('mapping/unit_select_model');
		$this->load->model('sort/searchsort_model');
		$this->CI = get_instance();
	}

	function get($uniqueid, $select_type, $selected_id) {

		//we piggyback on handle_graph so we can access the template data easily
		$this->load->library('mapping/handle_graph', array('request'=>array('dummy data'), 'searchid'=>$uniqueid));

		$divid = $this->handle_graph->get_inputvalue('_chart_divid');
		$sql = $this->session->userdata('sql_' . $divid);
		if ( !$sql || !is_numeric($selected_id) ) {
			echo osa_ajaxmsg(lang('gen_internalservererror'));
			exit;
		}
		//$sql = sprintf($sql, $selected_id); //param %s more than one
		$sql = str_replace('%s', $selected_id, $sql);
		$res = $this->unit_select_model->run_query($sql);
		//var_dump($res);
		//exit;
		$display = & $this->handle_graph->get_display_obj();
		$select_categories = $this->handle_graph->get_templatevalue('_data_category');
		$selections = $this->handle_graph->get_templatevalue('_data');
		$selections = osa_value($selections, $select_type, FALSE);
		$display->pagetitle = $this->handle_graph->get_templatevalue('_result_title') . ' (' .
			osa_value($select_categories,$select_type,FALSE) . ' - ' . osa_value($selections,$selected_id,FALSE) . ')';
		if ( $this->handle_graph->get_templatevalue('_data_category') == FALSE){
			$display->pagetitle = $this->handle_graph->get_templatevalue('_result_title') . ' (' .$select_type. ')';
		}
		$display->titles = array(lang('map_course'),lang('map_unit'),$this->handle_graph->get_templatevalue('_result_desc_title'));
		//Set the size for each TD
		$display->widths = array(200,200,500);

		$show_unit_template = osa_unit_template();
		$_use_column_unit_type = $this->handle_graph->get_templatevalue('_use_column_unit_type');
		if ( $show_unit_template != FALSE && $_use_column_unit_type != FALSE) {
			$display->titles[] =	lang('map_unit_type');
			$display->widths[] = '5%';
		}

		$display->divid = $this->handle_graph->get_templatevalue('_result_divid');
		//$display->closebutton = TRUE; //divid has to be defined for this to work
		if ( $res ) {
			$this->handle_graph->add_urllink_template_str(1, $display);
			foreach ( $res as $item ) {
				$data = array($item->coursename, $item->unit_title, strip_tags(html_entity_decode($item->res_description)));
				if ($_use_column_unit_type != FALSE && isset($item->template)){
					$unit_typ =lang('unit_typename_'.$item->template);
					$data[] = $unit_typ;
				}
				$this->handle_graph->add_hidden_data(1, $data, "'$item->unitid','$item->unitid'");
				$display->add($data);
			}
		}
		//$add_js = "showDhtmlWindow('". $this->handle_graph->get_inputvalue('_divid') . "');";
		//We are using event handles prepareDhxwinFlipDisplay() to hide/show in the javascript now.
		$add_js = '';

		$data = array();
		$data['_divid']       = $this->handle_graph->get_inputvalue('_divid');
      $data['_default_col'] = $this->handle_graph->get_templatevalue('_default_col');
      $data['_default_img'] = $this->handle_graph->get_templatevalue('_default_img');;
      $this->searchdata = array();
		$this->searchdata['_data']     = $data;
		$this->searchdata['_uniqueid'] = $uniqueid ;

		$display->iswindow = TRUE;
      $display->force_sort = TRUE;
      $display->prepare_page();
      $data = new stdClass();
      $data->display = $display;
      //Usually the $display object is related to the PHP session but this one gets it
      //from the graph so we have to manually start the PHP session here
      //We don't use much of the PHP session (at least by design...) so try to keep
      //overhead low by not always start the PHP session.
      //osa_php_session_start();

      //The view needs the PHP session ID for PDF generation
      echo $this->CI->load->view('mapping/result_list_view', $data, TRUE);
      //$display->save_session();
	}
}
?>