<?php
/**
 * User_role.php - Controller for handling user role pages.
 *
 * @author $Author: Samarth
 * @version $Id: User_role.php
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

class User_role extends CI_Controller{
	function __construct() {
		parent::__construct();
			 $this->access_model->checkaccess_any('admin_system_management');
			 osa_load_lang('user_role');
		    $this->load->model('admin/admin_user_role_model');
		    $this->load->helper('form');
		    $this->load->library('form_validation');
		    osa_php_session_start();
	}

	function index($type, $schoolid='null', $departmentid='null', $group='null', $override_title=FALSE) {
		if ( !is_numeric($type) )
			return;
		if ( !is_numeric($departmentid) && $departmentid != 'null' )
			$departmentid = 'null';
		if ( !is_numeric($schoolid) && $schoolid != 'null' )
			$schoolid = 'null';
		$data = FALSE;
		$data->type = $type;
		$data->departmentid = $departmentid;
		$data->schoolid = $schoolid;
		$data->group = $group;
		$data->title_lang = lang('user_role_win_title_'.$type);
		if ( $override_title )
			$data->title_lang = rawurldecode($override_title);

		$data->header_left_lang = lang('user_role_header_left');
		$data->header_right_lang = lang('user_role_header_right');
		$data->href_insert = base_url().'admin/user_role/insert_user_role/';
		$data->href_delete = base_url().'admin/user_role/delete_user_role/';
		$data->button_done_lang = lang('user_role_btn_done');
		$data->button_disable_lang = lang('user_role_btn_disable');
		$data->button_assign_lang = lang('user_role_btn_assign');
		$data->msg_delete_lang = lang('user_role_msg_delete');
		$data->footer_lang = lang('user_role_footer');

		if ( $schoolid == 'null' )
			$schoolid = NULL;
		if ( $departmentid == 'null' )
			$departmentid = NULL;
		$user_role = $this->admin_user_role_model->get_user_role($type,$schoolid,$departmentid);
		$userrole_ids  = array();
		if ( isset($user_role) && $user_role != FALSE ) {
			foreach ($user_role as $value)
				$userrole_ids[] = $value->userid;
		}
		$data->left = $this->admin_user_role_model->get_user($userrole_ids);
		$data->right = $user_role;
		$this->load->view('admin/admin_select_view',$data);

	}
	function insert_user_role() {
		$data = FALSE;
		$value = '';
		$type = $_POST['type'];
		$departmentid = $_POST['departmentid'];
		$schoolid = $_POST['schoolid'];
		$group = $_POST['group'];
		$title = $_POST['title'];

		if ( !is_numeric($type) )
			return;
		if ( !is_numeric($departmentid) && $departmentid != 'null' )
			$departmentid = 'null';
		if ( !is_numeric($schoolid) && $schoolid != 'null' )
			$schoolid = 'null';

		if ( !is_array($_POST['userid']) || count ($_POST['userid']) < 1 )
			return;

		if ( $this->admin_user_role_model->insert_user_role($_POST['userid'], $type, $schoolid, $departmentid, $group) )
			 $this->index($type, $schoolid, $departmentid, $group, $title);
	}

	function delete_user_role($roleid) {
		$type = $_POST['type'];
		$departmentid = $_POST['departmentid'];
		$schoolid = $_POST['schoolid'];
		$group = $_POST['group'];
		$title = $_POST['title'];

		if ( !is_numeric($type) )
			return;
		if ( !is_numeric($departmentid) && $departmentid != 'null' )
			$departmentid = 'null';
		if ( !is_numeric($schoolid) && $schoolid != 'null' )
			$schoolid = 'null';
		if ($this->admin_user_role_model->delete_user_role($roleid))
		 $this->index($type, $schoolid, $departmentid, $group, $title);
	}
}
