<?php
/**
 * standard.php - Controller for handling input pages.
 *
 * @author $Author: dtong $
 * @version $Id: standard.php,v 1.43 2011/05/09 11:59:58 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

require_once(APPPATH . 'libraries/mapping/display_list.php');
class Standard extends CI_Controller{
	//The form ids are same as DB column names. Limit table update to these keys only.
	private $allowed_post_keys = array('strandid','type','enabled','importid','data');
	//This is used as the session variable name. All admin features use this name
   private $divid = 'standard'; //Used to be 'standard'
   //To start a new display session or not
   private $new_display_session = FALSE;

	function __construct() {
		parent::__construct();
		$this->access_model->checkaccess_any('admin_system_management');
		    $this->load->model('admin/standard_model');
		    $this->load->helper('form');
		    osa_load_lang('admin');
		    $this->load->library('admin/admin_base');
		    $this->load->library('menu/menu_main');
		    $this->load->library('form_validation');
		    $this->load->model('sort/searchsort_model');
		    osa_php_session_start();
	}

	//menu tempalte $index can be just an int or int_int like 7_2. The 2nd int is for sub index other than 1
	function index($type,$index,$index_benchmark,$page_con='page_content') {
		if (!is_numeric($type) )
			return FALSE;
		$this->new_display_session = TRUE;
		$this->refresh(CMS_ADMIN_ENABLE, $type, $page_con, FALSE, FALSE,FALSE,$index,$index_benchmark);
	}
	// Link strand page.
	function link($type,$index,$page_con='page_content',$dep_schid, $strandid,$index_benchmark) {
		if (!is_numeric($type) )
			return FALSE;
		$this->new_display_session = TRUE;
		$this->refresh(CMS_ADMIN_ENABLE, $type, $page_con, $dep_schid, $strandid,FALSE,$index,$index_benchmark);
	}

	function refresh($enableflag, $type=FALSE,$page_con=FALSE, $dep_schid=FALSE,
						  $strandid=FALSE, $filter=FALSE,$index=FALSE,$index_benchmark=FALSE) {
	 	//if ($enableflag== FALSE || is_numeric($enableflag) == FALSE && isset($_POST['filters'])) {
	 		//$enableflag = $_POST['filters'];
	 	//}
		if ( $enableflag != CMS_ADMIN_DISABLE && $enableflag != CMS_ADMIN_ENABLE && $enableflag != CMS_ADMIN_ALL ) {
			echo osa_ajaxmsg(lang('gen_internalservererror'));
			exit;
		}

		$this->CI = get_instance();
   	//Add Config
   	//$divid = 'standard' ;
   	//$formname = 'admin_search_form_'.$divid;
   	$formname = 'admin_search_form_standard';
		$url_add	= 'admin/standard/add/'.$enableflag;
		$div = 'standard_input_standard';
		$width = 600;
		$height = 400;
		$title_add = lang('admin_standard_add_title');
		//$display = $this->admin_base->init_display(CMS_ADMIN_STANDARD_TYPE, $enableflag,$this->divid);
		if ( $this->new_display_session ) {
			$display = & $this->admin_base->init_display(CMS_ADMIN_STANDARD_TYPE, $enableflag, $this->divid);
			$display->column_use_striptag[1] = TRUE;
		}
		else {
			$this->load->library('search/searchutil');
			$display = & $this->searchutil->get_session($this->divid);
			$display->reset_data();
		}
		$_title = FALSE;
   	$_schoolflag = FALSE;
   	if ($index == FALSE){
			$temp  = $this->CI->searchsort_model->getSort($this->divid);
			$index = $temp->index;
   	}
   	$display->index = $index;

   	if ($index_benchmark == FALSE){
			$temp  = $this->CI->searchsort_model->getSort($this->divid);
			$index_benchmark = $temp->index_benchmark ;
   	}
		$display->index_benchmark = $index_benchmark;

		//Hack to allow the sub/second index to pass in
		$sub_index = 1;
		if ( $index !== FALSE ) {
			$tmp_index = explode('_',$index);
			if ( count($tmp_index) > 1 ) {
				$index = $tmp_index[0];
				$sub_index = $tmp_index[1];
			}
		}

   	$temp = $this->menu_main->get_template('admin');
		$template = $temp[$index][$sub_index];
		if (osa_get_template_value($template,'_title') != FALSE )
			$_title  = osa_get_template_value($template,'_title');
		if (osa_get_template_value($template,'_schoolflag') != FALSE )
			$_schoolflag  = osa_get_template_value($template,'_schoolflag');
		$_table = FALSE;
		if (osa_get_template_value($template,'_table') != FALSE )
			$_table  = osa_get_template_value($template,'_table');

		$display->table = $_table;
		$display->pagetitle = $_title;
   	$display->schoolflag = $_schoolflag;

		$imgaddtitle = lang('admin_standard_title_add_dis_11');
		if (isset($_schoolflag) && $_schoolflag != FALSE)
			$imgaddtitle = lang('admin_standard_title_add_dis_8');
		$imgaddname	= osa_imagepath() . 'add_dis_24.gif';
		$imgeadd = "<a><img src=\"$imgaddname\" title=\"$imgaddtitle\" border='0'></a>";

		if ((isset($_POST['dep_schid']) && $_POST['dep_schid']!=0) || $dep_schid!=FALSE){
			$imgaddname	= osa_imagepath() . 'add_24.gif';
			$imgaddtitle = lang('admin_standard_title_add');
			$imgeadd = $this->admin_base->newDhtmlWindow($url_add, $title_add, $width, $height, $div , $imgaddname,$imgaddtitle );
		}

	   $display->type = $type;
	   $display->filter=FALSE;
	   if ($filter != FALSE)
			$display->filter = $filter;
		else {
			if (isset($_POST['filter']))
				$display->filter = $_POST['filter'];
		}

	   $page	= 'page_content';
	   $lnkdiv = 'benchmark_list';
		$display->lnkdiv = $lnkdiv;
		//$display->refresh = $divid . '_list';
		$display->refresh = 'standard_list';
		$display->selectid = FALSE;
		$display->dep_schid = FALSE;

		if ($page_con == 'page_content')
			$display->refresh  = $page;
		if ($strandid != FALSE)
			$display->selectid = $strandid;
		else {
				if (isset($_POST['strandids']))
				$display->selectid = $_POST['strandids'];
		}

		if ($dep_schid != FALSE)
			$display->dep_schid = $dep_schid;
		else {
			if (isset($_POST['dep_schid']))
				$display->dep_schid = $_POST['dep_schid'];
		}

		//keep last department and clear strand
		$display->filter_key_1 = false;
		if (isset($_POST['filter_key_1']) && is_numeric($_POST['filter_key_1']) && $_POST['filter_key_1'] != $display->dep_schid ) {
			$display->filter_key_1 = $_POST['filter_key_1'] ;
			$display->selectid = FALSE;
		}
		$display->filter_key_1 = $display->dep_schid;

   	$display->menu = lang('admin_menu_standard');
   	$display->search = lang('admin_standard_search');
   	$display->pagetitle = $_title;
   	$display->titles = array(lang('admin_standard_display_strand'),
   				                lang('admin_standard_display_standard'),
   				                lang('admin_standard_display_enabled'),
   				                $imgeadd
   					          );
		$display->widths = array('32%', '55%', '10%', '3%');
		if (isset($_schoolflag) && $_schoolflag != FALSE){
			$display->search_dep_sch = lang('admin_search_school');
			$data_dep_sch = $this->standard_model->get_school($type,$display->dep_schid,$_table);
			$display->data_dep_sch = $this->standard_model->get_school($type,FALSE,$_table);
			$display->strand = $this->standard_model->get_strand($display->type,FALSE,$display->dep_schid );
			$data = $this->standard_model->get_allstandard($enableflag,$display->type,$display->filter,FALSE,$display->dep_schid, $display->selectid,$_table );
			$display->notice = lang('admin_standard_add_schoolnotice');
		}
		else{
			$display->search_dep_sch = lang('admin_search_department');
			$data_dep_sch = $this->standard_model->get_department($display->dep_schid );
			$display->data_dep_sch = $this->standard_model->get_department();
			$display->strand = $this->standard_model->get_strand($display->type,$display->dep_schid);
			$data = $this->standard_model->get_allstandard($enableflag,$display->type,$display->filter,$display->dep_schid,FALSE, $display->selectid );
			$display->notice = lang('admin_standard_add_departmentnotice');
		}
		if (is_array($data_dep_sch)){
			//$row=$data_dep_sch[$display->dep_schid ];
			$display->dep_search = $data_dep_sch[$display->dep_schid];
		}

		//TODO: Both are the same value...
		$display->enableflag = $enableflag;
		$display->selectlistitem = $enableflag;

		$display->standard =array();
		$splits = $this->admin_base->split($display->filter);
		if ($data != FALSE) {
			//Loop thru each standard
			foreach ($data as $rows) {
				$enabled = $rows->enabled;
				if ($rows->enabled == CMS_ADMIN_DISABLE){
					 $rows->enabled = '<div class="hide">'.lang('admin_list_convert_disabled').'</div>';
				    $imgdelname = osa_imagepath() . 'enabled_16.gif';
				    $imgdeltitle = lang('admin_standard_title_enable');
			    	 $massage = lang('admin_standard_message_enable');
				}elseif ($rows->enabled == CMS_ADMIN_ENABLE){
					 $rows->enabled = '<div class="show">'.lang('admin_list_convert_enabled').'</div>';
				    $imgdelname = osa_imagepath() . 'disable_16.gif';
				    $imgdeltitle = lang('admin_standard_title_disable');
			    	 $massage = lang('admin_standard_message_disable');
				}

				//Edit Config
				$url_edit = 'admin/standard/edit/'.$rows->id.'/'.$enableflag;
				$title_edit	= lang('admin_standard_edit_title');
				$imgeditname = osa_imagepath() . 'edit_16.gif';
				$imgedittitle = lang('admin_standard_title_edit');

				//Link Config
				$lnkwidth = 800;
				$lnkheight = 750;

				if (isset($_schoolflag) && $_schoolflag != FALSE){
					$url_lnk	= 'admin/benchmark/index/'.$display->type.'/'.$index_benchmark.'/'.'0'.'/'.$rows->schoolid.'/'.$rows->strandid.'/'.$rows->id;
				}
				else{
					$url_lnk	= 'admin/benchmark/index/'.$display->type.'/'.$index_benchmark.'/'.'0'.'/'.$rows->departmentid.'/'.$rows->strandid.'/'.$rows->id;
				}

				$title_lnk = $_title;
				$linktitle = lang('admin_standard_link_title');

				//Delete Config
				$url_del	= 'admin/standard/delete/'.$rows->id.'/'.$enabled.'/'.$enableflag.'/'.$display->type;

				if ( $this->config->item('cms_lt_importid_support') && !empty($rows->standard_importid) ) {
					$highlight_name = $this->admin_base->highlight($splits, "$rows->standard_importid $rows->data");
				}
				else {
					$highlight_name = $this->admin_base->highlight($splits, $rows->data);
				}

			    $linkname = $this->admin_base->linkDhtmlWindow($url_lnk, $title_lnk, $lnkwidth, $lnkheight, $lnkdiv ,$highlight_name,$linktitle );
			    $imgedit  = $this->admin_base->newDhtmlWindow($url_edit, $title_edit, $width, $height, $div , $imgeditname,$imgedittitle );
			    $imgdel   = $this->admin_base->delTarget($url_del, $display->refresh  ,$massage,$imgdelname, $imgdeltitle,$formname);
			    //$imgedit  = '<span class="standard_col_body_center_edit">' .$imgedit. '</span>';
			    //$imgdel   = '<span class="standard_col_body_center_del">'  .$imgdel. '</span>';
			    if ( $this->config->item('cms_lt_importid_support') && !empty($rows->strand_importid) ) {
			    		$strand_name = "{$rows->strand_importid} {$rows->strand}";
			    }
			    else {
			    		$strand_name = $rows->strand;
			    }
			    //Only check department_enabled if we have a valid department id since
			    //some records in table strand are not related to department table
			    if ( (!$rows->department_enabled && !empty($rows->departmentid)) || !$rows->strand_enabled ) {
			   	 $strand_name = "<font color=\"grey\">{$strand_name}</font>";
			    }
			    $temp = array($strand_name, $linkname, $rows->enabled, "<nobr>$imgdel $imgedit</nobr>");
				 $display->add($temp);
			}
		}
		if ( $this->new_display_session ) {
			$display->default_col = 1;
		}
	   $this->admin_base->load_view($display);
	}

	//Inserts/adds a new standard
	function insert() {
	   $this->form_validation->set_rules('data', 'Standard', 'trim|required') ;
	   $this->form_validation->set_rules('strandid', 'Strand ID', 'trim|required|is_numeric') ;
		$run_result = $this->form_validation->run();
		$strand = set_value('strandid');
		if ( !$run_result || $strand <=0 ) {
	 		echo osa_ajaxmsg(lang('admin_standard_error'));
		   exit();
		}
		$data = array();
	   $keys = array_keys($_POST);
	   foreach ($keys as $key) {
	   	$lower_key = strtolower($key);
			if ( !in_array($lower_key, $this->allowed_post_keys) ) {
				continue;
			}
     	 	$value = trim($_POST[$key]);
     	  	$key = strtolower($key);
     	 	if ($key == 'enabled') {
    	  		if ($value == 'on') {
    		 	 	$value = 1;
    	  		}
    		 	else {
    			 	$value = 0;
    		 	}
     	 	}
	   	/*elseif ($this->config->item('cms_lt_importid_support') && $lower_key == 'importid') {
	   		$data['importid_int'] = NULL;
				if ( !empty($value) ) {
					$bigint = osa_dotnum2int($value);
					if ( $bigint !== FALSE ) {
						$data['importid_int'] = $bigint;
					}
				}
	      } */
    		$data[$lower_key] = $value;
	   }
		$result=$this->standard_model->add_standard($data);
		if ($result==1)
			$result = 'success';
		echo $result;
	}

	//Updates a standard record
	function update() {

		$this->form_validation->set_rules('data', 'Data', 'required') ;
	   $this->form_validation->set_rules('strandid', 'Strand ID', 'trim|is_numeric') ;
	   $this->form_validation->set_rules('id', 'Current Standard', 'trim|is_numeric') ;
		$run_result = $this->form_validation->run();
		$strand_id = set_value('strandid');

		if ( !$run_result || $strand_id <= 0 ) {
	 		echo osa_ajaxmsg(lang('admin_standard_error'));
		   exit();
		}

		$data = array();
	   $keys = array_keys($_POST);
		$standardid = set_value('id');
	   foreach ($keys as $key) {
	     	$lower_key = strtolower($key);
	   	if ( !in_array($lower_key, $this->allowed_post_keys) ) {
				continue;
			}
			$value = trim($_POST[$key]);
	     	if ($lower_key == 'enabled') {
	    	  	if ($value == 'on') {
	    		 	$value = 1;
	    	  	}
	    		else {
	    			$value = 0;
	    		}
	     	}
			/* else {
				if ( $this->config->item('cms_lt_importid_support') && $lower_key == 'importid' ) {
	    			if ( !empty($value) ) {
						$bigint = osa_dotnum2int($value);
						if ( $bigint !== FALSE ) {
							$data['importid_int'] = $bigint;
						}
					}
    			}
			} */
			$data[$lower_key] = $value;
	   }

		$result=$this->standard_model->update_standard($standardid,$data);
		if ($result==1) {
			$result = 'success';
		}
		echo $result;
	}

   function add($enableflag=FALSE) {
        $this->edit(FALSE, $enableflag, CMS_ADMIN_ADD);
	}

	function edit($standardid, $list, $action=CMS_ADMIN_EDIT) {
		if ( is_numeric($list) == FALSE || $list < CMS_ADMIN_DISABLE || $list > CMS_ADMIN_ALL ) {
			// show error message
			echo 'error list';
			return FALSE;
		}
		 $this->CI =  get_instance();
	    $data = FALSE;
	    //$divid = 'standard' ;
	    $temp = $this->CI->searchsort_model->getSort($this->divid);
	    $data->page = $this->admin_base->getpage(CMS_ADMIN_STANDARD_TYPE);
       $data->selectlistitem = $list;

       if (isset($temp->schoolflag) && $temp->schoolflag != FALSE ){
       		$data->strand = $this->standard_model->get_strand($temp->type,FALSE,$temp->dep_schid );
       }
       else{
       	 	$data->strand = $this->standard_model->get_strand($temp->type, $temp->dep_schid);
       }
	   $data->type = $temp->type;
	   $data->selectid = $temp->selectid;
	   if ($data->selectid == FALSE || $data->selectid == '')
	   	$data->selectid ='0';

	   $data->dep_schid = $temp->dep_schid;
	   if ($data->dep_schid ==FALSE || $data->dep_schid =='')
	   	$data->dep_schid ='0';

	   $data->filter=$temp->filter;
    	if ($temp->filter==FALSE && $temp->filter=='')
    		$data->filter = FALSE;
    	$_table = FALSE;
	  	if (isset ($temp->table) && $temp->table != FALSE)
	  		$_table = $temp->table;

		$data->update_div	= $temp->refresh;
		$data->divid = $temp->divid;
		$data->action = $action;

	    if ($action == CMS_ADMIN_EDIT ) {
			$standard = $this->standard_model->get_standard($standardid,1,FALSE,$_table);
			if ($standard==FALSE || count($standard)==0) {
				// show error message
				echo 'show error message: no data';
				return FALSE;
			}

   		$data->data  = $standard;
   		$row= $standard[0];
   		$selected_str = $row->strandid;
   		$selected_type = $row->type;
			$selected_display = $row->data;
			if (isset($temp->schoolflag) && $temp->schoolflag != FALSE ){
				$data->dep_sch = $row->school;
				$data->col_dep_sch = lang('admin_standard_col_school');
			}
			else{
				$data->dep_sch = $row->department;
				$data->col_dep_sch = lang('admin_standard_col_dep');
			}
	    }
	    elseif ($action == CMS_ADMIN_ADD ) {
   		$selected_str = $data->selectid ;
   		$selected_type = $data->type[0];
   		$selected_display	= lang('admin_standard_add_head');

   		if (isset($temp->schoolflag) && $temp->schoolflag != FALSE ){
				$data->dep_sch = $temp->dep_search;
				$data->col_dep_sch = lang('admin_standard_col_school');
			}
			else{
				$data->dep_sch = $temp->dep_search;
				$data->col_dep_sch = lang('admin_standard_col_dep');
			}
	    }
   	$data->selected_str = $selected_str;
   	$data->selected_type = $selected_type;
   	$data->selected_display = $selected_display;
		$data->show_importid = FALSE;
		if ( $this->config->item('cms_lt_importid_support') ) {
			$data->show_importid = TRUE;
		}
	   $this->load->view('admin/standard_input_view',$data);
	}

	function delete($standardid, $enabled, $enabledflag,$type) {
		if ( is_numeric($standardid)==FALSE ||  is_numeric($enabled)==FALSE ||  is_numeric($enabledflag)==FALSE ) {
			// show error message
			echo 'error list';
			return FALSE;
		}

		if ( $enabled < CMS_ADMIN_DISABLE && $enabled > CMS_ADMIN_ENABLE ) {
			// show error message
			echo 'error list';
			return FALSE;
		}

		if ($enabled==CMS_ADMIN_DISABLE)
			$enabled= CMS_ADMIN_ENABLE;
		else
		    $enabled= CMS_ADMIN_DISABLE;

		$this->CI =  get_instance();
		//$divid = 'standard' ;
		$standard = $this->CI->searchsort_model->getSort($this->divid);
		$selectid = $standard->selectid;
		$dep_schid = $standard->dep_schid;
		$filter = FALSE;
		if ($standard->filter!=FALSE && $standard->filter!='')
			$filter = $standard->filter;
		if ($standard->refresh == 'page_content'){
			$this->standard_model->del_standard($standardid, $enabled);
			$this->refresh($enabledflag,$type,$standard->refresh,$dep_schid,$selectid,$filter);
		}
		else{
			$result=$this->standard_model->del_standard($standardid, $enabled);
			if ($result==1)
				$result = base_url().'admin/standard/refresh/'. $enabledflag.'/'.$type.'/'.$standard->refresh.'/'.$dep_schid.'/'.$selectid.'/'.$filter;
			echo $result;
  		}
	}
/*
	function search() {
		$this->CI =  get_instance();
		//$divid = 'standard' ;
		$standard  = $this->CI->searchsort_model->getSort($this->divid);
	   	$_type = $standard->type;
	   	$page_con = '0';
	    $selectid = '0';
	    $dep_schid= '0';
	    if ($standard->dep_schid!=FALSE && $standard->dep_schid!='')
	    $dep_schid=	$standard->dep_schid;
	   if ($standard->selectid!=FALSE && $standard->selectid!='')
	    $selectid=	$standard->selectid;
	   if ($standard->refresh!=FALSE && $standard->refresh!='')
	    $page_con=	$standard->refresh;

	    $keys = array_keys($_POST);

	    foreach ($keys as $key) {
	    	if ($key != 'bustcache') {
	    		$value = trim($_POST[$key]);
				if ($key == 'filter'){
					$filter = $value;
				}
				elseif ($key == 'filters'){
					$enableflag = $value;
				}
			}
	    }
    	echo $enableflag.'/'.$_type.'/'.$page_con.'/'.$dep_schid.'/'.$selectid.'/'.$filter;
	}
	*/

	function search() {
		$this->access_model->checkaccess_any('admin_system_management');
		$this->load->library('search/searchutil');
		$display = & $this->searchutil->get_session($this->divid);
		//$display->selectlistitem = $enableflag;
		$filter = FALSE;
		if ( array_key_exists('filter', $_REQUEST) ) {
			$filter = $_REQUEST['filter'];
		}
		$this->refresh($display->selectlistitem, $display->type, 'page_content', $display->dep_schid,
							$display->selectid, $filter, $display->index, $display->index_benchmark);
	}

}
?>