<?php
/**
 * eq.php - Controller for handling input pages.
 *
 * @author $Author: dtong $
 * @version $Id: eq.php,v 1.27 2011/04/27 05:46:26 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once(APPPATH . 'helpers/osautil_helper.php');
require_once(APPPATH . 'libraries/mapping/display_list.php');
class Eq extends CI_Controller{
	//This is used as the session variable name. All admin features use this name
   private $divid = 'adminss'; //Need to stay as eq becuase the sort code uses this.
	//To start a new display session or not
   private $new_display_session = FALSE;

	function __construct() {
		parent::__construct();
		$this->access_model->checkaccess_any('admin_system_management');
	    $this->load->helper('form');
	    osa_load_lang('admin');
	    $this->load->library('admin/admin_base');
	    $this->load->library('menu/menu_main');
	    $this->load->model('admin/eq_model');
	    $this->load->library('form_validation');
	    $this->load->model('sort/searchsort_model');
	    osa_php_session_start();

	}

	function index($type,$index=FALSE) {
		if ( !is_numeric($type) )
			return FALSE;
		$this->new_display_session = TRUE;
		$this->refresh(CMS_ADMIN_ENABLE , $type, $index);
	}

	function refresh($enableflag, $type=FALSE, $index=FALSE, $dep_schid=FALSE, $filter=FALSE) {
		if ( $enableflag != CMS_ADMIN_DISABLE && $enableflag != CMS_ADMIN_ENABLE && $enableflag != CMS_ADMIN_ALL ) {
			echo osa_ajaxmsg(lang('gen_internalservererror'));
			exit;
		}
		$this->CI =  get_instance();

   		//Add Config
   		//$divid       = 'eq' ;
		$url_add	 = 'admin/eq/add/'.$enableflag;
		$div		 = 'eq_input';
		$width		 = 600;
		$height		 = 400;

		//$display  = $this->admin_base->init_display(CMS_ADMIN_EQ_TYPE, $enableflag,$this->divid);
		if ( $this->new_display_session ) {
			$display = & $this->admin_base->init_display(CMS_ADMIN_EQ_TYPE, $enableflag, $this->divid);
			$display->column_use_striptag[1] = TRUE;
		}
		else {
			$this->load->library('search/searchutil');
			$display = & $this->searchutil->get_session($this->divid);
			$display->selectlistitem = $enableflag;
			$display->reset_data();
		}

		/* if ($index == FALSE || $index == 'page_content'){
			$temp  = & $this->CI->searchsort_model->getSort($this->divid);
			$index = $temp->index;
   	} */
		//TODO: $index is the menu index and the refresh/div-name, very messy...
		if ( $index !== FALSE && $index != 'page_content' ) {
			$display->index = $index;
		}
		else {
			$index = $display->index;
		}
		$sub_index = 1;
		if ( $index !== FALSE ) {
			$tmp_index = explode('_',$index);
			if ( count($tmp_index) > 1 ) {
				$index = $tmp_index[0];
				$sub_index = $tmp_index[1];
			}
		}

   	$temp = $this->menu_main->get_template('admin');
		$template = $temp[$index][$sub_index];

		$title_add	 = osa_get_template_value($template,'_add_head');
		$imgaddname	 = osa_imagepath() . 'add_24.gif';
		$imgaddtitle = osa_get_template_value($template,'_tooltip_add');
	   $imgeadd     = $this->admin_base->newDhtmlWindow($url_add, $title_add, $width, $height, $div , $imgaddname,$imgaddtitle );

   	$display->menu  	 = lang('admin_menu_eq');
   	$display->search  	 = osa_get_template_value($template,'_search');
   	$display->pagetitle  = osa_get_template_value($template,'_list_title');
		$display->widths     = array('25%', '62%', '5%', '5', '3%');

		$listitem = osa_get_template_value($template,'_filter');
		asort($listitem,SORT_NUMERIC);
		$display->listitem	 =$listitem;

		$display->type 	 = $type;
   		//$display->filter = $filter;
   		$display->filter=FALSE;
   		if ($filter != FALSE)
			$display->filter = $filter;
		else {
			if (isset($_POST['filter']))
				$display->filter = $_POST['filter'];
		}
		$titles = osa_get_template_value($template,'_display_col');
		$titles[3] = lang('admin_eq_column_sort_title');
		$display->notice = lang('admin_eq_sort_notice_msg');
		$titles[4]= $imgeadd;

   	$display->dep_schid=FALSE;
   	if ($dep_schid != FALSE)
			$display->dep_schid = $dep_schid;
		else {
			if (isset($_POST['dep_schid']))
				$display->dep_schid = $_POST['dep_schid'];
		}

		$display->search_dep_sch = osa_get_template_value($template,'_search_deparetmet');
		$display->data_dep_sch   = $this->eq_model->get_department();
		$data = $this->eq_model->get_alleq($enableflag, $display->type, $display->filter,$display->dep_schid,FALSE);

	    $display->titles     = $titles;
	 	$page			= 'page_content';
		$display->refresh = $page;
		//TODO: Both are the same value...
		$display->enableflag = $enableflag;
		$display->selectlistitem = $enableflag;

		$display->eq=array();
		$display->strand=array();
		$display->standard =array();
		$splits = $this->admin_base->split($display->filter);
		if ($data != FALSE) {
			$first_loop = TRUE;
			foreach ($data as $rows) {
				$enabled = $rows->enabled;
				if ($rows->enabled == CMS_ADMIN_DISABLE){
					$rows->enabled  = '<div class="hide">'.lang('admin_list_convert_disabled').'</div>';
				    $imgdelname		= osa_imagepath() . 'enabled_16.gif';
				    $imgdeltitle	= osa_get_template_value($template,'_tooltip_enable');
			    	$massage		= osa_get_template_value($template,'_message_enable');
				}elseif ($rows->enabled == CMS_ADMIN_ENABLE){
					$rows->enabled  = '<div class="show">'.lang('admin_list_convert_enabled').'</div>';
				    $imgdelname		= osa_imagepath() . 'disable_16.gif';
				    $imgdeltitle	= osa_get_template_value($template,'_tooltip_disable');
			    	$massage		= osa_get_template_value($template,'_message_disable');
				}

				if ( $first_loop ) {
					//The old code was here so just let it stay here and only execute on the very first loop
					//Edit Config
					//$url_edit		= 'admin/eq/edit/'.$rows->id.'/'.$enableflag;
					$url_edit = 'admin/eq/edit/%s/'.$enableflag;
					$div			= 'eq_input';
					$title_edit		= osa_get_template_value($template,'_edit_head');
					$imgeditname	= osa_imagepath() . 'edit_16.gif';
					$imgedittitle	= osa_get_template_value($template,'_tooltip_edit');

					//Link Config
					$lnkwidth	 	= 600;
					$lnkheight	 	= 400;
					$lnkdiv			= 'eq_list';
					$display->lnkdiv =$lnkdiv;

					$title_lnk  = osa_get_template_value($template,'_tooltip_edit');
					$linktitle	= osa_get_template_value($template,'_tooltip_edit');

					//Delete Config
					//$url_del		= 'admin/eq/delete/'.$rows->id.'/'.$enabled.'/'.$enableflag.'/'.$display->type;
					$url_del		= 'admin/eq/delete/%s/%s/'.$enableflag.'/'.$display->type;

				  	//$highlight_name = $this->admin_base->highlight($splits, $rows->text);
				    $linkname = $this->admin_base->linkDhtmlWindow($url_edit, $title_edit, $lnkwidth, $lnkheight,
				    					$div ,display_list::HIDEDATA_REPLACE_STR,$linktitle );
				    //Template string for data column 1
				    $display->add_urllink_template_str(1,$linkname);

				    $imgedit  = $this->admin_base->newDhtmlWindow($url_edit, $title_edit, $width, $height, $div , $imgeditname,$imgedittitle );
				    //$imgdel   = $this->admin_base->delTarget($url_del, $page ,$massage,$imgdelname, $imgdeltitle);
				    $imgdel   = $this->admin_base->delTarget($url_del, $page,'%s', '%s', $imgdeltitle);
				    //Template string for data column 3
					 $display->add_urllink_template_str(4,"<nobr>$imgdel $imgedit</nobr>");
					 $display->column_data_align[3] = 'center';
					 $display->column_sort_function[3] = 'osa_numeric_str_compare';
				}
				$del_sprintf = "'$rows->id','$enabled','$massage','$rows->id','$enabled','$imgdelname','$rows->id','$rows->id'";
		 		//$temp = array($rows->department,$linkname ,$rows->enabled, "<nobr>$imgdel $imgedit</nobr>");
		 		$highlight_name = $this->admin_base->highlight($splits, $rows->text);
		 		$temp = array($rows->department, $highlight_name, $rows->enabled, $rows->sort, "");
		 		$display->add_hidden_data(1, $temp, "'$rows->id','$rows->id'");
		 		$display->add_hidden_data(4, $temp, $del_sprintf);
				$display->add($temp);
				$first_loop = FALSE;
			}
		}
		$this->admin_base->load_view($display);
	}

	function insert() {
		$data = array();

	    $eqid = FALSE;
	    $keys = array_keys($_POST);
	    $this->CI =  get_instance();
		//$divid = 'eq' ;
	    $temp  = $this->CI->searchsort_model->getSort($this->divid);

		$this->form_validation->set_rules('text', '', 'required') ;
		$this->form_validation->set_rules('departmentid', 'deptid', 'trim') ;
		$this->form_validation->set_rules('sort', 'sort', 'trim') ;
		$run_result = $this->form_validation->run();
		$deptid = set_value('departmentid');
		$sort = set_value('sort');
		if ( (!$run_result) || empty($deptid) ) {
			echo osa_ajaxmsg(lang('admin_eq_validate_error'));
		   exit();
		}

		if (!is_numeric($sort)){
			echo osa_ajaxmsg(lang('admin_eq_is_numeric'));
		   exit();
		}

	    foreach ($keys as $key) {
			if ($key != 'bustcache' && $key != 'id') {
	    	 	 $value = trim($_POST[$key]);
	    	 	 $key = strtolower($key);
	    	 	 if ($key == 'enabled') {
		    	  	 if ($_POST[$key] == 'on')
		    		 	 $value = 1;
		    		 else
		    			 $value = 0;
	    	 	 }
	    		 $data[$key] = $value;
			}
			elseif ($key == 'id') {
				$eqid = $_POST[$key];
			}

	    }

		$result=$this->eq_model->add_eq($data);
			if ($result==1)
			$result = 'success';
			echo $result;

	}
	function update() {
		$this->CI =  get_instance();
		$data     = array();
	    $eqid = FALSE;
	    $keys = array_keys($_POST);
	    //$divid = 'eq' ;
	    $temp  = $this->CI->searchsort_model->getSort($this->divid);

	    $this->form_validation->set_rules('text', '', 'required') ;
	     $this->form_validation->set_rules('id', 'ID', 'required') ;
		$this->form_validation->set_rules('departmentid', 'deptid', 'trim') ;
		$this->form_validation->set_rules('sort', 'sort', 'trim') ;
		$run_result = $this->form_validation->run();
		$deptid = set_value('departmentid');
		$sort = set_value('sort');
		if ( (!$run_result) || empty($deptid) ) {
			echo osa_ajaxmsg(lang('admin_eq_validate_error'));
		   exit();
		}

		if (!is_numeric($sort)){
			echo osa_ajaxmsg(lang('admin_eq_is_numeric'));
		   exit();
		}

	    foreach ($keys as $key) {
			if ($key != 'bustcache' && $key != 'id') {
	    	 	 $value = trim($_POST[$key]);
	    	 	  $key = strtolower($key);
	    	 	 if ($key == 'enabled') {
		    	  	 if ($_POST[$key] == 'on')
		    		 	 $value = 1;
		    		 else
		    			 $value = 0;
	    	 	 }
	    		 $data[$key] = $value;
			}
			elseif ($key == 'id') {
				$eqid = $_POST[$key];
			}
	    }

		$result=$this->eq_model->update_eq($eqid,$data);

		if ($result==1)
			$result = 'success';
		echo $result;

		$temp->eqid = $eqid;
		$this->CI->searchsort_model->setSortSession($temp);
	}

    function add($enableflag=FALSE) {
        $this->edit(FALSE, $enableflag, CMS_ADMIN_ADD);
	}

	function edit($eqid, $list, $action=CMS_ADMIN_EDIT) {
		if ( is_numeric($list) == FALSE || $list < CMS_ADMIN_DISABLE || $list > CMS_ADMIN_ALL ) {
			// show error message
			echo 'error list';
			return FALSE;
		}
			$this->CI =  get_instance();
		    $data = FALSE;
		    //$divid = 'eq' ;
	    	$temp  					= $this->CI->searchsort_model->getSort($this->divid);
	    	$data->type 			= $temp->type;
	    	$data->index 			= $temp->index;
		    $data->page     		= $this->admin_base->getpage(CMS_ADMIN_EQ_TYPE);
	        $data->selectlistitem 	= $list;
		   	$data->department 		= $this->eq_model->get_department();
		  	$data->dep_schid     	= $temp->dep_schid;
	   		if ($data->dep_schid ==FALSE || $data->dep_schid =='')
	   			$data->dep_schid ='0';
	   		$data->filter=$temp->filter;
	    	if ($temp->filter==FALSE && $temp->filter=='')
	    		$data->filter = FALSE;

		   	$data->action 			= $action;

		   $index = $temp->index;
			$sub_index = 1;
			if ( $index !== FALSE ) {
				$tmp_index = explode('_',$index);
				if ( count($tmp_index) > 1 ) {
					$index = $tmp_index[0];
					$sub_index = $tmp_index[1];
				}
			}
	   	$template = $this->menu_main->get_template('admin');
	   	$data->template = $template[$index][$sub_index];
	    if ($action == CMS_ADMIN_EDIT ) {
			$eq = $this->eq_model->get_eq($eqid);
			if ($eq==FALSE || count($eq)==0) {
				// show error message
				echo 'show error message: no data';
				return FALSE;
			}

	   		$data->data   			= $eq;
	   		$row					= $eq[0];
	   		$selected_dep 			= $row->departmentid;
	   		$selected_type 			= $row->type;
	   		$selected_display 		= $row->text;
	    }
	    elseif ($action == CMS_ADMIN_ADD ) {
	    	$selected_dep 			= $data->department[0];
	   		$selected_type 			= $data->type[0];
	   		$selected_display = osa_get_template_value($data->template,'_add_title');

	    }

		    $data->selected_dep 	= $selected_dep;
		   	$data->selected_type 	= $selected_type;
		   	$data->selected_display   = $selected_display;

	  		$this->load->view('admin/eq_input_view',$data);
	}

	function delete($eqid, $enabled, $enabledflag,$type) {
		if ( is_numeric($eqid)==FALSE ||  is_numeric($enabled)==FALSE ||  is_numeric($enabledflag)==FALSE ) {
			// show error message
			echo 'error list';
			return FALSE;
		}

		if ( $enabled < CMS_ADMIN_DISABLE && $enabled > CMS_ADMIN_ENABLE ) {
			// show error message
			echo 'error list';
			return FALSE;
		}
		$this->CI =  get_instance();
		//$divid = 'eq' ;
		$temp  = $this->CI->searchsort_model->getSort($this->divid);
		$dep_schid= '0';
	    if ($temp->dep_schid!=FALSE && $temp->dep_schid!='')
	    $dep_schid=	$temp->dep_schid;
	    $filter= FALSE;
	    if ($temp->filter!=FALSE && $temp->filter!='')
	    $filter=$temp->filter;


		if ($enabled==CMS_ADMIN_DISABLE) {
			$enabled= CMS_ADMIN_ENABLE;
			$temp->eqid = $eqid;
			$this->CI->searchsort_model->setSortSession($temp);
		}
		else {
			$enabled= CMS_ADMIN_DISABLE;
		}

	   $this->eq_model->del_eq($eqid, $enabled);
	   $this->refresh($enabledflag,$type,$temp->index,$dep_schid,$filter);
	}
/*
	function search() {
		$this->CI =  get_instance();
		//$divid = 'eq' ;
		$eq  = $this->CI->searchsort_model->getSort($this->divid);
	   	$_type = $eq->type;
	   	$dep_schid= '0';
	    if ($eq->dep_schid!=FALSE && $eq->dep_schid!='')
	    $dep_schid=	$eq->dep_schid;

	 	$keys = array_keys($_POST);
		 foreach ($keys as $key) {
		    if ($key != 'bustcache') {
		    	$value = trim($_POST[$key]);
				if ($key == 'filter'){
					$filter = $value;
				}
				elseif ($key == 'filters'){
					$enableflag = $value;
				}

			}
		}
    	echo $enableflag.'/'.$_type.'/'.$eq->index.'/'.$dep_schid.'/'.$filter;
	}
*/

	function search() {
		$this->access_model->checkaccess_any('admin_system_management');
		$this->load->library('search/searchutil');
		$display = & $this->searchutil->get_session($this->divid);
		//$display->selectlistitem = $enableflag;
		$filter = FALSE;
		if ( array_key_exists('filter', $_REQUEST) ) {
			$filter = $_REQUEST['filter'];
		}
		$this->refresh($display->selectlistitem, $display->type, $display->index,
							$display->dep_schid, $filter);
	}

}
?>