<?php
/**
 * todcm_ubd.php - Unit template file for TODCM UbD.
 *
 * @author $Author: dtong $
 * @version $Id: todcm_ubd.php,v 1.12 2011/05/24 12:51:07 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once(CMS_TEMPLATEPATH_BUILDER . 'base/baseclass_ubd.php');

class unit_config_data extends baseclass_ubd {
	const LEARNING_TARGETS_TYPE = CMS_LEARNING_TARGETS_TYPE;
	const ESSENTIAL_QUESTION_TYPE = CMS_ESSENTIAL_QUESTION_TYPE;
	const TEACHER_EQ_TYPE = CMS_TEACHER_EQ_TYPE;
	const ENDURING_UNDERSTANDING_TYPE = CMS_ENDURING_RES_TYPE;
	const ADMIN_COMMENT_TYPE = CMS_ADMIN_COMMENT_TYPE;

	const CROSS_CURRICULUM_LINKS_UPLOAD = CMS_TEMPLATE_UBD_1;
	const STAGE1_ADDITIONAL = CMS_TEMPLATE_UBD_2;
	const ASSESSMENT_TYPE = CMS_TEMPLATE_UBD_3;
	const LEARNING_TYPE = CMS_TEMPLATE_UBD_4;
	const UNIT_REFLECTION = CMS_TEMPLATE_UBD_5;
	const RESOURCE_UPLOAD_TYPE = CMS_TEMPLATE_UBD_6;

	//Not needed but list here so mapping can work
	const IT_STANDARDS_TYPE = CMS_ITSTANDARDS_TYPE;

	private static $bigk = '<font style="color:red;font-size:14px;font-weight:bold">K</font>';
	private static $bigs = '<font style="color:blue;font-size:14px;font-weight:bold">S</font>';
	private static $bigt = '<font style="color:red;font-size:14px;font-weight:bold">T</font>';
	private static $bigl = '<font style="color:blue;font-size:14px;font-weight:bold">L</font>';
	private static $bign = '<font style="color:black;font-size:14px;font-weight:bold"></font>'; //none sign

	static function get() {
		$unit_config = new stdClass();
		$unit_config->extra = array(); //Array of objects that are not displayed on the unit page
		$unit_config->stage = array(); // Array of stages.
		$unit_config->title = 'Unit';
		$unit_config->short_title = 'Unit';
		$unit_config->stage_order = array(6,1,2,3,4,5);

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//Stage 1
//////////////////////////////////////////////
//Extra hidden fields
			//This is used by the popup only, only popups serach for data using the first levle array index
			//The first level array index for the body can be anything that is unique
			$unit_config->extra[self::LEARNING_TARGETS_TYPE] =
			array('_type' => 'lt', '_typeid' => self::LEARNING_TARGETS_TYPE, '_action' => 'edit',
				'_title' => 'Select Learning Targets',
				'_standard_title' => 'Standard', '_target_title' => 'Knowledge/Skill', '_benchmark_title' => 'Benchmark',
				'_nodatamsg' => 'Sorry, there are no learning targets defined yet.',
				'_select1' => array( 1 => self::$bigk, 2 => self::$bigs),
				'_divid' => 'learningtarget', '_save_text' => 'Save', '_cancel_text' => 'Cancel',
				'_stage_div' => 'stage1_div', '_stage_num' => '1',
			);
			//This is the learning target edit page
			$unit_config->extra[self::LEARNING_TARGETS_TYPE . '_edit'] =
			array('_typeid' => self::LEARNING_TARGETS_TYPE, '_action' => 'edit|read',
				'_select1' => array( 1 => self::$bigk, 2 => self::$bigs), '_sort_typeid' => CMS_SORT_LT_COURSE,
				//'_win_title' => 'Learning Targets', '_win_width' => 1000, '_win_height' => 800,
				//'_win_id' => 'edit_lt', '_body_divid' => 'page_content',
			);

///////////////////////////////////////////////
//Buttons for Stage 1
		//Teacher EQ Buttons
		$teachereq_button_add = self::button_add(self::TEACHER_EQ_TYPE, 'Add Teacher EQ', FALSE, 430, FALSE, 'Add Teacher Essential Question');
		$teachereq_button_edit = self::button_edit(self::TEACHER_EQ_TYPE, FALSE, 430, 'Edit Teacher EQ', FALSE, 'Edit Teacher Essential Question');
		$teachereq_button_delete = self::button_delete(self::TEACHER_EQ_TYPE, 'Teacher Essential Question');
		//Essential Questions buttons
		$eq_button_add = self::button(self::ESSENTIAL_QUESTION_TYPE, self::select_add(self::ESSENTIAL_QUESTION_TYPE),
									"newDhtmlWindow('_BTNLINK_','Subject Area Essential Questions',580,650,'select')", 'eq.gif', 'Select EQ');
		$eq_button_delete = self::button(self::ESSENTIAL_QUESTION_TYPE, self::select_delete(),
								  "return delUnitItem('_BTNLINK_','" . self::stage_url() . "','_STAGEDIV_','Are you sure to delete this Essential Question?')",
								  'x.gif', 'Delete EQ');
		//Learning Target buttons
		$lt_button_add =
			array ('_type' => self::LEARNING_TARGETS_TYPE, '_image' => 'lt.gif', '_action' => 'edit',
				'_alt_title' => 'Select Learning Targets',
				'_link' => self::lt_add(self::LEARNING_TARGETS_TYPE),
				'_jscript' => "newDhtmlWindowTop('" . self::lt_add(self::LEARNING_TARGETS_TYPE) .
									"','Select Learning Targets',900,800,'learningtarget');return false;");
		$lt_button_delete =
			 array ('_type' => self::LEARNING_TARGETS_TYPE, '_image' => 'x.gif', '_action' => 'edit',
			 '_link' => self::lt_delete(), '_title'=>FALSE, '_alt_title' => 'Delete',
			 '_jscript' => "return delUnitItem('" . self::lt_delete() . "','" . self::stage_url() .
						"','_STAGEDIV_','Are you sure to delete this Learning Target?')" );
		$lt_button_up =
			 array ('_type' => self::LEARNING_TARGETS_TYPE, '_image' => 'moveup.gif', '_action' => 'edit',
			 '_link' => self::lt_unit_sort(CMS_SORT_LT_UNIT, 0), '_title'=>FALSE, '_alt_title' => 'Up',
			 '_jscript' => "return sortUnitItem('" . self::lt_unit_sort(CMS_SORT_LT_UNIT, 0). "','" . self::stage_url() .
						"','_STAGEDIV_')" );
		$lt_button_down =
			 array ('_type' => self::LEARNING_TARGETS_TYPE, '_image' => 'movedown.gif', '_action' => 'edit',
			 '_link' => self::lt_unit_sort(CMS_SORT_LT_UNIT, 1), '_title'=>FALSE, '_alt_title' => 'Down',
			 '_jscript' => "return sortUnitItem('" . self::lt_unit_sort(CMS_SORT_LT_UNIT, 1) . "','" . self::stage_url() .
						"','_STAGEDIV_')" );
		$lt_button_none =
			 array ('_type' => self::LEARNING_TARGETS_TYPE, '_image' => 'none.gif', '_action' => 'edit',
			 '_link' =>'', '_title'=>FALSE, '_alt_title' => '' );
////////////////////////////////////////////////
//Stage 1 body
		$unit_config->stage[1] =
		array (
		// Stage 1
			'title1' => array('_type' => 'title', '_title' => 'Stage One - Desired Results', '_action'=>'all'),
			'title1_1' => array('_type' => 'subtitle', '_title' => 'Standards, Benchmarks and Learning Targets', '_action'=>'edit',
									'_leftbutton' => FALSE, '_rightbutton' => array($lt_button_add)),
			'title1_2' => array('_type' => 'subtitle', '_title' => 'Standards, Benchmarks and Learning Targets', '_action'=>'read'),
			'lt_list' => array('_type'=>'lt_extended', '_typeid' => self::LEARNING_TARGETS_TYPE, '_action'=>'all',
									'_button' => array($lt_button_delete), '_sort_flag' => TRUE,
									'_button_sortnormal' => array($lt_button_up, $lt_button_down ),
								    '_button_sortfirst' => array($lt_button_none, $lt_button_down),
									'_button_sortlast' => array($lt_button_up, $lt_button_none),
									'_select1' => array( 1 => self::$bigk, 2 => self::$bigs),
									'_strand_title'=>'Strand', '_standard_title' => 'Standard', '_bench_title' => 'Benchmark(s)'),
			'newline_2'=>array('_type'=>'newline', '_px'=>3, '_action'=>'all'),

			'title2' => array('_type' => 'subtitle', '_title' => 'Essential Questions', '_action'=>'edit',
									'_leftbutton' => FALSE, '_rightbutton' => array($eq_button_add,$teachereq_button_add)),
			'title2_1' => array('_type' => 'subtitle', '_title' => 'Essential Questions', '_action'=>'read'),

			self::ESSENTIAL_QUESTION_TYPE =>
				array('_type' => 'select', '_typeid' => self::ESSENTIAL_QUESTION_TYPE, '_action'=>'all',
					'_title' => 'Subject Area Essential Questions',
					'_subtitle' => 'Essential Questions for _AREA_NAME_',
					'_save_text' => 'Save', '_cancel_text' => 'Cancel',
					'_category_bodytext' => '(Subject Area EQ)', '_category_color' => '#D0D000',
					'_cattext_bold' => FALSE,
					'_cattext_flag1' =>TRUE,'_cattext_flag2' =>FALSE,'_cattextflag3' =>FALSE,
					'_cattext1' =>FALSE,'_cattext2' =>FALSE,'_cattext3' =>FALSE,
					'_nodata_text' => 'Couldn\'t find any Subject Area Essential Questions for this course',
					'_divid' => 'select', '_button' => array($eq_button_delete),
				),

			self::TEACHER_EQ_TYPE =>
				array('_type' => 'resource', '_typeid' => self::TEACHER_EQ_TYPE, '_action'=>'all',
					//titles for the DHTML window
					'_title_add' => 'Add Teacher Essential Question', '_title_edit' => 'Edit Teacher Essential Question',
					//_text_title is the title right above the text box
					'_text_flag' => TRUE, '_text_title' => FALSE, '_text_cols'=>120, '_text_rows'=>25, '_text_required'=>TRUE,
					'_save_text' => 'Save', '_cancel_text' => 'Cancel', '_delete_text' => FALSE,
					//category_text is the (text) for each item on the unit body
					'_category_bodytext' => '(Teacher EQ)', '_category_color' => 'green', '_sort_flag' => TRUE,
					//Buttons on the unit page
					'_button' => array($teachereq_button_delete, $teachereq_button_edit),
				),

			'newline_4'=>array('_type'=>'newline', '_px'=>3, '_action'=>'all'),
			'title4' => array('_type' => 'subtitle', '_title' => 'Enduring Understanding', '_action'=>'edit',
									'_leftbutton' => FALSE,
									'_rightbutton' =>
									array(self::button_resource_upload2(self::ENDURING_UNDERSTANDING_TYPE,'Add Enduring Understanding',FALSE,430,'add.gif'))),
			'title4_1' => array('_type' => 'subtitle', '_title' => 'Enduring Understanding', '_action'=>'read'),
			self::ENDURING_UNDERSTANDING_TYPE =>
				array('_type' => 'resource', '_typeid' => self::ENDURING_UNDERSTANDING_TYPE, '_action'=>'all',
					//titles for the DHTML window
					'_title_add' => 'Add Enduring Understanding', '_title_edit' => 'Edit Enduring Understanding',
					//_text_title is the title right above the text box
					'_text_flag' => TRUE, '_text_title' => FALSE, '_text_cols'=>120, '_text_rows'=>25, '_text_required'=>TRUE,
					'_save_text' => 'Save', '_cancel_text' => 'Cancel', '_delete_text' => FALSE, '_sort_flag' => TRUE,
					//category_text is the (text) for each item on the unit body
					//'_category_bodytext' => '(Teacher EQ)', '_category_color' => 'green',
					//Buttons on the unit page
					'_button' => array(self::button_delete(self::ENDURING_UNDERSTANDING_TYPE),
											 self::button_edit(self::ENDURING_UNDERSTANDING_TYPE, FALSE, 430, 'Edit Enduring Understanding')),
				),

			'newline_5'=>array('_type'=>'newline', '_px'=>3, '_action'=>'all'),
			'title5' => array('_type' => 'subtitle', '_title' => 'Cross-curriculum Links', '_action'=>'edit',
									'_leftbutton' => FALSE,
									'_rightbutton' =>
									array(self::button_resource_upload2(self::CROSS_CURRICULUM_LINKS_UPLOAD,'Add Link',FALSE,550,'add.gif'))),
			'title5_1' => array('_type' => 'subtitle', '_title' => 'Cross-curriculum Links', '_action'=>'read'),
			self::CROSS_CURRICULUM_LINKS_UPLOAD =>
				array('_type' => 'resource', '_typeid' => self::CROSS_CURRICULUM_LINKS_UPLOAD, '_action'=>'all',
					'_upload_flag'=>TRUE, '_url_flag'=>TRUE, '_url_title'=>'Enter URL', '_checkpublic_flag' => FALSE,
					'_category_bodytext' => FALSE, '_category_color' => FALSE, '_title_add' => 'Add Cross-curriculum Link',
					'_title_edit' => 'Edit Cross-curriculum Link', '_text_flag' => TRUE,
					'_text_title' => FALSE, '_text_cols'=>120, '_text_rows'=>15, '_text_required'=>TRUE, '_save_text' => 'Save',
					'_cancel_text' => 'Cancel', '_delete_text' => FALSE,
					'_sort_flag' => TRUE, '_allow_no_uploadandselect' => TRUE,
					'_button' => array(self::button_delete(self::CROSS_CURRICULUM_LINKS_UPLOAD),
											 self::button_edit(self::CROSS_CURRICULUM_LINKS_UPLOAD, FALSE, FALSE, 'Edit Link')),
				),

			'newline_6'=>array('_type'=>'newline', '_px'=>3, '_action'=>'all'),
			'title6' => array('_type' => 'subtitle', '_title' => 'Additional Elements', '_action'=>'edit',
								'_leftbutton' => FALSE, '_rightbutton' =>
								array(self::button_resource_upload2(self::STAGE1_ADDITIONAL,'Add Additional Element',FALSE,550,'add.gif'))),
			'title6_1' => array('_type' => 'subtitle', '_title' => 'Additional Elements', '_action'=>'read'),
			self::STAGE1_ADDITIONAL =>
				array('_type' => 'resource', '_typeid' => self::STAGE1_ADDITIONAL, '_action'=>'all',
					'_upload_flag'=>TRUE, '_url_flag'=>TRUE, '_url_title'=>'Enter URL', '_checkpublic_flag' => TRUE,
					'_category_bodytext' => FALSE, '_category_color' => FALSE, '_title_add' => 'Add Additional Element',
					'_title_edit' => 'Edit Additional Element', '_text_flag' => TRUE,
					'_text_title' => FALSE, '_text_cols'=>120, '_text_rows'=>15, '_text_required'=>TRUE, '_save_text' => 'Save',
					'_cancel_text' => 'Cancel', '_delete_text' => FALSE,
					'_sort_flag' => TRUE, '_allow_no_uploadandselect' => TRUE,
					'_button' => array(self::button_delete(self::STAGE1_ADDITIONAL),
											 self::button_edit(self::STAGE1_ADDITIONAL, FALSE, FALSE, 'Edit Additional Element')),
				),

		); // End of stage1 layout


///////////////////////////////////////////////
//Buttons for Stage 2
	$assessment_button_add = self::button_add(self::ASSESSMENT_TYPE, 'Add Assessment Evidence');
	$assessment_button_edit = self::button_edit(self::ASSESSMENT_TYPE, FALSE, 800, 'Edit Assessment Evidence');
	$assessment_button_delete = self::button_delete(self::ASSESSMENT_TYPE, 'Assessment Evidence');

//////////////////////////////////////////////////////////////////////////////////////
//Stage 2
		$unit_config->stage[2] =
		array (
			'title1' => array('_type' => 'title', '_title' => 'Stage Two - Assessment', '_action'=>'all'),
			'title2' => array('_type' => 'subtitle', '_title' => 'Assessment Evidence', '_action'=>'edit',
									'_rightbutton' => array( $assessment_button_add)),
			'title2_1' => array('_type' => 'subtitle', '_title' => 'Assessment Evidence', '_action'=>'read'),
			self::ASSESSMENT_TYPE => array('_type' => 'resource', '_typeid' => self::ASSESSMENT_TYPE, '_action'=>'all',
				'_title_add' => 'Add Assessment Evidence', '_title_edit' => 'Edit Assessment Evidence',
				'_text_flag' => TRUE, '_text_title' => FALSE, '_text_cols'=>120, '_text_rows'=>15, '_text_required'=>TRUE,
				'_save_text' => 'Save', '_cancel_text' => 'Cancel', '_delete_text' => FALSE, '_upload_flag'=>TRUE,
				'_url_flag'=>TRUE, '_url_title'=>TRUE, '_checkpublic_flag' => TRUE, '_category_bodytext' => FALSE,
				'_category_color' => FALSE, '_url_flag'=>TRUE, '_url_title'=>'Enter URL',
				'_select_flag1' => TRUE, '_select_size1'=>1, '_select_title1' =>'Assessment Task', '_select_color1' => 'green',
				'_select1' => array(1=>'Academic Prompt', 2=>'Authentic Task', 3=>'Informal Check for Understanding',
					4=>'Journaling', 5=>'Long-Term Project', 6=>'Observation/Dialogue', 7=>'Peer Assessment',
					8=>'Pre/Post Test', 9=>'Performance Task', 10=>'Portfolio', 11=>'Rubric',
					12=>'Quiz/Test', 13=>'Self-Assessment'),
				'_select_skip_newline1' => TRUE, '_select_size1' => 8, '_select_multi1' => TRUE,
				'_select_flag2' => TRUE, '_select_size2'=>6, '_select_title2' => 'Facet of Understanding',
				'_select_color2' => 'blue','_select_multi2' => TRUE,
				'_select2' => array(1=>'Application',2=>'Empathy',3=>'Explanation',
						4=>'Interpretation',5=>'Perspective',6=>'Self-Knowledge'),
				'_sort_flag'=>TRUE, '_button' => array($assessment_button_delete, $assessment_button_edit),
			),
		);

///////////////////////////////////////////////
//Buttons for Stage 3
	$activity_button_add = self::button_add(self::LEARNING_TYPE, 'Add Learning Activity');
	$activity_button_edit = self::button_edit(self::LEARNING_TYPE, FALSE, 800, 'Edit Learning Activity');
	$activity_button_delete = self::button_delete(self::LEARNING_TYPE, 'Learning Activity');

//////////////////////////////////////////////////////////////////////////////////////
//Stage 3
	$unit_config->stage[3] =
	//Resource Body
	array (
		'title1' => array('_type' => 'title', '_title' => 'Stage Three - Activities', '_action'=>'all'),
		'title2' => array('_type' => 'subtitle', '_title' => 'Learning Activities', '_action'=>'edit',
				'_leftbutton' => FALSE, '_rightbutton' => array($activity_button_add)),
		'title2_1' => array('_type' => 'subtitle', '_title' => 'Learning Activities', '_action'=>'read',
				'_leftbutton' => FALSE, '_rightbutton' => FALSE),
		self::LEARNING_TYPE => array('_type' => 'resource', '_typeid' => self::LEARNING_TYPE, '_action'=>'all',
			'_title_add' => 'Add Learning Activities', '_title_edit' => 'Edit Learning Activities',
			'_text_flag' => TRUE, '_text_title' => FALSE, '_text_cols'=>120, '_text_rows'=>15, '_text_required'=>TRUE,
			'_save_text' => 'Save', '_cancel_text' => 'Cancel', '_delete_text' => FALSE, '_upload_flag'=>TRUE,
			'_category_bodytext' => FALSE, '_category_color' => FALSE, '_url_flag'=>TRUE, '_url_title'=>'Enter URL',
			'_select_flag1' => TRUE, '_select_checkbox_type1' => TRUE, '_select_title1' => 'Formative Assessment',
			'_select_color1' => 'brown', '_select_size1'=>1, '_select_default1'=>FALSE,
			'_select_flag2' => TRUE, '_select_size2'=>7, '_select_title2' => 'Activity Type',
			'_select_color2' => 'olive','_select_multi2' => TRUE,
			'_select2' => array(1 => 'Conference/Fair', 2 => 'Contest/Award', 3 => 'Exhibit/Display',
				4 => 'Field Trip', 5 => 'Guest Speaker', 6 => 'Internship', 7 => 'Library/Material Lending',
				8 => 'Multimedia', 9 => 'Outreach/In-Class Program', 10 => 'Performance/Assembly', 11 => 'Resource Person/Consultant',
				12 => 'Service Learning', 13 => 'Teacher/School Project', 14 => 'Website/On-line Service', 15 => 'Workshop'),
			'_sort_flag'=>TRUE, '_checkpublic_flag' => TRUE,
			'_button' => array($activity_button_delete, $activity_button_edit),
		),
	);
	///////////////////////
	//stage 4
	$unit_config->stage[4] =
	array (
		'title1' => array('_type' => 'title', '_title' => 'Resources', '_action'=>'all'),
		'title2' => array('_type' => 'subtitle', '_title' => 'Additional Resources', '_action'=>'edit',
								'_rightbutton' => array(self::button_resource_upload(self::RESOURCE_UPLOAD_TYPE,FALSE,FALSE,600,'add.gif'))),
		'title2_1' => array('_type' => 'subtitle', '_title' => 'Additional Resources', '_action'=>'read'),
		self::RESOURCE_UPLOAD_TYPE =>
				array('_type' => 'resource', '_typeid' => self::RESOURCE_UPLOAD_TYPE, '_action'=>'all',
					'_upload_flag'=>TRUE, '_url_flag'=>TRUE, '_url_title'=>'Enter URL', '_checkpublic_flag' => TRUE,
					'_category_bodytext' => FALSE, '_category_color' => FALSE, '_title_add' => 'Resource', '_title_edit' => 'Resource',
					'_text_flag' => TRUE, '_text_title' => FALSE, '_text_cols'=>120, '_text_rows'=>15,
					'_text_required'=>TRUE, '_save_text' => 'Save', '_cancel_text' => 'Cancel', '_delete_text' => FALSE,
					'_category_bodytext' => '', '_category_color' => 'green', '_sort_flag'=>TRUE,
					'_allow_no_uploadandselect' => TRUE,
					'_button' => array(self::button_delete(self::RESOURCE_UPLOAD_TYPE),
						self::button_edit(self::RESOURCE_UPLOAD_TYPE)),
				),
	);

	///////////////////////
	//stage 5
	$unit_config->stage[5] =
	array (
		'title1' => array('_type' => 'title', '_title' => 'Unit Reflections', '_action'=>'all'),
		'title2' => array('_type' => 'subtitle', '_event_handle' => array('_handle'=>'use_action_edit','_mycourse'=>TRUE),
								'_title' => 'Please comment on any of the elements from each stage and the resources section.' .
									'<div style="margin:0px;margin-bottom:5px;font-style:italic;font-size:10px;font-weight:normal">' .
									'(Reflections are editable by editor teachers and read-only teachers assigned to this course.)</div>',
								'_action'=>'all',
								'_rightbutton' =>
									array(self::button_add_handle(self::UNIT_REFLECTION,array('_handle'=>'use_action_edit','_mycourse'=>TRUE),
											'Add Unit Reflection',FALSE,350))),
		/*'title2_1' => array('_type' => 'subtitle', '_action'=>'read',
								  '_title' => 'Please comment on any of the elements from each stage and the resources section.'),*/
		self::UNIT_REFLECTION =>
				array('_type' => 'resource', '_typeid' => self::UNIT_REFLECTION, '_action'=>'all',
					'_event_handle' => array('_handle'=>'use_action_edit','_mycourse'=>TRUE),
					'_upload_flag'=>FALSE, '_url_flag'=>FALSE, '_url_title'=>'Enter URL',
					'_category_bodytext' => FALSE, '_category_color' => FALSE, '_checkpublic_flag' => TRUE,
					'_title_add' => 'Add Unit Reflection', '_title_edit' => 'Edit Unit Reflection',
					'_text_flag' => TRUE, '_text_title' => FALSE, '_text_cols'=>120, '_text_rows'=>18,
					'_text_required'=>TRUE, '_save_text' => 'Save', '_cancel_text' => 'Cancel', '_delete_text' => FALSE,
					'_category_bodytext' => '', '_category_color' => 'green', '_sort_flag'=>TRUE,
					'_show_creator' => 'edit', '_show_modifier' => 'edit', '_non_editor_restrict_mode' => TRUE,
					'_button' => array(self::button_delete_handle(self::UNIT_REFLECTION, array('_handle'=>'use_action_edit','_mycourse'=>TRUE)),
						self::button_edit_handle(self::UNIT_REFLECTION,
							array('_handle'=>'use_action_edit','_mycourse'=>TRUE), FALSE, 350, 'Edit Unit Reflection')),
				),
	);

	///////////////////////
	//stage 6
	$unit_config->stage[6] =
	array (
		'pre_process' => array('is_unit_admin', 'show_admin_note', 'compare_not_show'),
		'title1' => array('_type' => 'title', '_title' => 'Admin Notes', '_action'=>'all'),
		'title2' => array('_type' => 'subtitle',
								'_title' => 'Notes' .
									'<div style="margin:0px;margin-bottom:5px;font-style:italic;font-size:10px;font-weight:normal">' .
									'Only admin users can read and edit the notes here. ' .
									'All admin notes are searchable in the admin search/mapping section. ' .
									'Please use the Unit Reflections section if you like to enter a public comment. ' .
									'You can hide/show this section/stage for all units from your profile, ' .
									'you will need to refresh the unit page to see the change.</div>',
								'_action'=>'all',
								'_rightbutton' =>
									array(self::button_add_handle(self::ADMIN_COMMENT_TYPE,
										array('_handle' => 'use_action_edit', '_admin' => TRUE), 'Add Comment', 800, 350))),
		self::ADMIN_COMMENT_TYPE =>
				array('_type' => 'resource', '_typeid' => self::ADMIN_COMMENT_TYPE, '_action'=>'all',
					'_event_handle' => array('_handle' => 'use_action_edit', '_admin' => TRUE), '_static' => TRUE,
					'_upload_flag'=>FALSE, '_url_flag'=>FALSE, '_url_title'=>'Enter URL',
					'_category_bodytext' => FALSE, '_category_color' => FALSE, '_checkpublic_flag' => FALSE,
					'_title_add' => 'Add Note', '_title_edit' => 'Edit Note',
					'_text_flag' => TRUE, '_text_title' => FALSE, '_text_cols'=>120, '_text_rows'=>18,
					'_text_required'=>TRUE, '_save_text' => 'Save', '_cancel_text' => 'Cancel', '_delete_text' => FALSE,
					'_category_bodytext' => '', '_category_color' => 'green', '_sort_flag'=>TRUE,
					'_is_private_resource' => TRUE, '_show_creator' => 'edit', '_show_modifier' => 'edit',
					'_button' => array(self::button_delete(self::ADMIN_COMMENT_TYPE),
						self::button_edit(self::ADMIN_COMMENT_TYPE, FALSE, 350, 'Edit Note')),
				),
	);
//////////////////////////////////////////////////////////////////////////////////////
//End of config

		return $unit_config;
	}
}

?>