<?php
/**
 * system_course-desc.php - Upload resource for course description page
 *
 * @author $Author: dtong $
 * @version $Id: system_course_desc.php,v 1.3 2011/04/13 15:16:20 dtong Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class unit_config_data {

	protected static function resource_add($type) {
		return base_url() . "unit/resource/add/_UNITID_/" . $type;
	}
	//Function to get the unit page resource edit url
	protected static function resource_edit($type) {
		return base_url() . "unit/resource/edit/_UNITID_/" . $type . "/_RESID_";
	}
	//Function to get the unit page resource delete url
	protected static function resource_delete($type) {
		return base_url() . "unit/resource/delete/_UNITID_/_RESID_/$type" ;
	}

	protected static function stage_url() {
		return base_url() . 'course/desc/stage/_STAGENUM_/edit/_UNITID_';
	}

	static function get() {
		osa_load_lang('sysres');
		$unit_config = new stdClass();
		$unit_config->stage = array();

		$button_add =
			 array ('_type' => CMS_TEMPLATE_SYSTEM_COURSE_DESC, '_image' => 'add_24.gif', '_action' => 'edit',
				 '_link' => self::resource_add(CMS_TEMPLATE_SYSTEM_COURSE_DESC), '_title'=>FALSE,
			 	 '_alt_title' => lang('sysres_desc_add_res'),
				 '_jscript' => "newIframeWindow('" . self::resource_add(CMS_TEMPLATE_SYSTEM_COURSE_DESC) .
							   "','" . lang('sysres_desc_add_site_res') . "',700,700,'resource');return false;");
		$button_edit =
			 array ('_type' => CMS_TEMPLATE_SYSTEM_COURSE_DESC, '_image' => 'edit.gif', '_action' => 'edit',
				 '_link' => self::resource_edit(CMS_TEMPLATE_SYSTEM_COURSE_DESC), '_title'=>FALSE,
			 	 '_alt_title' => lang('sysres_desc_edit'), '_is_editbutton'=> TRUE ,
				 '_jscript' => "newIframeWindow('" . self::resource_edit(CMS_TEMPLATE_SYSTEM_COURSE_DESC) .
							   "','" . lang('sysres_desc_edit_site_res') . "',700,700,'resource');return false;");
		$button_delete =
		 array ('_type' => CMS_TEMPLATE_SYSTEM_COURSE_DESC, '_image' => 'x.gif', '_action' => 'edit',
		 '_link' => self::resource_delete(CMS_TEMPLATE_SYSTEM_COURSE_DESC), '_title'=>FALSE,  '_alt_title' => lang('sysres_desc_delete'),
		 '_jscript' => "return delUnitItem('" . self::resource_delete(CMS_TEMPLATE_SYSTEM_COURSE_DESC) . "','" . self::stage_url() .
					"','_STAGEDIV_','" . lang('sysres_desc_delete_confirm') . "')" );

		$unit_config->stage[1] = array (
			//'title1' => array('_type' => 'title', '_title' => 'Course Resources', '_action'=>'all'),
			'title2' => array('_type' => 'subtitle', '_title' => lang('sysres_desc_add_res_colon'), '_action'=>'edit',
									'_leftbutton' => array( $button_add)),
			//'title2_1' => array('_type' => 'subtitle', '_title' => 'Course Resources', '_action'=>'read'),

			CMS_TEMPLATE_SYSTEM_COURSE_DESC => array (
				'_type' => 'resource', '_typeid' => CMS_TEMPLATE_SYSTEM_COURSE_DESC, '_action'=>'all',
				'_title_add' => lang('sysres_desc_add_res'), '_title_edit' => lang('sysres_desc_edit_res'),
				'_text_flag' => TRUE, '_text_title' => FALSE, '_text_cols'=>100, '_text_rows'=>15, '_text_required'=>TRUE,
				'_save_text' => lang('sysres_desc_save'), '_cancel_text' => lang('sysres_desc_cancel'), '_delete_text' => FALSE, '_upload_flag'=>TRUE,
				'_url_flag'=>TRUE, '_url_title'=>TRUE, '_checkpublic_flag' => TRUE, '_category_bodytext' => FALSE,
				'_category_color' => FALSE, '_url_flag'=>TRUE, '_url_title'=>lang('sysres_desc_enter_url'),
				'_sort_flag'=>TRUE, '_button' => array($button_delete, $button_edit),
				'_allow_no_uploadandselect' => TRUE,
			)
		);

		return $unit_config;
	}

}