<?php
/**
 * template_date_model.php - Model for the requested completion date, add completion date or edit completion date in a table template_date.
 *
 * @author $Author: Samarth
 * @version $Id: template_date_model.php
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/
class template_date_model extends CI_Model {
	function __construct() {
		parent::__construct();
   }

 	function get_template_date($extid, $type) {
 		if ( empty($extid) || empty($type) ) {
 			return FALSE;
 		}
		$table_template_date = $this->db->dbprefix('template_date');
		$this->db->select('*');
	   $this->db->from($table_template_date);
		$this->db->where('extid', $extid);
		$this->db->where('type',$type);
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 ) {
			return FALSE;
		}
		$result = $res->result();
		return $result[0];
	}

 	function add_template_date($data) {
 		if ( empty($data) || !is_object($data) || !property_exists($data, 'extid') || !property_exists($data, 'type') ||
 			!property_exists($data, 'date') || empty($data->extid) || empty($data->type) || empty($data->date) ) {
 			return FALSE;
 		}
 		$table_template_date = $this->db->dbprefix('template_date');
 		$result = $this->get_template_date($data->extid,$data->type);
 		if ( !empty($result) ){
 			return $this->update_template_date($data);
 		}
 		return $this->db->insert($table_template_date, $data);
	}

	function update_template_date($data) {
		if ( empty($data) || !is_object($data) || !property_exists($data, 'extid') || !property_exists($data, 'type') ||
 			!property_exists($data, 'date') || empty($data->extid) || empty($data->type) || empty($data->date) ) {
 			return FALSE;
 		}
		$table_template_date = $this->db->dbprefix('template_date');
		$this->db->where('extid',$data->extid);
		$this->db->where('type',$data->type);
		return $this->db->update($table_template_date, $data);
	}
}
