<?php
/**
 * select_model.php - Model for Selection builder type
 *
 * @author $Author: dtong $
 * @version $Id: select_model.php,v 1.18 2011/02/11 14:09:29 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Select_model extends CI_Model {

	function __construct() {
		parent::__construct();
		//osa_load_lang('general');
		//osa_load_lang('unit');
    }

    function getdept($courseid) {
    	if ( !is_numeric($courseid) )
    		return FALSE;
    	//$dept = $this->db->dbprefix('department');
    	//$course = $this->db->dbprefix('course_sis');
    	//$sql = "select $dept.* from $course,$dept where $course.id=$courseid and $course.departmentid=$dept.id";
    	$this->db->select('department.*');
    	$this->db->from('course_sis,department');
    	$this->db->where('course_sis.id', $courseid);
    	$this->db->where('course_sis.departmentid=department.id', NULL, FALSE);
    	$res = $this->db->get();
    	if ( $res->num_rows <= 0 )
    		return FALSE;
    	$rows = $res->result();
    	return $rows[0];
    }

    /*
     * Not really using table selection_text any more should clean it up later
     * fix order by department name for Unified Unit
     */
    function get($unitid, $deptid, $type, $usetextid=FALSE) {
    	if ( $usetextid !== FALSE ) return FALSE; //Not supported any more
    	if ( !is_numeric($type) || (!is_array($deptid) && !is_numeric($deptid) ) )
    		return FALSE;
    	//$this->db->select('c.id as catid,c.text as cattext,c.type as cattype,t.*,s.id as checked');
    	$this->db->select('c.id as catid,c.text as cattext,c.type as cattype,s.id as checked,c.departmentid ');
    	$this->db->from('selection_category as c');
    	//$this->db->join('selection_text as t', 'c.id=t.categoryid', 'left');
    	//Have to make sure we always use catid becuase selection_text not implemented yet
    	$usetextid = FALSE;
    	if ( !$usetextid ) { //Use textid or catid
    		$this->db->join('unit_selection as s', "c.id=s.catid and s.unitid=$unitid", 'left');
    	}
    	else { //Use cat id
    		$this->db->join('unit_selection as s', "t.id=s.textid and s.unitid=$unitid", 'left');
    	}
    	$this->db->join('department as d', "d.id=c.departmentid", 'left');
    	//where flag enabled=1
    	$this->db->where('c.enabled', CMS_ADMIN_ENABLE);
    	$this->db->where('c.type', $type);
    	if ( is_array($deptid) )
    		$this->db->where_in('c.departmentid', $deptid);
    	else if ( is_numeric($deptid) )
    	 	$this->db->where('c.departmentid', $deptid);
    	//$this->db->where('s.unitid', $unitid);
    	//$this->db->order_by('c.id');
    	$this->db->order_by('d.name');
    	$this->db->order_by('c.sort');
    	$this->db->order_by('c.text');
    	$res = $this->db->get();
    	if ( $res->num_rows() <= 0 )
    		return FALSE;
    	$rows = $res->result();
    	return $rows;
    }

    function get_unit_selection($unitid, $type) {
    	if ( !is_numeric($unitid) || !is_numeric($type))
    		return FALSE;
    	$this->db->where('unitid', $unitid);
    	$this->db->where('type', $type);
    	$res = $this->db->get('unit_selection');
    	if ($res->num_rows() <= 0)
    		return FALSE;
    	return $res->result();
    }

    function get_category($unitid, $type) {
    	if ( !is_numeric($unitid) || !is_numeric($type))
    		return FALSE;
    	$this->db->select('s.*,c.departmentid,c.text');
    	$this->db->from('unit_selection as s');
    	$this->db->join('selection_category as c', 's.catid=c.id', 'left');
    	$this->db->join('department as d', "d.id=c.departmentid", 'left');
    	$this->db->where('s.unitid', $unitid);
    	$this->db->where('s.type', $type);
    	//Added sort 26/4/10, somehow no one had complained about this.
    	$this->db->order_by('d.name');
    	$this->db->order_by('c.sort');
    	$this->db->order_by('c.text');
    	$res = $this->db->get();
    	if ($res->num_rows() <= 0)
    		return FALSE;
    	return $res->result();
    }

    function update($unitid, $type, $ids) {
    	$selections = $this->get_unit_selection($unitid, $type);
    	//$ids_str = osa_getarrayvalue($ids,',');
    	$insertids = $ids;
    	if ( $selections ) {
	    	foreach ($selections as $selection) {
	    		//$curids[$selection->id] = 1;
	    		unset($insertids[$selection->id]);
	    	}
    	}
    	$sql = ''; $sep='';
    	foreach ($insertids as $tmpid) {
    		$sql .= $sep . "($unitid,$tmpid,$type)";
    		$sep = ',';
    	}
    	if ( $sql != '' ) {
    		$table = $this->db->dbprefix('unit_selection');
    		$sql = "insert into $table (unitid,catid,type) value $sql";
    	}
    	$this->db->trans_start();
    		$this->db->where('unitid', $unitid);
    		$this->db->where('type', $type);
    		if ( count($ids) > 0 ) //if empty array then delete all
    			$this->db->where_not_in('id', $ids);
    		$this->db->delete('unit_selection');
    		if ( $sql != '' ) {
    			$this->db->query($sql);
    		}
    	$this->db->trans_complete();
    	return $this->db->trans_status();
    }

    function delete($unitid,$selid) {
    	if ( !is_numeric($unitid) || !is_numeric($selid))
    		return FALSE;
    	$this->db->where('id', $selid);
		$this->db->where('unitid', $unitid);
		return $this->db->delete('unit_selection');
    }

	// get all department
    function get_departments($key='id', $toArray=FALSE) {
    	//Use the CMS cache becuase someone put in code to call this function
		//in a loop from unit_lt and unit_select
		$this->load->library('cms/cms_cache');
		$cache_key = "{$key}_{$toArray}";
		if ( ($cache_val = $this->cms_cache->db_get(__METHOD__, $cache_key) ) !== NULL )
			return $cache_val;

	   $this->db->select('id, name');
		$this->db->from('department');
	    //$this->db->where('id',$deptid);
		$resobj = $this->db->get();
		if ( $resobj->num_rows() < 1 ) {
			$this->cms_cache->db_add(__METHOD__, $cache_key, FALSE);
     	 	return FALSE;
		}
 		$result = $resobj->result();
 		if ($key != '' && $toArray) {
 			$ret_val = $this->toArray($result, $key);
 			$this->cms_cache->db_add(__METHOD__, $cache_key, $ret_val);
 			return $ret_val;
 		}
 		$this->cms_cache->db_add(__METHOD__, $cache_key, $result);
 		return $result;
	    //return $result = $resobj->result_array();
    }

    function toArray($rows, $key='id') {
    	if (!is_array($rows))
    		return FALSE;

    	$data = array();
		foreach ($rows as $row) {
			$data[$row->$key] = $row;
		}
		return $data;
    }

	function get_department($data, $key, $field='name') {
    	if (!is_array($data))
    		return FALSE;
		$value = FALSE;

    	if (array_key_exists( $key, $data ))
    		$value = $data[$key]->$field;
		return $value;
	}
}
?>