<?php
/**
 * os_model.php - Outcomes and Skills type
 *
 * @author $Author: dtong $
 * @version $Id: os_model.php,v 1.13 2011/05/09 04:48:53 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Os_model extends CI_Model {
	public $sort_read_only = FALSE;
	public $sort_type = FALSE;
	public $sort_filehash = FALSE;

	function __construct() {
		parent::__construct();
    }

    function getdept($courseid) {
    	if ( !is_numeric($courseid) )
    		return FALSE;
    	//$dept = $this->db->dbprefix('department');
    	//$course = $this->db->dbprefix('course_sis');
    	//$sql = "select $dept.* from $course,$dept where $course.id=$courseid and $course.departmentid=$dept.id";
    	$this->db->select('department.*');
    	$this->db->from('course_sis,department');
    	$this->db->where('course_sis.id', $courseid);
    	$this->db->where('course_sis.departmentid=department.id', NULL, FALSE);
    	$res = $this->db->get();
    	if ( $res->num_rows <= 0 )
    		return FALSE;
    	$rows = $res->result();
    	return $rows[0];
    }

    /*
     * Not really using table selection_text any more should clean it up later
     */
    function get($unitid, $deptid, $type, $usetextid=FALSE) {
    	if ( $usetextid !== FALSE ) return FALSE; //Not supported any more
    	if ( !is_numeric($type) || (!is_array($deptid) && !is_numeric($deptid) ) )
    		return FALSE;
    	//$this->db->select('c.id as catid,c.text as cattext,c.type as cattype,t.*,s.id as checked');
    	$this->db->select('c.id as catid,c.text as cattext,c.type as cattype,s.id as checked,c.departmentid ');
    	$this->db->from('selection_category as c');
    	//$this->db->join('selection_text as t', 'c.id=t.categoryid', 'left');
    	//Have to make sure we always use catid becuase selection_text not implemented yet
    	$usetextid = FALSE;
    	if ( !$usetextid ) { //Use textid or catid
    		$this->db->join('unit_selection as s', "c.id=s.catid and s.unitid=$unitid", 'left');
    	}
    	else { //Use cat id
    		$this->db->join('unit_selection as s', "t.id=s.textid and s.unitid=$unitid", 'left');
    	}
    	$this->db->where('c.type', $type);
    	if ( is_array($deptid) )
    		$this->db->where_in('c.departmentid', $deptid);
    	else if ( is_numeric($deptid) )
    	 	$this->db->where('c.departmentid', $deptid);
    	//$this->db->where('s.unitid', $unitid);
    	//$this->db->order_by('c.id');
    	$this->db->order_by('c.sort');
    	$res = $this->db->get();
    	if ( $res->num_rows() <= 0 )
    		return FALSE;
    	$rows = $res->result();
    	return $rows;
    }

    function get_unit_selection($unitid, $type) {
    	if ( !is_numeric($unitid) || !is_numeric($type))
    		return FALSE;
    	$this->db->where('unitid', $unitid);
    	$this->db->where('type', $type);
    	$res = $this->db->get('unit_selection');
    	if ($res->num_rows() <= 0)
    		return FALSE;
    	return $res->result();
    }

    function update($unitid, $type, $ids) {
    	$selections = $this->get_unit_selection($unitid, $type);
    	//$ids_str = osa_getarrayvalue($ids,',');
    	$insertids = $ids;
    	if ( $selections ) {
	    	foreach ($selections as $selection) {
	    		//$curids[$selection->id] = 1;
	    		unset($insertids[$selection->id]);
	    	}
    	}
    	$sql = ''; $sep='';
    	foreach ($insertids as $tmpid) {
    		$sql .= $sep . "($unitid,$tmpid,$type)";
    		$sep = ',';
    	}
    	if ( $sql != '' ) {
    		$table = $this->db->dbprefix('unit_selection');
    		$sql = "insert into $table (unitid,catid,type) value $sql";
    	}

    	$this->db->trans_start();
    		$this->db->where('unitid', $unitid);
    		$this->db->where('type', $type);
    		if ( count($ids) > 0 ) //if empty array then delete all
    			$this->db->where_not_in('id', $ids);
    		$this->db->delete('unit_selection');
    		if ( $sql != '' ) {
    			$this->db->query($sql);
    		}
    	$this->db->trans_complete();
    	return $this->db->trans_status();
    }

	// get all department
    function  get_departments($key='id', $toArray=FALSE) {
	    $this->db->select('id, name');
		$this->db->from('department');
	    //$this->db->where('id',$deptid);
		$resobj = $this->db->get();
		if ( $resobj->num_rows() < 1 )
     	 	return FALSE;
 		$result = $resobj->result();
 		if ($key != '' && $toArray)
 			return $this->toArray($result, $key);
 		else
 			return $result;
	    //return $result = $resobj->result_array();
    }

    function toArray($rows, $key='id') {
    	if (!is_array($rows))
    		return FALSE;

    	$data = array();
		foreach ($rows as $row) {
			$data[$row->$key] = $row;
		}
		return $data;
    }

    /*
	//Get all outcomes and skills for when clicking on outcomes and skills from left menu tree
	function get_outcomes_skills_all($strandid, $standardid, $courseid, $type) {
		$this->db->select('b.data outcomes, t.data skills, b.id outcomesid, t.id skillsid ');
		$this->db->from('strand s');
		$this->db->join('standard d', 'd.strandid=s.id AND d.type=s.type ');
		$this->db->join('benchmark b','b.standardid=d.id AND b.type=d.type');
		$this->db->join('target_text t', 't.benchmarkid = b.id AND t.courseid = b.courseid AND b.type=t.type ', 'left');
	 	$this->db->where('s.id', $strandid );
	 	$this->db->where('d.id', $standardid);
	 	$this->db->where('b.courseid', $courseid);
		$this->db->where('b.type', $type);
		$this->db->order_by('b.data, b.id, t.data');

		$resobj = $this->db->get();
		if ( $resobj->num_rows() <= 0 )
			return FALSE;
		$rows = $resobj->result();

		return $rows;
	}
	*/

	//Get all outcomes and skills for when clicking on outcomes and skills from left menu tree
	//Also for the OS button within the unit page but $skip_multicourse is false.
	//$add_courseids are from integrated and shared units
	function get_outcomes_skills_all($courseid, $type, $strandid=1, $standardid=1, $skip_multicourse=FALSE, $add_courseids=FALSE) {
		if (!osa_is_int_one($courseid) || !osa_is_int_one($type) || !osa_is_int_one($strandid) ||
			 !osa_is_int_one($standardid) ) {
			return FALSE;
		}
		$table_standard    = $this->db->dbprefix('standard');
		$table_strand      = $this->db->dbprefix('strand');
		$table_benchmark   = $this->db->dbprefix('benchmark');
		$table_target_text = $this->db->dbprefix('target_text');
		$table_res_sort    = $this->db->dbprefix('res_sort');
		$table_course_sis  = $this->db->dbprefix('course_sis');

		$coursesql = $courseid;
		$courseid_array = array();
		//Add the actual courseid too for the complete list of courses to pass into btnsort
		$courseid_array[$courseid] = $courseid;
		if ( !$skip_multicourse ) {
			$this->load->model('course/course_model');
			$all_courses = $this->course_model->get_course_lt_link($courseid, TRUE);
			if ($all_courses) {
				//list from link outcomes skills
				foreach ($all_courses as $row) {
					$coursesql .= ",$row->lt_courseid";
					$courseid_array[$row->lt_courseid] = $row->lt_courseid;
				}
			}
			if ( $add_courseids ) {
				//course from int and shared
				foreach ($add_courseids as $value) {
					$coursesql .= ",{$value}";
					$courseid_array[$value] = $value;
				}
			}
		}
		if ( count($courseid_array) == 1 ) {
			//btnsort needs an int for write mode so have to switch to int if there is only
			//one element
			$courseid_array = $courseid;
		}

		if ( $coursesql == $courseid ) {
			$coursesql = "b.courseid={$courseid}";
		}
		else {
			$coursesql = "b.courseid in ({$coursesql})";
		}
		//TODO: Copied most from d*** sort_model (it was copied from here...) and will optimize it later
		$sql = "select case when c.id={$courseid} then 1 else 2 end sortcourseid,c.name coursename," .
				 "b.data outcomes,b.id outcomesid,b.courseid,t.data skills, t.id skillsid,t.id,'{$type}' as type " .
				 "from $table_strand as d " .
				 "join $table_standard s on s.strandid=d.id and s.type={$type} and s.id={$standardid} " .
				 "left join $table_benchmark b on b.standardid=s.id and b.type={$type} and $coursesql " .
				 "left join $table_course_sis as c on c.id=b.courseid " .
				 "left join $table_target_text as t on t.benchmarkid=b.id and t.type={$type} " .
				 "where d.id={$strandid} and d.type={$type}";
		$res = $this->db->query($sql);
		$num_rows = $res->num_rows();
		if ( $num_rows <= 0 ) {
			return FALSE;
		}
    	$ret = $res->result();
    	if ( $this->sort_type ) {
	    	if ( !osa_array_natsort($ret, array('sortcourseid','coursename','courseid','outcomes','outcomesid','skills')) ) {
	    			return NULL;
	    	}
			//multi courses meands read only btnsort operation
			if ( !$this->btnsort_init($ret, $courseid_array, $this->sort_type, !$skip_multicourse) ) {
				return NULL;
			}
			//To make sure the order didn't break
			if ( !osa_array_natsort($ret, array('sortcourseid','coursename','courseid','outcomes','outcomesid',Cms_btnsort::INDEX_SORTKEY)) ) {
				return NULL;
			}
    	}
    	else {
    		//No btnsort
    		if ( !osa_array_natsort($ret, array('sortcourseid','coursename','courseid','outcomes','outcomesid','skills')) ) {
    			return NULL;
    		}
    	}
		return $ret;
	}

	//Get a outcomes and skills when click edit pop up
	function get_course_outcomes_skills($courseid, $outcomesid, $type, $strandid=1, $standardid=1) {
		if ( !osa_is_int_one($outcomesid) || !osa_is_int_one($courseid) || !osa_is_int_one($type) ) {
			return FALSE;
		}
		$this->db->select('b.data outcomes, t.data skills, b.id outcomesid, t.id skillsid, t.id, b.courseid, b.type');
		$this->db->from('strand s');
		$this->db->join('standard d', 'd.strandid=s.id AND d.type=s.type ');
		$this->db->join('benchmark b','b.standardid=d.id AND b.type=d.type');
		$this->db->join('target_text t', 't.benchmarkid = b.id AND t.courseid = b.courseid AND b.type=t.type ', 'left');
		//$this->db->join('unit_target u', 'u.targetid=t.id AND u.benchmarkid=t.benchmarkid AND u.target_type=t.type ', 'left');
	 	$this->db->where('s.id', $strandid);
	 	$this->db->where('d.id', $standardid);
	 	$this->db->where('b.courseid', $courseid);
	 	$this->db->where('b.id', $outcomesid);
		$this->db->where('b.type', $type);
		//$this->db->order_by('b.data, b.id, t.data');

		$resobj = $this->db->get();
		if ( $resobj->num_rows() <= 0 ) {
			return FALSE;
		}
		$rows = $resobj->result();
		if ( !osa_array_natsort($rows, array('outcomes','outcomesid','skills')) ) {
			return FALSE;
		}
		if ( $this->sort_type ) {
			if ( !$this->btnsort_init_segment($rows, $courseid, $this->sort_type, $outcomesid) ) {
				return FALSE;
			}
		}
		return $rows;
	}
/*
	//Function is OBSOLETE?
	function get_outcomes_skills($unitid, $type, $strandid=1, $standardid=1) {
		$this->db->select('t.id, b.data outcomes, t.data skills, b.id outcomesid, t.id skillsid, u.unitid');
		$this->db->from('strand s');
		$this->db->join('standard d', 'd.strandid=s.id AND d.type=s.type ');
		$this->db->join('benchmark b','b.standardid=d.id AND b.type=d.type');
		$this->db->join('target_text t', 't.benchmarkid = b.id AND t.courseid = b.courseid AND b.type=t.type ', 'right');
		$this->db->join('unit_target u', 'u.targetid=t.id AND u.benchmarkid=t.benchmarkid AND u.target_type=t.type ', 'left');
	 	$this->db->where('s.id', $strandid);
	 	$this->db->where('d.id', $standardid);
		$this->db->where('b.type', $type);
		$this->db->where('u.unitid', $unitid);
		$this->db->order_by('b.data, b.id, t.data');

		$resobj = $this->db->get();
		if ( $resobj->num_rows() <= 0 )
			return FALSE;
		//$rows = $resobj->result();

		return $resobj->result();
	}
*/

	//For the unit page OS popup to select skills for a particulr unit
	function get_outcomes_skills($courseid, $unitid, $type, $strandid=1, $standardid=1) {
		if ( !osa_is_int_one($courseid) || !osa_is_int_one($unitid) ) {
			return FALSE;
		}
/*
		$this->db->select('t.id, b.data outcomes, t.data skills, b.id outcomesid, t.id skillsid,' .
								'u.unitid, c.name coursename, c.id courseid,' .
								"case when c.id={$courseid} then 1 else 2 end sortcourseid");
		$this->db->from('unit_target u');
		$this->db->join('target_text t', "u.targetid=t.id");
		$this->db->join('benchmark b', "b.id=t.benchmarkid and b.type={$type}");
		$this->db->join('standard d', 'd.id=b.standardid');
		$this->db->join('strand s', 's.id=d.strandid');
		$this->db->join('course_sis c', 'c.id=b.courseid');
		$this->db->where('u.unitid', $unitid);
	 	$this->db->where('s.id', $strandid);
	 	$this->db->where('d.id', $standardid);
		$this->db->order_by('sortcourseid, c.name,c.id,b.data, b.id, t.data');
*/
		$sql = 'select t.id, b.data outcomes, t.data skills, t.benchmarkid outcomesid, t.id skillsid,' .
				 	'u.unitid, c.name coursename, c.id courseid, b.type,' .
				 	"case when c.id={$courseid} then 1 else 2 end sortcourseid " .
				 'from unit_target u ' .
				 "join target_text t on u.unitid={$unitid} and u.targetid=t.id " .
				 "join benchmark b on b.id=t.benchmarkid and b.type={$type} " .
				 'join standard d on d.id=b.standardid ' .
				 'join strand s on s.id=d.strandid ' .
				 'join course_sis c on c.id=b.courseid ' .
	 			 "where s.id=$strandid and d.id=$standardid";
				 //'order by sortcourseid, c.name, c.id, b.data, b.id, t.data';
		$resobj = $this->db->query($sql);
		if ( $resobj->num_rows() <= 0 )
			return FALSE;

		$rows = $resobj->result();

		if ( !osa_array_natsort($rows, array('sortcourseid','coursename','courseid','outcomes','outcomesid','skills'))) {
			return FALSE;
		}
		//multi courses meands read only btnsort operation
		if ( $this->sort_type ) {
			if ( !$this->btnsort_init($rows, $unitid, $this->sort_type, FALSE, 'unitid') ) {
				return FALSE;
			}
		}
		//To make sure the order didn't break
		if ( !osa_array_natsort($rows, array('sortcourseid','coursename','courseid','outcomes','outcomesid',Cms_btnsort::INDEX_SORTKEY)) ) {
			return FALSE;
		}

		return $rows;
	}

	//get outcomes/skills selected by fix strand, standard or by department
	function get_selected($unitid, $type, $depnotnull=FALSE, $strandid=1, $standardid=1) {
		/*
    	$this->db->select('b.data outcomes, t.data skills, b.id outcomesid, t.id skillsid, u.unitid');
		$this->db->from('strand s');
		$this->db->join('standard d', 'd.strandid=s.id AND d.type=s.type ');
		$this->db->join('benchmark b','b.standardid=d.id AND b.type=d.type');
		$this->db->join('target_text t', 't.benchmarkid = b.id AND t.courseid = b.courseid AND b.type=t.type ', 'right');
		$this->db->join('unit_target u', 'u.targetid=t.id AND u.benchmarkid=t.benchmarkid AND u.target_type=t.type ', 'left');
		*/
		// outcomes by department
		$this->db->select('b.data outcomes, t.data skills, b.id outcomesid, t.id skillsid, u.unitid');
		$this->db->from('unit_target u');
		$this->db->join('target_text t', 't.id = u.targetid and t.type=u.target_type ');
		$this->db->join('benchmark b','b.id = t.benchmarkid and b.type=t.type');
		$this->db->join('standard d','d.id = b.standardid and d.type=b.type');
		$this->db->join('strand s','s.id = d.strandid and s.type=d.type');

		if ($depnotnull === FALSE) {
		 	$this->db->where('s.id', $strandid);
		 	$this->db->where('d.id', $standardid);
		}
		else {
			$where = 's.departmentid is not null';
			$this->db->where($where);
		}

		$this->db->where('b.type', $type);
		$this->db->where('u.unitid', $unitid);
		$this->db->order_by('b.data, b.id, t.data');

	 	$resobj = $this->db->get();
		if ( $resobj->num_rows() <= 0 )
			return FALSE;
		$rows = $resobj->result();

		$result = array();
		if ($rows !== FALSE)
			foreach ($rows as $row) {
				$result[$row->skillsid] = $row;
			}

		return $result;
	}

	function get_unselected($unitid, $type, $ids, $standardid=1) {
		$this->db->select('unitid, benchmarkid outcomesid,targetid skillsid ');
		$this->db->from('unit_target');
		$this->db->where('target_type', $type);
		$this->db->where('unitid', $unitid);

	 	$resobj = $this->db->get();
		if ( $resobj->num_rows() <= 0 )
			return FALSE;
		$rows = $resobj->result();
		return $rows;
	}

    function get_unit_target($unitid, $type, $standardid=1) {

    	$this->db->select('b.data outcomes, t.data skills, b.id outcomesid, t.id skillsid, b.standardid, b.type, u.unitid');
		$this->db->from('unit_target u');
		$this->db->join('target_text t', 't.benchmarkid = u.benchmarkid AND t.id = u.targetid and t.type=u.target_type ');
		$this->db->join('benchmark b', 'b.id = t.benchmarkid and b.type=t.type and b.courseid=t.courseid');

 		$this->db->where('b.standardid', $standardid);
		$this->db->where('b.type', $type);
	 	$this->db->where('u.unitid', $unitid);
	 	$this->db->order_by('b.data, b.id, t.data');

		$resobj = $this->db->get();
		if ( $resobj->num_rows() <= 0 )
			return FALSE;

		return $resobj->result();

    }

	function save($unitid, $type, $addids, $delids) {
		$insertids  = $addids;
		$unselected = $this->get_unselected($unitid, $type, $insertids);

		//skillsid
		$html = '';
		$deleteids = array();
		if ( $unselected != FALSE ) {
	    	foreach ($unselected as $id) {

	    		unset($insertids[$id->skillsid]);

	    		if (array_key_exists($id->skillsid , $delids)) {
	    			$deleteids[$id->skillsid] = $id->outcomesid;
	    			//$html .= '<br />' . $id->skillsid;
	    		}
	    			//$html .= '<br />' . $id->skillsid;
	    		//set($insertids[$id->skillsid]);
	    	}
    	}

		$sql_add = '';
		$sql_del = '';
		$sep='';
    	foreach ($insertids as $skillsid => $outcomesid) {
    		$sql_add .= $sep . "($unitid, $type, $skillsid, $outcomesid)";
    		$sep = ',';
    	}
    	$sep='';
    	$del_skillsids   = '';
    	$del_outcomesids = '';
		foreach ($deleteids as $skillsid => $outcomesid) {
			$del_skillsids   .= $sep . $skillsid;
			$del_outcomesids .= $sep . $outcomesid;
			$sep = ',';
    	}

    	//$html .= '<br />' . $del_skillsids) . ';' . $del_outcomesids;

    	if ( $sql_add != '' ) {
    		 $table   = $this->db->dbprefix('unit_target');
    		 $sql_add = "insert into $table (unitid, target_type, targetid, benchmarkid) value $sql_add";
    	}

		if ( $del_skillsids != '' && $del_outcomesids != '' ) {
    		 $table    = $this->db->dbprefix('unit_target');
    		 $sql_del  = "delete from $table ";
    		 $sql_del .= "where unitid=$unitid and target_type=$type and benchmarkid in ($del_outcomesids) and targetid in ($del_skillsids) ";
    	}


		// return $sql_del. ';' .  $sql_add;
		//$html .= $sql_del . '<br />';
		//$html .= $sql_add . '<br />';

    	$this->db->trans_start();
/*
    		$this->db->where('unitid', $unitid);
    		$this->db->where('target_type', $type);
    		if ( $del_skillsids != FALSE )  {
    		  	$this->db->where_in('benchmarkid', $del_outcomesids);
    		  	$this->db->where_in('targetid', $del_skillsids);
    			$this->db->delete('unit_target');
    		}*/
			if ( $sql_del != '' ) {
    			$this->db->query($sql_del);
    			//$html .= $sql_del. '<br />';
    		}
    		if ( $sql_add != '' ) {
    			$this->db->query($sql_add);
    			//$html .= $sql_add. '<br />';
    		}
    	$this->db->trans_complete();

    	//return $this->db->trans_status();

    	return $this->db->trans_status() ;
    }

    function course_outcomes_delete ($skillsid, $outcomesid, $courseid, $type) {
		if ( !is_numeric($skillsid) || !is_numeric($outcomesid) || !is_numeric($courseid) || !is_numeric($type))
	    	return FALSE;
    	//delete res_sort
		$table_res_sort = $this->db->dbprefix('res_sort');
		$this->db->where('fk2', $courseid);
		$this->db->where('fk3', $skillsid);
		$this->db->delete($table_res_sort);

		$this->db->where('id', $skillsid);
		$this->db->where('benchmarkid', $outcomesid);
	 	$this->db->where('courseid', $courseid);
	 	$this->db->where('type', $type);
		return $this->db->delete('target_text');
    }

    function course_outcomes_target($skillsid, $outcomesid, $courseid, $type, $standardid=1) {

    	$this->db->select('u.unitid, u.benchmarkid outcomesid, u.targetid skillsid,u.target_type type ');
    	$this->db->from('unit_target u');
    	$this->db->join('target_text t', 't.benchmarkid = u.benchmarkid AND t.id = u.targetid and t.type=u.target_type ');
 		$this->db->where('t.courseid', $courseid);
 		$this->db->where('u.benchmarkid', $outcomesid);
 		$this->db->where('u.targetid', $skillsid);
		$this->db->where('u.target_type', $type);

	 	$resobj = $this->db->get();
		if ( $resobj->num_rows() <= 0 )
			return FALSE;

		return $resobj->result();
    }

    function course_outcomes_save($courseid, $outcomesid, $type, $outcomes, $add_skillsids , $edit_skillsids, $standardid=1) {

    	$isedit = FALSE;

    	if ( is_numeric($outcomesid))
			$isedit = TRUE;

		$sql = ''; $sep='';
		$outcomes = addslashes($outcomes);
		//sql outcomes
		if ($isedit===TRUE) {
			$table = $this->db->dbprefix('benchmark');
			$sql .= "data=\"$outcomes\"";
			$sql  = "update $table set $sql where courseid=$courseid and id=$outcomesid and type=$type ";
			$sql_outcomes = $sql;
		} else {
	    	$sql .= $sep . "($courseid, $standardid, $type, \"$outcomes\")";
	    	$sep = ',';
	    	if ($sql != '' && $isedit === FALSE) {
	    		$table = $this->db->dbprefix('benchmark');
	    		$sql = "insert into $table (courseid, standardid, type, data) value $sql";
	    	}
	    	$sql_outcomes = $sql;
		}

		//sql skills insert
    	$sql = ''; $sep='';
   		foreach ($add_skillsids as $data) {
   			$data = addslashes($data);
	    	if ($isedit === TRUE) {
	    		$sql .= $sep . "($outcomesid, $courseid, $type, \"$data\")";
	    		$sep = ',';
	    	}
	    	else {
	    		$sql .= $sep . "(outcomesid, $courseid, $type, \"$data\")";
	    		$sep = ',';
	    	}

    	}
    	if ($sql != ''  ) {
    		$table = $this->db->dbprefix('target_text');
    		$sql = "insert into $table (benchmarkid, courseid, type, data) value $sql";
    	}
    	$sql_skills_add = $sql;

    	//sql skills update
		$sql = ''; $sep='';
		$sql_skills_edit = array();
   		foreach ($edit_skillsids as $key => $data) {
   			$data = addslashes($data);
	    	$table = $this->db->dbprefix('target_text');
			$sql   = "data=\"$data\"";
			$sql   = "update $table set $sql where id=$key and type=$type ";
			$sql_skills_edit[]= $sql;
    	}

		$this->db->trans_start();

    		if ( $sql_outcomes != '' ) {
    			$this->db->query($sql_outcomes);
    			$outcomesid = osa_db_lastinsertid($this->db);
    		}

    		if ($isedit === FALSE)
    			$sql_temp = str_replace('outcomesid', $outcomesid, $sql_skills_add);
			else
				$sql_temp = $sql_skills_add;

			if ( $sql_temp != '' )
    			$this->db->query($sql_temp);

    		foreach ($sql_skills_edit as $sql) {
				if ( $sql != '' )
    				 $this->db->query($sql);
    		}

    	$this->db->trans_complete();
    	return $this->db->trans_status();
    }

    function delete($unitid, $selid) {
    	if ( !is_numeric($unitid) || !is_numeric($selid))
    		return FALSE;
    	$this->db->where('targetid', $selid);
		$this->db->where('unitid', $unitid);
		return $this->db->delete('unit_target');
    }

	function course_outcomes_all_delete($outcomesid, $courseid, $outcomes_type, $skillsid=FALSE) {
    	if ( !is_numeric($outcomesid) || !is_numeric($outcomesid) || !is_numeric($outcomes_type)) {
    		echo osa_ajaxmsg(lang('unit_failedtodeletedata'));
    		return FALSE;
    	}
		$del_unit_target ='';
		$del_target_text ='';
		$del_benchmark   ='';


		IF ($skillsid != FALSE) {
			$table_unit_target = $this->db->dbprefix('unit_target');
			$del_unit_target = "delete from $table_unit_target where benchmarkid=$outcomesid and target_type=$outcomes_type and targetid=$skillsid";

			$table_target_text = $this->db->dbprefix('target_text');
			$del_target_text = "delete from $table_target_text where benchmarkid=$outcomesid and courseid=$courseid and id=$skillsid";
		}

		IF ($skillsid == FALSE) {
			$table_unit_target = $this->db->dbprefix('unit_target');
			$del_unit_target = "delete from $table_unit_target where benchmarkid=$outcomesid and target_type=$outcomes_type";

			$table_target_text = $this->db->dbprefix('target_text');
			$del_target_text = "delete from $table_target_text where benchmarkid=$outcomesid and courseid=$courseid";

			$table_benchmark = $this->db->dbprefix('benchmark');
			$del_benchmark = "delete from $table_benchmark where id=$outcomesid and courseid=$courseid";
		}

		$this->db->trans_start();
			if ( $del_unit_target != '' )
    			$this->db->query($del_unit_target);
    		if ( $del_target_text != '' )
    			$this->db->query($del_target_text);
    		if ( $del_benchmark != '' )
    			$this->db->query($del_benchmark);
		/*
    		$this->db->where('unitid', $unitid);
    		$this->db->where('type', $type);
    		if ( count($ids) > 0 ) //if empty array then delete all
    			$this->db->where_not_in('id', $ids);
    		$this->db->delete('unit_selection');

    		}
    		*/
    	$this->db->trans_complete();
    	return $this->db->trans_status();
    }

    //get data outcomes/skills by department.
    function get_outcomes_bydep($courseid, $type) {
		$select  = '';
		$from    = '';
		$join    = '';
		$where   = '';
		$orderby = '';

		$table_standard    = $this->db->dbprefix('standard');
		$table_strand      = $this->db->dbprefix('strand');
		$table_benchmark   = $this->db->dbprefix('benchmark');
		$table_target_text = $this->db->dbprefix('target_text');
		//$table_res_sort    = $this->db->dbprefix('res_sort');
		$table_course_sis  = $this->db->dbprefix('course_sis');

   	$select .= "d.id depid, d.data department, s.data standard, s.id standardid, ";
		$select .= 't.id, case when t.type ='.CMS_OUTCOMES_SKILLS_TYPE.' then '.CMS_SORT_OS_COURSE.' else t.type end as "type", ';

		$select .= 'b.data outcomes, b.id outcomesid, b.courseid, ';
		$select .= 't.data skills, t.id skillsid, t.id ';


		$from   = "$table_strand as d ";
		$join   .= "join $table_course_sis as c on c.departmentid=d.departmentid ";
	   $join   .= "left join $table_standard    as s on s.strandid=d.id     and s.type= $type "; // and s.id= $standardid ";
		$join   .= "left join $table_benchmark   as b on b.standardid=s.id   and b.type= $type ";
		$join   .= "left join $table_target_text as t on t.benchmarkid=b.id  and t.type= $type ";

		//$join   .= "left join $table_res_sort    as r on r.fk2=t.courseid    and r.fk3 = t.id ";
	//	$where  .= "d.id = $strandid ";
		$where  .= " c.id = ".$courseid . " ";
		$where  .= " and d.type=". CMS_OUTCOMES_SKILLS_TYPE . " ";
		$where  .= " and d.departmentid is not null ";

		$orderby.= 'd.data, d.id, s.data, s.id, c.name,c.id, b.data, b.id, t.data, t.id  ';

		$query   = "select $select from $from $join where $where order by $orderby ";
		$res = $this->db->query( $query );

		if ( $res->num_rows() <= 0 )
    		 return FALSE;

    	$rows = $res->result();

    	return $rows;
	}

	//Many places call this funtion so put it in the model since it does alter the db data result data set
	public function btnsort_init_segment(&$data, $coreid, $type, $segment_idnumber,
													 $coreindex='courseid', $linkid='id', $typeindex='type') {
		$this->load->library('cms/cms_btnsort');
		if ( !$this->cms_btnsort->reset($this->sort_filehash, $coreid, $type, $coreindex, $linkid, $typeindex) ) {
			return FALSE;
		}
		//This is always a read-only operation
		$this->cms_btnsort->get_by_segment($segment_idnumber);
		return $this->cms_btnsort->init($data);
	}

	//Many places call this funtion so put it in the model since it does alter the db data result data set
	public function btnsort_init(&$data, $coreid, $type, $read_only, $coreindex='courseid',
										  $linkid='id', $segmentid='outcomesid', $typeindex='type') {
		$this->load->library('cms/cms_btnsort');
		if ( !$this->cms_btnsort->reset($this->sort_filehash, $coreid, $type, $coreindex, $linkid, $typeindex) ) {
			return FALSE;
		}
		$this->cms_btnsort->pre_fetch_off();
		$this->cms_btnsort->ignore_empty_linkid();
		$this->cms_btnsort->set_segmentindex($segmentid);
		if ( $read_only || $this->sort_read_only ) {
			$this->cms_btnsort->read_only();
		}
		return $this->cms_btnsort->init($data);
	}

}
?>