<?php
/**
 * Template_access_control_model.php - Modle for Template_access_control.php
 *
 * @author $Author: dtong $
 * @version $Id: handle_user_role_model.php,v 1.3 2011/04/13 10:20:09 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

class Handle_user_role_model extends CI_Model {

	function __construct() {
		parent::__construct();
    }

   //Check is the current user owner/editor of a unit/goal/survey
	function is_owner($userid, $table_id, $table, $userid_column='creatorid') {
		//Always look for the cache before actual query
	   $cachekey = "{$userid}_{$table_id}_{$table}_{$userid_column}";
		if ( ($cache_value = $this->cms_cache->db_get(__METHOD__, $cachekey)) !== NULL )
			return $cache_value;

		$ret = FALSE;
		//unit table has editorid.
	   //unit.creatorid is the person who created the unit at the very begining and then it doesn't change.
	   //Just check is the user an editor of the course
		if ( $table == 'unit' ) {
			$this->load->model('course/course_model');
	   	$this->load->model('course/unit_model');
	   	if ( $courseobj = $this->unit_model->get_course($table_id) ) {
	   		$ret = $this->course_model->isCourseEditor($userid, $courseobj->id);
	   	}
	   	$this->cms_cache->db_add(__METHOD__, $cachekey, $ret);
		   return $ret;
	   }

	   //For non-unit tables
		$this->db->select('id');
		$this->db->from($table);
		$this->db->where('id', $table_id);
		$this->db->where($userid_column, $userid);
		$resobj = $this->db->get();
		if ( $resobj->num_rows() > 0 )
	      $ret = TRUE;
	   $this->cms_cache->db_add(__METHOD__, $cachekey, $ret);
	   return $ret;
	}

	//Check to see does a user has any one of the supplied roles (user_role.type column)
	function has_roles($userid, $roles) {
		//Always look for the cache before actual query
		$cachekey = "{$userid}_{$roles}";
		if ( ($cache_value = $this->cms_cache->db_get(__METHOD__, $cachekey)) !== NULL )
			return $cache_value;

		$roles = explode(',',$roles);
		$ret = FALSE;
		$this->db->select('id');
		$this->db->from('user_role');
		$this->db->where('userid', $userid);
		$this->db->where_in('type', $roles);
		$resobj = $this->db->get();
		if ( $resobj->num_rows() > 0 )
	      $ret = TRUE;
	   $this->cms_cache->db_add(__METHOD__, $cachekey, $ret);
	   return $ret;
	}

	//TODO: This does not work with unit table since there can be multiple unit editors.
	//This will always return false for unit table.
	//You need to modify this function if you need this for the unit table
	function creatorid_has_roles($table, $table_id, $roles, $userid_column='creatorid') {
		$cachekey = "{$table}_{$table_id}_{$roles}_{$userid_column}";
		if ( ($cache_value = $this->cms_cache->db_get(__METHOD__, $cachekey)) !== NULL ) {
			return $cache_value;
		}
		//Take CMS_TEMPLATE_UNIT_IDENTIFIER out if you add support for unit templates.
		if ( $table == CMS_TEMPLATE_UNIT_IDENTIFIER || empty($table) || !osa_is_int($table_id) || !$roles ) {
			$this->cms_cache->db_add(__METHOD__, $cachekey, FALSE);
			return FALSE;
		}
		$this->db->select("t.$userid_column");
		$this->db->from("$table t");
		$this->db->join('user_role r', 't.creatorid=r.userid');
		$this->db->where('t.id', $table_id);
		$roles_array = explode(',', $roles);
		$this->db->where_in('r.type', $roles_array);
		$resobj = $this->db->get();
		if ( $resobj->num_rows() <= 0 ) {
	      $ret = FALSE;
		}
	   else {
	   	$ret = TRUE;
	   }
	   $this->cms_cache->db_add(__METHOD__, $cachekey, $ret);
	   return $ret;
	}
}