<?php
/**
 * linkunit_model.php - Model link unit.
 *
 * @author $Author: samarth
 * @version $Id: linkunit_model.php
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/
class Linkunit_model extends CI_Model {
	function __construct() {
		parent::__construct();
        $this->load->model('unit/unit_model');
   }
	function get_linkunit($extid,$type) {
		if ( !is_numeric($extid) || !is_numeric($type))
			return FALSE;
		$table_unit = $this->db->dbprefix('unit');
		$table_course_sis = $this->db->dbprefix('course_sis');
		$table_linkunit = $this->db->dbprefix('linkunit');
		$this->db->select('u.id, u.groupid, u.title, u.groupid,u.hidden u_hidden, c.name coursename,c.id courseid,c.hidden c_hidden');
	   $this->db->from($table_linkunit . ' link');
	   $this->db->join($table_unit . ' u', 'link.unitid = u.groupid and u.status = '.CMS_UNIT_STATUS_PUBLISH );
	   $this->db->join($table_course_sis . ' c', 'c.id = u.courseid and c.enabled = true', 'left');
	   $this->db->where('link.extid', $extid);
	   $this->db->where('link.type', $type);
	   $this->db->group_by('id');
	   $this->db->order_by('u.title');

		$linkunit = $this->db->get();
		$unit_edit = $this->unit_model->get_publish_unit_byedit(FALSE, $extid);
		$unit_del = $this->unit_model->get_publish_unit_bydelete(FALSE, $extid);
		$res = array();
		if ( $linkunit != FALSE && is_array($linkunit->result()) ) {
			 foreach ($linkunit->result() as $value)
			 	$res[] = $value;
		}
		if ($unit_edit != FALSE && is_array($unit_edit)) {
			foreach ($unit_edit as $value)
			 	$res[] = $value;
		}

		if ($unit_del != FALSE && is_array($unit_del) ) {
			foreach ($unit_del as $value)
			 	$res[] = $value;
		}
		return $res;
	}
	function get_linkunit_all($extid,$type) {
		if ( !is_numeric($extid) || !is_numeric($type))
			return FALSE;
		$table_unit = $this->db->dbprefix('unit');
		$table_course_sis = $this->db->dbprefix('course_sis');
		$table_linkunit = $this->db->dbprefix('linkunit');
		$this->db->select('u.id, u.groupid, u.title, u.groupid,u.hidden, c.name coursename');
	   $this->db->from($table_linkunit .' link');
	   $this->db->join($table_unit . ' u', 'link.unitid=u.groupid and u.status ='.CMS_UNIT_STATUS_PUBLISH );
	   $this->db->join($table_course_sis . ' c', 'c.id=u.courseid ', 'left');
	   $this->db->where('link.extid',$extid);
	   $this->db->where('u.hidden',FALSE);
	  	$this->db->where('g.type',$type);
	   $this->db->group_by('id');
	   $this->db->order_by('u.title');

		$linkunit = $this->db->get();
		$unit_edit = $this->unit_model->get_publish_unit_byedit(FALSE, $extid);
		$unit_del = $this->unit_model->get_publish_unit_bydelete(FALSE, $extid);
		$res = array();
		if ($linkunit != FALSE && is_array($linkunit->result())) {
			 foreach ($linkunit->result() as $value)
			 	$res[] = $value;
		}
		if ($unit_edit != FALSE && is_array($unit_edit)) {
			foreach ($unit_edit as $value)
			 	$res[] = $value;
		}

		if ($unit_del != FALSE && is_array($unit_del) ) {
			foreach ($unit_del as $value)
			 	$res[] = $value;
		}

		return $res;
	}

   //function get_course($notin_ids, $depid=FALSE, $gradeid=FALSE, $usenull=FALSE, $enabled=TRUE, $hidden=FALSE) {
	function get_course($notin_ids, $depid=FALSE, $gradeid=FALSE) {
		$course_sis = $this->db->dbprefix('course_sis');
		$display_grade = $this->db->dbprefix('display_grade');
		$unit = $this->db->dbprefix('unit');

		$dbtrue = CMS_DB_BOOLEAN_TRUE;
		$dbfalse = CMS_DB_BOOLEAN_FALSE;
		$pub_status = CMS_UNIT_STATUS_PUBLISH;

		$select = "select c.id courseid, c.name, c.departmentid,c.hidden c_hidden, d.gradeid, u.groupid id, u.title ,u.hidden u_hidden";
		$from = " from {$course_sis} c ";
		$join = " left join $display_grade d on d.courseid=c.id " .
				  " left join $unit u on u.courseid=c.id ";
		$where = " where c.enabled=$dbtrue and u.status=$pub_status and u.hidden=$dbfalse ";
		/*
		if ($enabled == FALSE)
			$where = ' where c.id <> "" ';
      */
		if ($depid != FALSE && is_numeric($depid))
			 $where .= " and c.departmentid= {$depid} ";

		if ($gradeid != FALSE && is_numeric($gradeid))
			 $where .= " and d.gradeid= {$gradeid} ";

		if ($notin_ids != FALSE && is_array($notin_ids))
			 $where .= " and u.groupid not in ('".implode("','",$notin_ids)."') ";
/*
		if ($usenull)
			 $where .= " and not isnull(u.title) "; */
		//if ($hidden == FALSE)
			//$where .= " and u.hidden = FALSE ";

		$order_by = " order by c.name, u.title ";

	   $res = $this->db->query($select . $from . $join . $where . $order_by);

		if ( $res->num_rows() <= 0 )
			return FALSE;

		return $res->result();
	}

	function get_all_department() {
		$this->db->select('id,name');
	   $this->db->from('department');
	   $this->db->where('enabled',CMS_ADMIN_ENABLE);
	   $this->db->order_by('name');
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 )
			return FALSE;
		return $res->result();
	}
	function get_all_grade() {
		$this->db->select('id,name');
	   $this->db->from('grade');
	   $this->db->order_by('sort');
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 )
			return FALSE;
		return $res->result();
	}
	function get_data($table,$extid) {
		$table = $this->db->dbprefix($table);
		$this->db->select('title');
	   $this->db->from($table);
	   $this->db->where('id',$extid);
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 )
			return FALSE;
		$result = $res->result();
		return $result[0];
	}
	function get_linkunit_res_sort($extid,$type) {
		$table_linkunit = $this->db->dbprefix('linkunit');
		$table_res_sort = $this->db->dbprefix('res_sort');
		$this->db->select('link.id');
		$this->db->from($table_linkunit . ' link');
		$this->db->join($table_res_sort . ' r', 'r.fk1=link.extid and r.type=link.type and r.fk3=link.id ','left');
		$this->db->where('link.extid',$extid);
		$this->db->where('link.type',$type);
		$this->db->where('r.id',null);
		$resobj = $this->db->get();
	   if ( $resobj->num_rows() <= 0 )
			return FALSE;
		$rows = $resobj->result();
		return $rows;
	}
	function insert_linkunit($value) {
		$table_linkunit = $this->db->dbprefix('linkunit');
		$sql = "INSERT INTO $table_linkunit (extid,unitid,type) VALUES ";
		$this->db->query($sql . $value );
		return TRUE;
	}
	function delete_linkunit($extid, $unitid=FALSE, $type=FALSE) {
		$table_linkunit = $this->db->dbprefix('linkunit');
		if ( !is_numeric($extid))
			return FALSE;
	   $this->db->where('extid',$extid);
	   if ( $unitid !== FALSE )
	   	$this->db->where('unitid',$unitid);
	   if ( $type !== FALSE )
	   	$this->db->where('type',$type);
		$this->db->delete($table_linkunit);
		return TRUE;
	}
}