<?php
/**
 * survey_result_model.php - Page survey_result model
 *
 * @author $Author: dtong $
 * @version $Id: survey_result_model.php,v 1.6 2011/02/11 09:09:26 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

class survey_result_model extends CI_Model {

 	function __construct() {
		parent::__construct();
   }

   //Get an existing result for 1 user
 	function get_survey_result($survey_login, $templateid) {
 		if ( !is_object($survey_login) || !is_numeric($templateid) ||
 			  ( empty($survey_login->userid) && empty($survey_login->ext_username) ) ) {
 			  	return FALSE;
 		}
		$this->db->select('*');
	   $this->db->from('survey_result');
		$this->db->where('templateid', $templateid);
		$this->db->where('userid', $survey_login->userid);
   	$this->db->where('ext_username', $survey_login->ext_username);
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 )
			return FALSE;
		$result = $res->result();
		return $result[0];
	}

	//Adds a new result. This happens when user takes a survey the first time.
 	function add_survey_result($survey_login, $templateid) {
 		if ( !is_object($survey_login) || !is_numeric($templateid) ) {
 			return FALSE;
 		}
 		$resultid = FALSE;
 		$data->createdate = osa_dbdate();
		$data->modifydate = $data->createdate;
		$data->templateid = $templateid;
		$data->userid = $survey_login->userid;
		$data->completed = CMS_DB_BOOLEAN_FALSE;
		$data->ext_username = $survey_login->ext_username;
		$data->ext_firstname = $survey_login->ext_firstname;
		$data->ext_lastname = $survey_login->ext_lastname;
		$data->ext_email = $survey_login->ext_email;
		//IP is not used yet

		$this->db->trans_begin();
		$this->db->insert('survey_result', $data);
		$resultid = osa_db_lastinsertid($this->db);
		if ( !$resultid ) {
			$this->db->trans_rollback();
			return FALSE;
		}
		$this->db->trans_commit();

		return $resultid;
	}

	//Updates an existing result
	function update_survey_result($data) {
		if (isset($data) && $data !== FALSE) {
			if (isset($data->templateid) && $data->templateid !== FALSE)
				$this->db->where('templateid', $data->templateid);
			if (!isset($data->userid))
				$data->userid = NULL;
			if (!isset($data->ext_username))
				$data->ext_username = NULL;
			$this->db->where('userid', $data->userid);
	   	$this->db->where('ext_username', $data->ext_username);
			$data = FALSE;
			$data->modifydate = osa_dbdate();
			if (isset($_SERVER['SERVER_ADDR']))
				$data->ip = $_SERVER['SERVER_ADDR'];
			$this->db->update('survey_result', $data);
		}
		return true;
	}

	//Check if a survey is completed
	function get_survey_completed($extid) {
		$this->db->select('completed');
	   $this->db->from('survey_result');
	  	if (isset($extid) && $extid !== FALSE)
			$this->db->where('id',$extid);
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 )
			return FALSE;
		$result = $res->result();
		return $result[0];
	}

	//Update the completed flag in result
	function update_complete($resultid) {
		$this->db->where('id', $resultid);
		return $this->db->update('survey_result', array('completed'=>CMS_DB_BOOLEAN_TRUE));
	}

	//Gets all the results belonging to one or more surveys
	function get_results_by_surveyid($surveyids, $survey_type, $data_type) {
		$this->db->select('r.*,h.question_index,h.weight,h.radio_select,t.type template_type');
		$this->db->from('survey s');
		$this->db->join('survey_template t', 's.id=t.surveyid');
		$this->db->join('survey_result r', 't.id=r.templateid');
		$this->db->join('template_htmldata h', 'r.id=h.extid');
		$this->db->where_in("s.id", $surveyids);
		$this->db->where("h.type", $data_type);
		if ( $survey_type != CMS_SURVEY_TEMPLATE_TYPE_ALL ) {
			$this->db->where("t.type", $survey_type);
		}
		$this->db->order_by('r.id,h.question_index');
		$res = $this->db->get();
		if ( $res->num_rows()<= 0 ) {
			return FALSE;
		}
		return $res->result();
	}
}