<?php
/**
 * unittype_model.php - Model file for recently modified unit search
 *
 * @author $Author: dtong $
 * @version $Id: unittype_model.php,v 1.5 2011/02/11 09:09:24 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Unittype_model extends CI_Model {

	function __construct() {
		parent::__construct();
		$this->load->Model('unit/unit_model');
	}

	function get($coursequery, $type) {
		$unit_table = $this->db->dbprefix('unit');
		$targettext_table = $this->db->dbprefix('target_text');

		$unitcache_table = osa_unit_cachetable();
		if ( $unitcache_table == FALSE )
			return FALSE;
		$unitcache_table = $this->db->dbprefix($unitcache_table);

		if ($type != FALSE )
			$where = " u.type in ($type)";

		$sql = "select c.name coursename,u.id unitid,u.title unit_title," .
				 "u.type,u.description" .
				 " from $unitcache_table uc " .
				 " join $unit_table u on uc.id = u.id " .
				 " join ($coursequery) c on uc.courseid=c.id " .
				 " where u.status=".CMS_UNIT_STATUS_PUBLISH."  and $where ".
				 " order by c.name,c.id,u.id";

		$res = $this->db->query($sql);
		if ( $res->num_rows() <= 0 )
			return FALSE;
		return $res->result();
	}
}
?>