<?php
/**
 * orphanlt_model.php - Model file for orphan learning targets search
 *
 * @author $Author: dtong $
 * @version $Id: orphanlt_model.php,v 1.9 2011/02/11 09:09:24 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Orphanlt_model extends CI_Model {

	function __construct() {
		parent::__construct();
	}

	function get($course_query) {
		$unittarget_table = $this->db->dbprefix('unit_target');
		$targettext_table = $this->db->dbprefix('target_text');
		$benchmark_table = $this->db->dbprefix('benchmark');
		$standard_table = $this->db->dbprefix('standard');
		$strand_table = $this->db->dbprefix('strand');
		$unitcache_table = osa_unit_cachetable();
		if ( $unitcache_table == FALSE )
			return FALSE;
		$unitcache_table = $this->db->dbprefix($unitcache_table);

		if ($this->config->item('cms_outcomes_skills_mapping_type') == TRUE)
			$type = CMS_OUTCOMES_SKILLS_TYPE;
		else
			$type = CMS_LEARNING_TARGETS_TYPE;

		$sql = "select t.id,c.name coursename,t.data target,b.data benchmark,sd.data standard " .
				  "from $unitcache_table uc " .
				  "join $unittarget_table ut on uc.id=ut.unitid " .
				  "right join $targettext_table t on t.id=ut.targetid and t.type=$type " .
				  "left join $benchmark_table b on b.id=t.benchmarkid  " .
				  "left join $standard_table sd on b.standardid=sd.id " .
				  "left join $strand_table s on sd.strandid=s.id " .
				  "join ($course_query) c on t.courseid=c.id " .
				  "where uc.id is null " .
				  "and s.enabled=" . CMS_DB_BOOLEAN_TRUE . " " .
				  "and sd.enabled=" . CMS_DB_BOOLEAN_TRUE . " " .
				  "and b.enabled=" . CMS_DB_BOOLEAN_TRUE . " " .
				  "order by c.name";

		$res = $this->db->query($sql);
		if ( $res->num_rows() <= 0 )
			return FALSE;
		return $res->result();
	}
}
?>