<?php
/**
 * common_db_model.php - Generic common/shared DB functions. Do not put non-generic DB code here.
 *
 * @author $Author: dtong $
 * @version $Id: common_db_model.php,v 1.4 2011/05/09 04:48:52 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

class Common_db_model extends CI_Model {

	function __construct() {
		parent::__construct();
	}

	function select($table) {
		$query = $this->db->get($table);
		if ( $query->num_rows() <= 0 ) {
			return FALSE;
		}
		return $query->result();
	}

	function update($table,$id,$data) {
		$this->db->where('id', $id);
		return $this->db->update($table,$data);
	}

	function query($sql) {
		if ( empty($sql) ) {
			return FALSE;
		}
		$query = $this->db->query($sql);
		if ( $query->num_rows() <= 0 ) {
			return FALSE;
		}
		return $query->result();
	}
}