<?php
/**
 * cms_model.php - The CMS model file for accessing the CMS database
 *
 * @author $Author: dtong $
 * @version $Id: cms_model.php,v 1.7 2011/02/11 09:09:27 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Cms_model extends CI_Model {

	function __construct() {
		parent::__construct();
	}
	//skip default user
	function get_users() {
		$this->db->select('*');
		$this->db->from('user');
		$this->db->where('id > ', 999);
 		$resobj = $this->db->get();
 		if ( $resobj->num_rows() <= 0 )
			return FALSE;
	   return $resobj->result_array();
	}

	function enable_user($userid, $flag=1) {
		$data->enabled=$flag;
		$this->db->where('id', $userid);
		return $this->db->update('user', $data);
	}

	function disable_user($userid) {
		$ret = $this->enable_user($userid,0);
		if ( $ret ) {
			$this->db->where('userid', $userid);
			$this->db->delete('user_course');
		}
		return $ret;
	}

	function add_user($data) {
		return $this->db->insert('user', $data);
	}

	function get_course_grade() {
		$this->db->select('cg.gradeid,c.id as courseid,c.sis_course_dbid');
		$this->db->from('course_grade as cg');
		$this->db->join('course_sis as c', 'c.id=cg.courseid', 'right');
		$this->db->where('c.sis_course_dbid is not null');
		$this->db->where('c.enabled', 1);
 		$resobj = $this->db->get();
 		if ( $resobj->num_rows() <= 0 )
			return FALSE;
	   return $resobj->result_array();
	}

	function add_course_grade($courseid, $gradeid) {
		return $this->db->insert('course_grade', array('courseid'=>$courseid,'gradeid'=>$gradeid));
	}

	function delete_course_grade($courseid, $gradeid) {
		$this->db->where('courseid', $courseid);
		$this->db->where('gradeid', $gradeid);
		return $this->db->delete('course_grade');
	}

	function get_user_course() {
		//Just get all the courses including inactive ones
		$this->db->select('c.id courseid,c.enabled course_enabled,c.sis_course_dbid,uc.userid,uc.is_from_sis,u.username,u.enabled user_enabled');
		$this->db->from('course_sis c');
		$this->db->join('user_course uc', 'uc.courseid=c.id', 'left');
		$this->db->join('user u', 'u.id=uc.userid');
		$this->db->where('c.enabled', 1);
		$resobj = $this->db->get();
 		if ( $resobj->num_rows() <= 0 )
			return FALSE;
	   return $resobj->result_array();
	}

	function get_courses($enabled=true) {
		$this->db->from('course_sis');
		$this->db->where('enabled', true);
		$resobj = $this->db->get();
 		if ( $resobj->num_rows() <= 0 )
			return FALSE;
	   return $resobj->result_array();
	}
	//add iseditor for in the future whant to update editor
	function add_user_course($userid, $courseid, $iseditor=false) {
		return $this->db->insert('user_course', array('userid'=>$userid,'courseid'=>$courseid, 'is_from_sis'=>1, 'iseditor'=>$iseditor));
	}

	function delete_user_course($userid, $courseid) {
		$this->db->where('courseid', $courseid);
		$this->db->where('userid', $userid);
		return $this->db->delete('user_course');
	}

	// add new cousrse
	function add_course($data) {
		if ($data === false)
			return $data;

		$name = NULL;
		$departmentid = NULL;
		$sys_course_dbid = NULL;
		$sys_course_number = NULL;
		$maxgradeid = 1;
		$mingradeid = 1;

		if (array_key_exists('name', $data))
			$name = $data['name'];
		if (array_key_exists('departmentid', $data))
			$departmentid = $data['departmentid'];
		if (array_key_exists('sis_course_dbid', $data))
			$sys_course_dbid = $data['sis_course_dbid'];
		if (array_key_exists('sis_course_number', $data))
			$sys_course_number = $data['sis_course_number'];
		if (array_key_exists('maxgradeid', $data))
			$maxgradeid = $data['maxgradeid'];
		if (array_key_exists('mingradeid', $data))
			$mingradeid = $data['mingradeid'];
		//if (array_key_exists('modifydate', $data))
		//	$modifydate = $data['modifydate'];

		if ($departmentid === FALSE)
			return;

		return $this->db->insert('course_sis', array('name'=>$name,'departmentid'=>$departmentid,
																	'sis_course_dbid'=>$sys_course_dbid,'sis_course_number'=>$sys_course_number,
																	'createdate'=>osa_dbdate(), 'maxgradeid'=>$maxgradeid , 'mingradeid'=>$mingradeid,
															)
										);
	}

	function get_departments($name=FALSE, $shortname=FALSE) {
		//if ($name === FALSE && $shortname === FALSE)
		//	return FALSE;

		$this->db->from('department');
		$this->db->where('enabled', 1);
		if ($name !== FALSE)
			$this->db->where('name', $name);
		if ($shortname !== FALSE)
			$this->db->where('shortname', $shortname);

		$resobj = $this->db->get();
 		if ( $resobj->num_rows() <= 0 )
			return FALSE;
	   return $resobj->result_array();
	}

	function get_departments_shortname($name=FALSE, $shortname=FALSE) {
		//if ($name === FALSE && $shortname === FALSE)
		//	return FALSE;
		$this->db->select('id, name');
		$this->db->from('department');
		$this->db->where('enabled', 1);
		if ($name !== FALSE)
			$this->db->where('name', $name);
		if ($shortname !== FALSE)
			$this->db->where('shortname', $shortname);

		$resobj = $this->db->get();
 		if ( $resobj->num_rows() <= 0 )
			return FALSE;
	   return $resobj->result_array();
	}

	function add_department($data) {
		if ($data === false)
			return $data;
		$id = NULL;
		$name = NULL;
		$shortname = NULL;
		if (array_key_exists('id', $data))
			$id = $data['id'];
		if (array_key_exists('name', $data))
			$name = $data['name'];
		if (array_key_exists('shortname', $data))
			$shortname = $data['shortname'];

		return $this->db->insert('department', array('name'=>$name,'id'=>$id,'shortname'=>$shortname));
	}
	// update department
	function update_department($data, $id=FALSE, $flag=FALSE) {
		//$data->enabled = $flag;
		if (is_object($data))
			$data->enabled = $flag;
		else
			$data['enabled'] = $flag;

		$this->db->where('id', $id);
		return $this->db->update('department', $data);
	}
	// update cousrse
	function update_course($data, $id=FALSE, $flag=FALSE) {
		if (is_object($data)) {
			$data->modifydate = osa_dbdate();
			$data->enabled = $flag;
		}
		else {
			$data['modifydate'] = osa_dbdate();
			$data['enabled'] = $flag;
		}
		$this->db->where('id', $id);
		return $this->db->update('course_sis', $data);
	}
	// update user
	function update_user($data, $userid=FALSE, $flag=FALSE) {
		if (is_object($data)) {
			$data->enabled = $flag;
		}
		else {
			$data['enabled'] = $flag;
		}
		//$this->db->where('sis_course_number', $course_number);
		$this->db->where('id', $userid);
		return $this->db->update('user', $data);
	}

}
?>