<?php
/**
 * access_model.php - Model file for user access levels
 *
 * @author $Author: dtong $
 * @version $Id: access_model.php,v 1.27 2011/02/11 14:09:30 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once('access_factory.php');

class Access_model extends CI_Model {
	function __construct() {
		parent::__construct();
        //$this->load->model('auth/login_model');
        osa_load_lang('general');
        $this->load->model('course/course_model');
    }

   function getObj($accessname) {
      return OSA_AccessFactory::factory($accessname, $this->config->item('cms_guest_username'));
   }
/*
   function hasPermission($permission) {
		if (!$this->login_model->isAuthenticated()) {
			//if not logged in assign as guest
			//$authtype = 'guest';
			$user = $this->login_model->setGuestSession();
		}
		else {
			$user = $this->login_model->getLogin();
		}
		$authtype = $user->auth_type;
		$access = getObj($authtype);
		$accessvar = "{$access}->{$permission}";
		$accessvalue = eval($accessvar);
		$ret = ( isset($accessvalue) && $accessvalue );
		return $ret;
   }
*/
   private function doexit($isAjax, $isExit, $msg=FALSE, $redirectHome=FALSE) {
   	if ( !$isExit )
   		return;
	   if ( $isAjax ) {
	   	if ( !$msg )
	   		$msg = lang('gen_no_permission_ajaxmsg');
	   	if ( $redirectHome )
	      	echo osa_ajaxmsg_redirecthome($msg);
	      else
	      	echo osa_ajaxmsg($msg);
	   }
	   else {
	   	//logic is that if you are not using ajax then you are coming from the homepage or direct url access
	   	$this->session->set_flashdata('LOGINPAGE_NO_REDIRECT_HOME', '1');
		   redirect();
	   }
	   exit;
   }

	private function checkaccess($rights=array(), $login=FALSE, $checkAll=TRUE, $isAjax=TRUE, $isExit=TRUE) {
   	//$this->load->model('auth/login_model');
      //$this->load->model('auth/access_model');
      if ( !$this->login_model->isAuthenticated() ) {
      	//Assing guest user if not authenticated already
			//if ( !$this->login_model->setGuestSession() )
			$this->doexit($isAjax, $isExit, lang('gen_js_ajaxsessiontimeoutmsg'), TRUE);
				return FALSE;
      }
	   if (is_string($rights))
      {
      	if ( trim($rights) == '' ) {
      		$this->doexit($isAjax, $isExit);
      	  	return FALSE;
      	}
         $rights = array($rights);
      }
      if ( count($rights) <= 0 ) {
      	$this->doexit($isAjax, $isExit);
         return FALSE;
      }
      if ( !$login ) {
	      if ( ($login = $this->login_model->getLogin()) == FALSE ) {
	      	$this->doexit($isAjax, $isExit);
	         return FALSE;
	      }
      }
      if ( ($accessObj = $this->getObj($login->access_name)) == FALSE ) {
      	$this->doexit($isAjax, $isExit);
         return FALSE;
      }
      foreach ($rights as $access) {
      	$value = FALSE;
         //eval('if (isset($accessObj->' . $access . ')) $value = $accessObj->' . $access . ';');
         eval('$value = isset($accessObj->' . $access . ') ? $accessObj->' . $access . ' : FALSE;');
         if ( !$value && $checkAll) {
         	$this->doexit($isAjax, $isExit);
            return FALSE;
         }
         if ( $value && !$checkAll)
            return TRUE;
      }
      if ( !$checkAll ) {
      	$this->doexit($isAjax, $isExit);
         return FALSE;
      }
      return TRUE;
   }

   //Should use this one. It does not do an exist when failed so doesn't care Ajax or not.
   //Always return true or false. $rights can be a struing or array
   function checkaccess_any_noexit($rights) {
		return $this->checkaccess($rights, FALSE, FALSE, FALSE, FALSE);
   }

   //isAjax to print an ajax msg
   //isExit to exit in this method if access check fails
   //any one right from multiple rights would return true
   //$rights can also be a string
   function checkaccess_any($rights=array(), $user=FALSE, $isAjax=TRUE, $isExit=TRUE) {
   	return $this->checkaccess($rights, $user, FALSE, $isAjax, $isExit);
   }

   function checkaccess_all($rights=array(), $user=FALSE, $isAjax=TRUE, $isExit=TRUE) {
      return $this->checkaccess($rights, $user, TRUE, $isAjax, $isExit);
   }

   //Course specific check. Has to be course editor plus access rights
   function checkaccess_courseeditor($rights=array(), $courseid, $user=FALSE, $isAjax=FALSE, $isExit=FALSE) {
   	if ( !$user )
   	if ( ($user = $this->login_model->getLogin()) == FALSE )
   		return FALSE;
   	if ( !is_object($user) || !is_numeric($courseid) )
   		return FALSE;
		$id = $user->id;
		if (!is_numeric($id))
			return FALSE;
		$this->load->model('course/course_model');
		$iseditor = $this->course_model->isCourseEditor($id, $courseid);
		if ( !$iseditor )
			return FALSE;
		return $this->checkaccess_any($rights, $user, $isAjax, $isExit);
   }

   //Check for ICT user role
   function is_ict_editor($role_type=CMS_ICT_USER_TYPE, $schoolid=FALSE) {

		return ( $this->check_user_role($role_type, $schoolid) ||
					$this->checkaccess_any_noexit('admin_ict_write') );
   }

   /*
    * This checks the user_role table for user roles. Note, you may ignore departmentid and schoolid
    * if just to check is the user of role_type. But, you do need to supply the departmentid and schoolid
    * if they are avaible when accessing the data.
    *
    * @param int $role_type
    * 	This is user_role.type.
    *
    * @param int|bool $departmentid
    * 	This is user_role.departmentid. Can be False so not use in the query
    *
    * @param int|bool $schoolid
    * 	This is user_role.schoolid. Can be False so not use in the query
    *
    * @return bool
    *		Returns True if current login user is of $role_type in user_role table.
    */
   function check_user_role($role_type, $schoolid=FALSE, $departmentid=FALSE) {
		if ( ($user = $this->login_model->getLogin()) == FALSE )
			return FALSE;
		if ( !is_numeric($role_type) )
			return FALSE;
		if ( ($schoolid && !is_numeric($schoolid)) ||
			  ($departmentid && !is_numeric($departmentid))	)
			return FALSE;

	   $this->db->where('userid', $user->id);
	   $this->db->where('type', $role_type);

	   if ( is_numeric($schoolid) ) {
	   	$this->db->where('schoolid', $schoolid);
	   }
	   if ( is_numeric($departmentid) ){
	   	$this->db->where('departmentid', $departmentid);
	   }

	   $res = $this->db->get('user_role');
	   return ($res->num_rows() > 0);
   }

   function is_user_management() {
	   if ( ($user = $this->login_model->getLogin()) == FALSE )
	   	return FALSE;
	   if ( ($access = $this->getObj($user->access_name)) == FALSE )
	   	return FALSE;
	   return $access->admin_system_management;
   }
}
?>