<?php
/**
 * standard_model - Model for add/update/delete standard
 *
 * @author $Author: dtong $
 * @version $Id: standard_model.php,v 1.18 2011/03/23 11:52:01 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class standard_model extends CI_Model {
	function __construct() {
		parent::__construct();
    }

	function get_allstandard($enabled, $type, $filter=FALSE,$departmentid=FALSE,$schoolid=FALSE,$strandid=FALSE,$_table=FALSE) { // 1:enabled
		if (!osa_is_int($type)){
			return FALSE;
		}
		$school_table = $this->db->dbprefix('school');
		if ($_table != FALSE)
			$school_table = $_table;
		 $sql  = 'select str.departmentid,str.schoolid, s.strandid, s.id,str.data strand,s.type,s.importid,s.data,s.enabled,' .
		 			'sc.name school,d.name department,s.importid standard_importid,str.importid strand_importid,' .
		 			'str.enabled strand_enabled,d.enabled department_enabled';
	    $sql .=" from standard s";
	    $sql .=" left join strand str on s.strandid=str.id";
	    $sql .=" left join $school_table sc on str.schoolid=sc.id";
	    //$sql .=" left join department d on str.departmentid=d.id and d.enabled=".CMS_ADMIN_ENABLE;
		 $sql .=" left join department d on str.departmentid=d.id";

	   $where = " where s.type={$type}";
		if ($strandid!=FALSE){
	    	$where .= " and s.strandid =" . $strandid;
	    }
		if ($departmentid!=FALSE){
	    	$where .= " and str.departmentid =" . $departmentid;
	    }
		if ($schoolid!=FALSE){
	    	$where .= " and str.schoolid =" . $schoolid;
	    }
	    //if ($enabled!=CMS_ADMIN_ALL){
	    	//$where .= " and s.enabled =" . $enabled;
	    //}
		if ($enabled!=CMS_ADMIN_ALL){
			if ( empty($enabled) ) {
				//Show even if department is disabled
	    		$where .= ' and (str.enabled=' . CMS_DB_BOOLEAN_FALSE . ' or d.enabled=' . CMS_DB_BOOLEAN_FALSE .
	    					 ' or s.enabled=' . CMS_DB_BOOLEAN_FALSE . ')';
			}
			else {
				//IT Std, GC, TaIL etc is not related to department so ignore department.enabled flag when department is null
				$where .= ' and str.enabled=' . CMS_DB_BOOLEAN_TRUE . ' and (d.enabled=' . CMS_DB_BOOLEAN_TRUE .
							 ' or str.departmentid=0 or str.departmentid is null) and s.enabled=' . CMS_DB_BOOLEAN_TRUE;
			}
	    }
	    if ($filter!=FALSE)
	    //$where .= " and (s.data like '%$filter%' or str.data like '%$filter%' or s.enabled like '%$filter%')";
	    $where .= " and (s.data like '%$filter%')";


	    $order_by = " Order by str.data ,s.data";

	    $res = $this->db->query($sql.$where.$order_by);
		 if ( $res->num_rows() <= 0 )
			return FALSE;
		 return $res->result();
		 //$ret = $res->result();
		 //osa_array_natsort($ret, array('standard_importid'));
		 //return $ret;
	}

	function get_standard($standardid, $standard_enabled=1, $standardname=FALSE,$_table=FALSE) {
		if ( !is_numeric($standardid) )
			return FALSE;
		$school_table = $this->db->dbprefix('school');
		if ($_table != FALSE)
			$school_table = $_table;
		$this->db->select('d.name department,sch.name school ,s.id, s.strandid, s.type, s.importid, s.data,s.enabled'); //enabled
		//$this->db->select('id, strandid, type, importid, data');
	    $this->db->from('standard s');
	    $this->db->join('strand str', 's.strandid=str.id'  ,'left');
	    $this->db->join('department d', 'str.departmentid=d.id' , 'left');
	     $this->db->join($school_table.' sch', 'str.schoolid=sch.id' , 'left');

	    $this->db->where('s.id',$standardid);
	  // $this->db->where('enabled',$standard_enabled);
	    //$this->db->order_by('displayname ');

		$res = $this->db->get();
		if ( $res->num_rows() != 1 )
			return FALSE;
		return $res->result();
	}

	function get_department($dep_schid=FALSE) {
		$this->db->select('id,name');
	    $this->db->from('department');
	    if ($dep_schid!=FALSE) {
	      $this->db->where ('id',$dep_schid);
	    }
	    else {
	    	//Should not include this when a department id ($dep_schid) is supplied.
	   	$this->db->where('enabled',CMS_DB_BOOLEAN_TRUE);
	    }
	    $this->db->order_by('name');
	    $res = $this->db->get();
			if ( $res->num_rows() <= 0 )
			return FALSE;
		$au = $res->result();
		$result = array();
		$result[0] = lang('admin_department_ddldefualt');
		foreach($au as $value) {
			$result[$value->id] = $value->name;
		}
		return $result;
	}

	function get_school($type=FALSE,$dep_schid=FALSE,$_table=FALSE) {
		$school_table = $this->db->dbprefix('school');
		if ($_table != FALSE)
			$school_table = $_table;
		$this->db->select('id,name ');
	   $this->db->from($school_table);
	   if ($_table != FALSE)
	   		$this->db->where ('type',$type);
	   if ($dep_schid!=FALSE)
	   	$this->db->where ('id',$dep_schid);
	    $this->db->order_by('name');
	    $res = $this->db->get();
			if ( $res->num_rows() <= 0 )
			return FALSE;
		$au = $res->result();
		$result = array();
		$result[0] = lang('admin_school_ddldefualt');
		foreach($au as $value) {
			$result[$value->id] = $value->name;
		}
		return $result;
	}

	//Gets the strands for the drop down
	function get_strand($type,$departmentid=FALSE,$schoolid=FALSE) {
		$this->db->select('s.id,s.data,s.importid');
	   $this->db->from('strand s');
	   $this->db->join('department d', 's.departmentid=d.id', 'left');
	   $this->db->where('s.type',$type);
	   $this->db->where('s.enabled',CMS_DB_BOOLEAN_TRUE);
	   $this->db->where('(d.enabled=' . CMS_DB_BOOLEAN_TRUE . ' or d.id is null)');
      if ( $departmentid!=FALSE )
      	$this->db->where('s.departmentid',$departmentid);
      if ($schoolid!=FALSE) {
        $this->db->where ('s.schoolid',$schoolid);
      }
	   $this->db->order_by('s.data');
	   $res = $this->db->get();
		if ( $res->num_rows() <= 0 )
			return FALSE;
		$au = $res->result();
		$result = array();
		if ( $this->config->item('cms_lt_importid_support') ) {
			//Modify the query result to display the importid
			foreach ($au as $record) {
				if ( !empty($record->importid) )
					$record->data = "$record->importid $record->data";
			}
			//Use natural sort on the strand name prefixed with the importid
			osa_array_natsort($au, array('data'));
		}
		$result[0] = lang('admin_strand_ddldefualt');
		foreach($au as $value) {
			$result[$value->id] = $value->data;
		}
		return $result;
	}

	function add_standard($data) {

		$this->db->insert('standard', $data);
		return TRUE;
	}

    function update_standard($standardid,$data) {
		$this->db->where('id',$standardid);
		$this->db->update('standard', $data);
		return TRUE;
	}

	function del_standard($standardid,$standard_enabled) {
		$this->db->where('id',$standardid);
		$this->db->update('standard', array('enabled'=>$standard_enabled));
		return TRUE;
	}




}
?>