<?php
/**
 * school_model.php - Model for add/update/delete school and school_type.
 *
 * @author $Author: suppakit $
 * @version $Id: school_model.php,v 1.8 2011/03/14 11:38:32 suppakit Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/

class School_model extends CI_Model {
	const TABLE_SCHOOL_NUMBER = 1;
	const TABLE_SCHOOL_TYPE_NUMBER = 2;
	//Tables with schoolid column
	private $tables_schoolid = array('grade', 'grade_type', 'strand');

	function __construct() {
		parent::__construct();
	}

	function get_all_school($table_number) {
		$this->db->dbprefix('school');
		if ( $table_number == self::TABLE_SCHOOL_TYPE_NUMBER ) {
			$this->db->select('id, type, shortname, name');
			$this->db->from('school_type');
		}
		else {
			$this->db->select('id, shortname, name');
			$this->db->from('school');
		}

		$this->db->order_by('id asc');
		$query = $this->db->get();
		if ( $query->num_rows() <= 0 )
			return FALSE;
		return $query->result();
	}

	function get_school($id, $table_number) {
		$table_name = $this->_get_table_name($table_number);
		$this->db->select('*');
		$this->db->where('id', $id);
		$query = $this->db->get($table_name);
		return $query->result();
	}

	function insert_school($data, $table_number){
		$table_name = $this->_get_table_name($table_number);
		return $this->db->insert($table_name, $data);
	}

	function update_school($id, $data, $table_number){
		$table_name = $this->_get_table_name($table_number);
		$this->db->where('id', $id);
		return $this->db->update($table_name, $data);
	}

	function delete_school($id, $table_number){
		$table_name = $this->_get_table_name($table_number);
		$this->db->where('id', $id);
		return $this->db->delete($table_name);
	}

	function check_school_relation_exists($school_id, $table_number) {
		$all_school = $this->_get_school_count_array($table_number);
		return (array_key_exists($school_id, $all_school));
	}

	private function _get_school_count_array($table_number) {
		static $total = NULL;
		$table_school = $this->_get_table_name($table_number);
		if ( $total === NULL ) {
			$total = array();
			foreach($this->tables_schoolid as $table) {
				$total = $this->_my_merge($total, $this->_school_usage_array($table_school, $table));
			}
		}
		return $total;
	}

	//merge result of school relative
	private function _my_merge($total, $new) {
		if ( !is_array($new) ) {
			return $total;
		}

		foreach($new as $record) {
			if ( array_key_exists($record->id, $total) ) {
				$total[$record->id] += $record->school_count;
			}
			else {
				$total[$record->id] = $record->school_count;
			}
		}
		return $total;
	}

	private function _school_usage_array($table_school, $table) {
		if ( !$table || !$table_school ) {
			return FALSE;
		}
		/*
		 * 1. don't join grade table if select school_type table.
		 * 2. don't join grade_type table if select school table.
		 * 3. don't join strand table if select school table and osa_itstd_use_schooltype == TRUE.
		 */
		if ( $table == 'grade' && $table_school == 'school_type' ) {
			return FALSE;
		}
		if ( $table == 'grade_type' && $table_school == 'school' ) {
			return FALSE;
		}
		if ( $table == 'strand' && ($table_school == 'school' && osa_itstd_use_schooltype()) ) {
			return FALSE;
		}

		$this->db->select('s.id, COUNT(s.id) school_count');
		$this->db->from("$table_school  s");
		$this->db->join("$table t", 's.id = t.schoolid');
		$this->db->group_by('s.id');
		$resobj = $this->db->get();
   	return $resobj->result();
	}

	//switch table school or school_type
	private function _get_table_name($table_number) {
		if ( $table_number == self::TABLE_SCHOOL_NUMBER ) {
			return 'school';
		}
		else if ( $table_number == self::TABLE_SCHOOL_TYPE_NUMBER ) {
			return 'school_type';
		}
		return FALSE;
	}
}

