<?php
/**
 * eq_model - Model for add/update/delete eq
 *
 * @author $Author: dtong $
 * @version $Id: eq_model.php,v 1.3 2011/02/11 09:09:23 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class eq_model extends CI_Model {
	function __construct() {
		parent::__construct();
    }

	function get_alleq($enabled, $type, $filter=FALSE,$departmentid=FALSE) {
		$sql  =" select sc.departmentid,sc.id,d.name department, sc.type, sc.sort,sc.text,sc.enabled";
	    $sql .=" from selection_category sc";
	    $sql .=" left join department d on sc.departmentid=d.id ";
	    //$where = " where s.id <>''";

		if ($type!=FALSE){
	    	$where = " where sc.type =" . $type;
	    	$where .= " and d.enabled =" . CMS_ADMIN_ENABLE;
	    }
		if ($departmentid!=FALSE){
	    	$where .= " and sc.departmentid =" . $departmentid;
	    }
		if ($enabled!=CMS_ADMIN_ALL){
	    	$where .= " and sc.enabled =" . $enabled;
	    }
	 	if ($filter!=FALSE)
	 		$where .= " and (sc.text like '%$filter%')";

	    $order_by = " Order by d.name,sc.text";

	    $res = $this->db->query($sql.$where.$order_by);

		if ( $res->num_rows() <= 0 )
			return FALSE;

		 return $res->result();
	}

	function get_eq($eqid) {
		if ( !is_numeric($eqid) )
			return FALSE;

		$this->db->select('id,departmentid, type,text,sort, enabled'); //enable
	    $this->db->from('selection_category');
	    $this->db->where('id',$eqid);

		$res = $this->db->get();
		if ( $res->num_rows() != 1 )
			return FALSE;
		return $res->result();
	}

	function get_department($dep_schid=FALSE) {
		$this->db->select('id,name ');
	    $this->db->from('department');
	    if ($dep_schid!=FALSE)
	    	$this->db->where ('id',$dep_schid);
	    $this->db->where   ('enabled',CMS_ADMIN_ENABLE);
	    $this->db->order_by('name');
	    $res = $this->db->get();
		if ( $res->num_rows() <= 0 )
			return FALSE;
		$au = $res->result();
		$result = array();
		$result[0] = lang('admin_department_ddldefualt');
		foreach($au as $value) {
			$result[$value->id] = $value->name;
		}
		return $result;
	}

	function add_eq($data) {

		$this->db->insert('selection_category', $data);
		return TRUE;
	}

    function update_eq($eqid,$data) {

		$this->db->where('id',$eqid);
		$this->db->update('selection_category', $data);
		return TRUE;
	}

	function del_eq($eqid,$enabled) {
		$this->db->where('id',$eqid);
		$this->db->update('selection_category', array('enabled'=>$enabled));
		return TRUE;
	}



}
?>