<?php
/**
 * benchmark_model - Model for add/update/delete benchmark
 *
 * @author $Author: dtong $
 * @version $Id: benchmark_model.php,v 1.16 2011/03/23 11:34:25 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class benchmark_model extends CI_Model {
	function __construct() {
		parent::__construct();
    }

	function get_allbenchmark($enabled, $type, $filter=FALSE,$departmentid=FALSE,$schoolid=FALSE,$strandid=FALSE,$standardid=FALSE,$_table=FALSE) { // 1:enabled
		 $school_table = $this->db->dbprefix('school');
		 if ($_table != FALSE)
			$school_table = $_table;
		 $sql  = 'select b.id,c.name course,gmin.name mingrade,gmax.name maxgrade,s.data standard,b.type,b.importid,b.data,b.enabled,' .
		 			'sc.name school,d.name department,s.importid standard_importid,b.importid benchmark_importid,' .
		 			'str.enabled strand_enabled,s.enabled standard_enabled,d.enabled department_enabled ';
	    $sql .=" from benchmark b";
	    $sql .=" left join course_sis c on b.courseid=c.id and c.enabled=".CMS_ADMIN_ENABLE;
	    $sql .=" left join grade gmin on b.mingradeid=gmin.id";
	    $sql .=" left join grade gmax on b.maxgradeid=gmax.id";
	    $sql .=" left join standard s on b.standardid=s.id ";//enabled
	    $sql .=" left join strand str on s.strandid=str.id ";//enabled
	    $sql .=" left join $school_table sc on str.schoolid=sc.id";
	    //$sql .=" left join department d on str.departmentid=d.id and d.enabled=".CMS_ADMIN_ENABLE;
	    $sql .=" left join department d on str.departmentid=d.id";

	    if ($type!=FALSE){
	    	$where = " where b.type =" . $type;
	    }
		if ($strandid!=FALSE){
	    	$where .= " and s.strandid =" . $strandid;
	    }
	  	if ($standardid!=FALSE){
	    	$where .= " and b.standardid =" . $standardid;
	    }
		if ($departmentid!=FALSE){
	    	$where .= " and str.departmentid =" . $departmentid;
	    }
		if ($schoolid!=FALSE){
	    	$where .= " and str.schoolid =" . $schoolid;
	    }

		if ($enabled!=CMS_ADMIN_ALL){
			if ( empty($enabled) ) {
				//Show even if department is disabled
	    		$where .= ' and (str.enabled=' . CMS_DB_BOOLEAN_FALSE . ' or d.enabled=' . CMS_DB_BOOLEAN_FALSE .
	    					 ' or s.enabled=' . CMS_DB_BOOLEAN_FALSE . ' or b.enabled=' . CMS_DB_BOOLEAN_FALSE . ')';
			}
			else {
				$where .= ' and str.enabled=' . CMS_DB_BOOLEAN_TRUE . ' and (d.enabled=' . CMS_DB_BOOLEAN_TRUE .
							 ' or str.departmentid=0 or str.departmentid is null) ' .
							 ' and s.enabled=' . CMS_DB_BOOLEAN_TRUE . ' and b.enabled=' . CMS_DB_BOOLEAN_TRUE;
			}
	    }

		if ($filter!=FALSE)
	    //$where .= " and (b.data like '%$filter%' or s.data like '%$filter%' or gmin.name like '%$filter%' or gmax.name like '%$filter%' or b.enabled like '%$filter%')";
	    $where .= " and (b.data like '%$filter%')";
	    $order_by = " Order by s.data,b.data";


	    $res = $this->db->query($sql.$where.$order_by);

		if ( $res->num_rows() <= 0 )
			return FALSE;

		return $res->result();
	}

	function get_benchmark($benchmarkid, $benchmark_enabled=1, $benchmarkname=FALSE,$_table=FALSE) {
		if ( !is_numeric($benchmarkid) )
			return FALSE;
		$school_table = $this->db->dbprefix('school');
		if ($_table != FALSE)
			$school_table = $_table;
		$this->db->select('str.data strand,d.name department,sch.name school ,b.id, b.courseid, b.mingradeid, b.maxgradeid, b.standardid,b.type, b.importid, b.data, b.enabled'); //enabled
		//$this->db->select('id, courseid, mingradeid, maxgradeid, standardid,type, importid, data');
	    $this->db->from('benchmark b');
	    $this->db->join('standard s', 'b.standardid=s.id'  ,'left');
	    $this->db->join('strand str', 's.strandid=str.id'  ,'left');
	    $this->db->join('department d', 'str.departmentid=d.id' , 'left');
	    $this->db->join($school_table.' sch', 'str.schoolid=sch.id' , 'left');
	    $this->db->where('b.id',$benchmarkid);

		$res = $this->db->get();
		if ( $res->num_rows() != 1 )
			return FALSE;
		return $res->result();
	}

	function get_department($dep_schid=FALSE) {
		$this->db->select('id,name ');
	   $this->db->from('department');
	   if ($dep_schid!=FALSE) {
	      $this->db->where ('id',$dep_schid);
	   }
	   $this->db->where('enabled',CMS_DB_BOOLEAN_TRUE);
	   $this->db->order_by('name');
	   $res = $this->db->get();
		if ( $res->num_rows() <= 0 ) {
			return FALSE;
		}
		$au = $res->result();
		$result = array();
		$result[0] = lang('admin_department_ddldefualt');
		foreach($au as $value) {
			$result[$value->id] = $value->name;
		}
		return $result;
	}

	function get_school($type=FALSE,$dep_schid=FALSE,$_table=FALSE) {
		$school_table = $this->db->dbprefix('school');
		if ($_table != FALSE)
			$school_table = $_table;
		$this->db->select('id,name ');
	   $this->db->from($school_table);
	   if ($_table != FALSE)
	   		$this->db->where ('type',$type);
	   if ($dep_schid!=FALSE)
	   	$this->db->where ('id',$dep_schid);
	    $this->db->order_by('name');
	    $res = $this->db->get();
			if ( $res->num_rows() <= 0 )
			return FALSE;
		$au = $res->result();
		$result = array();
		$result[0] = lang('admin_school_ddldefualt');
		foreach($au as $value) {
			$result[$value->id] = $value->name;
		}
		return $result;
	}

	function get_course() {
		$this->db->select('id, name ');
	    $this->db->from('course_sis');
	    $this->db->where('enabled',CMS_ADMIN_ENABLE);//enabled
	    $this->db->order_by('name');
	    $res = $this->db->get();
		if ( $res->num_rows() <= 0 )
			return FALSE;

		$deps = $res->result();
		$result = array();
		$result[0] = lang('admin_course_ddldefualt');
		foreach($deps as $value) {
			$result[$value->id] = $value->name;
		}
		return $result;

	}

	function get_grade() {
		$this->db->select('id, name ');
	    $this->db->from('grade');
	    $this->db->order_by('sort');
	    $res = $this->db->get();
		if ( $res->num_rows() <= 0 )
			return FALSE;
		$accs = $res->result();
		$result = array();
		$result[0] = lang('admin_grade_ddldefualt');
		foreach($accs as $value) {
			$result[$value->id] = $value->name;
		}
		return $result;

	}
/*
	function get_strand($type,$departmentid=FALSE,$schoolid=FALSE) {
		$this->db->select('id,data ');
	    $this->db->from('strand');
	    $this->db->where ('type',$type);
        if ($departmentid!=FALSE)
        	$this->db->where ('departmentid',$departmentid);
        if ($schoolid!=FALSE)
        	$this->db->where ('schoolid',$schoolid);
	   // $this->db->where   ('enabled',CMS_ADMIN_ENABLE);//enabled
	    $this->db->order_by('data');
	    $res = $this->db->get();
			if ( $res->num_rows() <= 0 )
			return FALSE;
		$au = $res->result();
		$result = array();
		$result[0] = lang('admin_strand_ddldefualt');
		foreach($au as $value) {
			$result[$value->id] = $value->data;
		}
		return $result;
	}
*/
	function get_standard($type,$strandid=FALSE,$departmentid=FALSE,$schoolid=FALSE) {
		$this->db->select('s.id,s.importid,s.data');
	   $this->db->from('standard s');
	   $this->db->join('strand str', 's.strandid=str.id', 'left');
	   $this->db->where   ('s.type',$type);
	   if ($strandid!=FALSE)
	   	$this->db->where   ('s.strandid',$strandid);
	   if ($departmentid!=FALSE)
        	$this->db->where ('str.departmentid',$departmentid);
      if ($schoolid!=FALSE)
        	$this->db->where ('str.schoolid',$schoolid);
	    //$this->db->where('enabled',CMS_ADMIN_ENABLE);//enabled
	   $this->db->order_by('s.data');
	   $res = $this->db->get();
		if ( $res->num_rows() <= 0 )
			return FALSE;
		$accs = $res->result();
		if ( $this->config->item('cms_lt_importid_support') ) {
			//Modify the query result to display the importid
			foreach ($accs as $record) {
				if ( !empty($record->importid) )
					$record->data = "$record->importid $record->data";
			}
			//Use natural sort on the strand name prefixed with the importid
			osa_array_natsort($accs, array('data'));
		}
		$result = array();
		$result[0] = lang('admin_standard_ddldefualt');
		foreach($accs as $value) {
			$result[$value->id] = $value->data;
		}
		return $result;

	}

	//Adds a new benchmark
	//TODO: the DB transitions is all wrong here. Fix it.
	function add_benchmark($data,$target=FALSE) {
		$id = FALSE;
		$this->db->trans_begin();
		if ($data != FALSE) {
			$this->db->insert('benchmark', $data);
			$id = osa_db_lastinsertid($this->db);
			if ( !$id ) {
				$this->db->trans_rollback();
				return FALSE;
			}
		}
		//For ICT upload. Needs a dummy record in target_text to link with units
		if ($target != FALSE && $id != FALSE) {
			$target['benchmarkid'] = $id;
			$this->db->insert('target_text', $target);
			$id = osa_db_lastinsertid($this->db);
			if ( !$id ) {
				$this->db->trans_rollback();
				return FALSE;
			}
		}
		$this->db->trans_commit();
		return TRUE;
	}

    function update_benchmark($benchmarkid,$data) {

		$this->db->where('id',$benchmarkid);
		$this->db->update('benchmark', $data);
		return TRUE;
	}

	function del_benchmark($benchmarkid,$benchmark_enabled) {
		$this->db->where('id',$benchmarkid);
		$this->db->update('benchmark', array('enabled'=>$benchmark_enabled));
		return TRUE;
	}



}
?>