<?php
/**
 * uph_unit_radio.php - Unit process handle for render radio button.
 *
 * @author $Author: dtong $
 * @version $Id: uph_unit_radio.php,v 1.3 2010/11/17 12:13:26 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

require_once(APPPATH.'/libraries/unit/unit_base.php');
class uph_unit_radio extends unit_base {

	function render($data, $params) {
		$html ='';
		//$radio_name = $this->getval('_radio_name',$data);
		$question_text =	$this->getval('_question_text',$data);
		$radio_text_array = $this->getval('_radio_text_array',$data);
		$question_index = $this->getval('_index',$data);
		$survey_weight = $this->getval('_survey_weight',$data);
		$type = $this->getval('_typeid',$data);
		if ( !($bgcolor_text = $this->getval('_bgcolor_text',$data)) ) {
			$bgcolor_text = '#E3E4FA';
		}
		//Just need an unique name for the radio buttons. Not significant for the app.
		$radio_name = "ur_{$type}_{$question_index}";

		if (!isset($data) && $data === FALSE ){
			osa_errorlog(__METHOD__ . " - Invalid template ", $data);
			return osa_buildererror();
		}

		if (isset($params) && $params !== FALSE){
			$extid = FALSE;
			if (isset($params->unitid) && $params->unitid !== FALSE){
				$extid = $params->unitid;
			}
			//get data template_htmldata
			$this->CI->load->model('unit/html_data_model');
			$template_htmldata = $this->CI->html_data_model->get($extid, $type, $question_index);

			$html .=	'<table class="question_radio_form_table" border="0">';
			if ( $question_text ) {
				$html .=	"<tr bgcolor='{$bgcolor_text}' class='map_resitem'><td colspan='6'>";
				$html .= '<span class="question_radio_form_title" >' . $question_text . '</span>';
				$html .=	'</td></tr>';
			}
			if (isset($params->action) && $params->action !== FALSE ){
				$disabled = '';
				if ($params->action == CMS_ACTION_READ)
					$disabled = 'disabled="disabled"';
				$html .=	"<tr>";
				foreach ($radio_text_array as $select=>$value){
					$html .= '<td width="17%" class="radio_item">';
					//Gets the onclick even jscript
					$jscript = $this->onclick_function_str($extid, $type, $select, $question_index, $survey_weight);
					if ( empty($jscript) ) {
						$tmp = array($extid, $type, $select, $question_index, $survey_weight);
						osa_errorlog(__METHOD__ . " - Invalid template ", $tmp);
						$html .= osa_buildererror();
					}
					$checked = $this->checked_radio($template_htmldata,$type,$select,$question_index);
					$html .= "<input type='radio' name='{$radio_name}' value='{$select}' {$checked} {$disabled} {$jscript}/>";
					$html .= "<span class='radio_form_title'>{$value}</span>";
					$html .= '</td>';
				}
				$html .='</tr>';
			}
			$html .='</table>';

		}
		else{
			osa_errorlog(__METHOD__ . " - Invalid params ", $data);
			return osa_buildererror();
		}
		return $html;
	}

	private function onclick_function_str($extid, $type, $select, $question_index, $survey_weight) {
		if ( !is_numeric($extid) || !is_numeric($type) || !is_numeric($select) ) {
			return '';
		}
		$str = "onClick=\"return update_radio('" . base_url() . "/unit/html_data/add/$extid/$type/$select/";
		if ( !is_numeric($question_index) || $question_index == FALSE ) {
			$str .= "0/";
		}
		else {
			$str .= "$question_index/";
		}
		if ( !is_numeric($survey_weight) || $survey_weight == FALSE ) {
			$str .= "0/";
		}
		else {
			$str .= "$survey_weight/";
		}
		return $str . '\');"';
	}

/*
	//Function Chang %s is $_params
	private function chang_params($type,$select,$question_index,$survey_weight){
		$_params = '';
		if ($type !== FALSE && $select !== FALSE)
			$_params .= $type.'/'.$select;
		if ($question_index !== FALSE )
			$_params .= '/'.$question_index;
		if ($survey_weight !== FALSE && array_key_exists($select,$survey_weight))
			$_params .= '/'.$survey_weight[$select];

		return $_params;
	}
*/

	//Function Checked radio button
	private function checked_radio($template_htmldata,$type,$select,$question_index){
		$checked ='';
		if (isset($template_htmldata) && $template_htmldata !== FALSE){
			foreach ($template_htmldata as $item){
				if ($question_index !== FALSE && $question_index == $item->question_index ){//survey
					if ($select == $item->radio_select)
						$checked = 'checked="checked"';
				}
				else{//not survey
					if ($type == $item->type){
						if ($select == $item->radio_select)
							$checked = 'checked="checked"';
					}
				}
			}
		}
		return $checked;
	}
}
