<?php
/**
 * uph_template_date.php - Unit process handle for embedding a date on the template. This is any date.
 *
 * @author $Author: dtong $
 * @version $Id: uph_template_date.php,v 1.7 2011/04/19 04:04:46 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

require_once(APPPATH.'/libraries/unit/unit_base.php');
class uph_template_date extends unit_base {
	//The $count variable creates unique button and text ids
	//A static variable ensures the buttons are always unique on a single page no matter how many times
	//or where you call this plugin
	private static $count = 1;

	function __construct() {
		parent::__construct();
		osa_load_lang('template');
	}

	function render($data, $params) {
		//Make sure the data types are correct
		if ( !is_array($data) || !is_object($params) ) {
			osa_errorlog(__METHOD__ . ' - Input data or params is not set.', array($data, $params));
			echo osa_buildererror();
			return FALSE;
		}
		//Make sure we have the action
		if ( !isset($params->action) || !is_string ($params->action) ) {
			osa_errorlog(__METHOD__ . ' - $params contains no action.', $this->params);
			echo osa_buildererror();
			return FALSE;
		}
		//Make sure we have the unitid
		if ( !isset($params->unitid) || !is_string ($params->unitid) ) {
			osa_errorlog(__METHOD__ . ' - $params contains no unitid.', $this->params);
			echo osa_buildererror();
			return FALSE;
		}

		$html = '<div class="goal_title_date" ><nobr>' . $this->getval('_title',$data) . ' ';
		$typeid = $this->getval('_typeid', $data);
		$template_date = $this->get_completion_date($params->unitid, $typeid);
		$completedate = '';
		if ( isset($template_date->date) && $template_date->date != FALSE )
			$completedate = osa_date_format($template_date->date);

		if ( $params->action == CMS_ACTION_EDIT ) {
			$html .= $this->render_write($data, $completedate, $params);
		}
		else {
			$html .= $this->render_read($completedate, $typeid, $params->unitid);
		}

		$html .= '</nobr></div>';
		return $html;
	}

	//Function to render completion date read action.
	private function render_read($completedate, $typeid, $extid){
		$cssid = $typeid.'_'.$extid;
		$html = "<span class='goal_completedate' cssid='$cssid'>{$completedate}</span>";
		return $html;
	}

	//Function to render completion date edit action.
	private function render_write($data, $completedate, $params){
		$typeid = $this->getval('_typeid', $data);
		if ( $typeid === FALSE ) {
			osa_errorlog(__METHOD__ . 'Missing _typeid.', $data);
			return osa_buildererror();
		}
		//Somehow embeddeding a static variable in a string does not work...
		$count = self::$count;
		$url = base_url() . "template/templatedate/update/{$typeid}/$params->unitid";

		$input_img = "<img id='templatedatebutton{$count}' name='templatedatebutton{$count}' alt='" .
						 lang('template_date_select_date') . '\' src=\'' . osa_imagepath() . 'calen.gif\' border="0" />';
		$input_img = "<a href='JavaScript:SelectDate' onClick='return false;' title='" . lang('template_date_select_date') . "'>$input_img</a>";

		$jscript = "onChange=\"ajaxPostform('','$url','templatedateform{$count}',true);return false;\"";
		$html = "<input type='text' id='templatedatetext{$count}' name='templatedatetext{$count}' size='15' " .
						"value='{$completedate}' readonly='readonly' $jscript /> $input_img";

		$html = "<form name='templatedateform{$count}' style='display:inline;padding:0px;margin:0px;'>$html</form>";
		self::$count++;
		return $html;
	}

	//Function Get completion date in template_date table.
	private function get_completion_date($extid, $type) {
		$template_date = FALSE;
		$this->CI->load->model('unit/uph/template_date_model');
		if ( isset($extid) && $extid != FALSE && isset($type) && $type !== FALSE )
			$template_date = $this->CI->template_date_model->get_template_date($extid, $type);
		return $template_date;
	}

}