<?php
/**
 * unit_select.php - Handles the rendering of user selections from the selection pages like EQ
 *
 * @author $Author: dtong $
 * @version $Id: unit_select.php,v 1.12 2011/05/09 04:48:52 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once ('unit_base.php');

class unit_select extends unit_base {

	function __construct() {
		parent::__construct();
	}

	function render($data, $params) {
		if ( $data !== FALSE && $params !== FALSE )
			$this->reset($data, $params);
		$this->html = '';
		$this->CI->load->model('unit/select_model');
		$selects = $this->CI->select_model->get_category($this->params->unitid, $this->getval('_typeid'));

		// get all departments & toArray with id is key
		$depts = $this->CI->select_model->get_departments('id',TRUE);
 		$deptobj = $this->CI->unit_model->get_departbyparent($this->params->unitid, true, 'deptid');

		$this->CI->load->model('unit/unit_model');
		$first_course = TRUE;
		if ( $selects ) {
			$lastdeptid = '';
			$courseid = false;
			if ($params != false && is_object($params) && isset($params->courseid))
				$courseid = $params->courseid;
			foreach($selects as $select) {
				$cssid_res = '';
				$class = $this->color_track('listitem1', 'listitem2');
				$deptname = FALSE;
				if (is_array($deptobj) && array_key_exists($select->departmentid, $deptobj) )
					$deptname = $deptobj[$select->departmentid]->name;

				if (is_array($deptobj) && count($deptobj) > 1 && isset($deptobj[$select->departmentid]->department_display) && $deptobj[$select->departmentid]->department_display != '' )
					$deptname .= '/'.$deptobj[$select->departmentid]->department_display;

				// get department name from department id and return with <div><i> tag html(default)
				if ($deptname === FALSE)
					$deptname = $this->CI->select_model->get_department($depts ,$select->departmentid );

				if ($lastdeptid =='' || $lastdeptid != $select->departmentid) {
					$margin = '';
					if ( $this->action() == CMS_ACTION_EDIT ) {
						$margin = "style='margin-top:-7px'";
					}
					if ( !$first_course )
						$margin = "style='margin-top:7px'";

				    $lastdeptid = $select->departmentid;
				    if ($select->departmentid != FALSE)
				    	$this->html.= "<div $margin class=\"itemtext_italic\">" . $deptname . "</div>";
				    $first_course = FALSE;
				}
				if (isset($params->use_cssid) && $params->use_cssid===TRUE) {
					 $pre_res = CMS_MODULE_SELECT . $select->type . '_';
					 $cssid_res = "cssid='{$pre_res}{$select->id}'";
				}

				$this->html .= "<table class=\"$class\"><tr>";
				$this->html .= "<td class=\"itemtext\" $cssid_res>";
				$this->html .= "{$select->text}";
				if ( ($cattext = $this->getval('_category_bodytext')) !== FALSE ) {
						$this->html .= "<span style=\"margin-left:15px\">&nbsp;</span>";
						if ( ($catcolor = $this->getval('_category_color')) !== FALSE ) {
							$this->html .= "<nobr><font color=\"{$catcolor}\">{$cattext}</font></nobr>";
						}
						else {
							$this->html .= "<nobr>{$cattext}</nobr>";
						}
					}
				$this->html .="</td>";

				//Buttons
				if ( is_array($buttons = $this->getval('_button')) ) {
					//$this->html .= "<td class=\"itembuttons\">111</td>";
					$this->html .= '<td valign="middle" align="right" class="itembuttons">';
					$tmpparams = $this->params;
					$tmpparams->resid = $select->id; //assign the resource id
					$this->html .= $this->buttonsobj->render($buttons, $tmpparams);
					$this->html .= '</td>';
				}//Buttons
				$this->html .="</tr></table>";



			}
			//$this->html .= '</div>';
		}
		return $this->html;
	}

}
?>