<?php
/**
 * unit_os.php - Handles the rendering of user selections from the selection pages like EQ
 *
 * @author $Author: dtong $
 * @version $Id: unit_os.php,v 1.17 2011/05/09 04:48:52 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once ('unit_base.php');

class unit_os extends unit_base {

	function __construct() {
		parent::__construct();
		$this->CI->load->model('unit/os_model');
		osa_load_lang('unit');
	}

	function render($data, $params) {
		$pre_os = CMS_MODULE_ZMS_OUTCOMES . CMS_OUTCOMES_SKILLS_TYPE . '_';
		$cssid_os = '';
		$use_cssid = FALSE;

		if ( $data !== FALSE && $params !== FALSE ) {
			$this->reset($data, $params);
		}
		$this->html = '';

		$this->CI->os_model->sort_read_only = $this->sort_read_only;
		$this->CI->os_model->sort_type = $this->sort_type;
		$this->CI->os_model->sort_filehash = $this->get_template_filepart();
		$selects = $this->CI->os_model->get_outcomes_skills($this->params->courseid, $this->params->unitid, $this->type());

		//cssid for compare version highlight
		if (isset($params->use_cssid) && $params->use_cssid===TRUE)
			$use_cssid = TRUE;

		if ($selects) {
			$lastid   = '';
			$outcomes = array();
			$skills   = array();
			foreach ($selects as $row) {
				if ($lastid != $row->outcomesid && $lastid != '') {
					$temp 			   = array($skills[0]->outcomes, $skills);
					$outcomes[$lastid] = $temp;

				    $lastid            = $row->outcomesid;
				    $skills            = array();
				    $skills[]		   = $row;
				}
				else {
					if (count($skills)== 0) {
						$row->first	   = TRUE;
					}
					$skills[] 		   = $row;
					$lastid  		   = $row->outcomesid;
				}
			}

			if (isset($outcomes[$lastid]) == FALSE) {
				$temp 			   = array($skills[0]->outcomes, $skills);
				$outcomes[$lastid] = $temp;
			}

			$selects = $outcomes;
			$outcomes     = lang('unit_outcomes_render_outcomes');
			$skills       = lang('unit_outcomes_render_skills');
			$this->html .= "<table class='unit_outcomes_skills_table2' cellspacing='0' cellpadding='0' border='0'>";

			$lastoutcomes = '';
			$course = array();
			$courseid = '';
			$coursename = '';
			$first_course = TRUE;
			foreach($selects as $select) {
				if ($lastoutcomes != $select[0]) {
					$lastoutcomes  = $select[0];
					$courseid = $select[1][0]->courseid;
					$coursename =$select[1][0]->coursename;
					if (!in_array($courseid, $course )){
						$margin = '';
						if ( !$first_course )
							$margin = "style='margin-top:5px;'";
						$course[]=$courseid;
						$this->html .= "<tr><td colspan='2' class=\"itemtext_italic\">";
						$this->html .= "<div {$margin} >$coursename</div>";
						$this->html .= "</td></tr>";
						$first_course = FALSE;
					}
					$this->html .= "<tr><td class='itemtext' colspan='2'>";
					$this->html .= "<div class='unit_outcomes_skills_header_outcomes'>$lastoutcomes</div>";
					$this->html .= "</td></tr>";
					$this->html .= "<tr><td class='itemtext' colspan='2'>";
					$this->html .= "<div class='unit_outcomes_skills_header_skills'>$skills</div>";
					$this->html .= "</td></tr>";
				}
				$last_skillid = '';
				$sort_skills = &$select[1];
				//We need to sort each skill segment separately
				osa_array_natsort($sort_skills, Cms_btnsort::INDEX_SORTKEY);
				$skills_count = count($sort_skills);
				$tmp_counter = 0;
				foreach ($select[1] as $row) {
					if ($use_cssid) {
						 $cssid_os = "cssid='{$pre_os}{$row->id}'";
					}
					$class = $this->color_track('unit_outcomes_skills_bg1', 'unit_outcomes_skills_bg2');
					$this->html .= "<tr><td class='$class' ><div class='$class' $cssid_os>" . $row->skills ."</div></td>";
					$this->html .= "<td valign='middle' align='right' class='$class' width='10%'><nobr>";
					$tmpparams = $this->params;
					$tmpparams->resid = $row->id; //assign the resource id
					if ( $skills_count > 1 ) {
						if ( $tmp_counter == 0 ) {
							$sort_array = $this->CI->cms_btnsort->get_buttons_manual(Cms_btnsort::BUTTONS_FIRST,$row,$this->sort_type);
						}
						elseif ( $tmp_counter == $skills_count-1) {
							$sort_array = $this->CI->cms_btnsort->get_buttons_manual(Cms_btnsort::BUTTONS_LAST,$row,$this->sort_type);
						}
						else {
							$sort_array = $this->CI->cms_btnsort->get_buttons_manual(Cms_btnsort::BUTTONS_MIDDLE,$row,$this->sort_type);
						}
						$this->html .= $this->buttonsobj->render($sort_array, $tmpparams);
					}
					if ( is_array($buttons = $this->getval('_button')) ) {

						$this->html .= $this->buttonsobj->render($buttons, $tmpparams);
					}

					$this->html .= "</nobr></td>";
					$tmp_counter++;
				}
				$this->html .="</tr>";
					}
			$this->html .="</table>";
		}
		return $this->html;
	}
}

