<?php
/**
 * unit_itstd.php - Handles the rendering of IT Standards
 *
 * @author $Author: dtong $
 * @version $Id: unit_itstd.php,v 1.21 2011/05/09 04:48:52 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once ('unit_base.php');

class unit_itstd extends unit_base {

	function __construct() {
		parent::__construct();
		$this->CI->load->model('unit/itstd_model');
	}

	function render($data, $params) {
		$pre_str = 'itstr_';
		$pre_sta = 'itsta_';
		$pre_ben = 'itben_';
		$cssid_str = '';
		$cssid_sta = '';
		$cssid_ben = '';
		$use_cssid = FALSE;

		if ( $data !== FALSE && $params !== FALSE ) {
			$this->reset($data, $params);
		}
		$dbobjs = $this->CI->itstd_model->get_strand_tree_render($this->unitid(), $this->type());
		if ($dbobjs === NULL ) {
			return osa_buildererror();
		}
		if ( !$dbobjs ) {
			return '';
		}

		$getresourcetype = $this->CI->unitmain->get_itstd_resourcetype ($this->type());
		//TODO: This is linked with commented code below which uses $resobjs. Delete both when necessary
		//$resobjs = $this->CI->itstd_model->get_uploads_targetids($getresourcetype);
		$temp = FALSE;
		if (isset($data['_grade_related_data']) && $data['_grade_related_data'] != FALSE)
			$temp = $data['_grade_related_data'];
		$schools = $this->CI->itstd_model->get_all_schools('id',TRUE,$temp);
		$schools_name  = array();
		//Create the array structure from db records
		$db_struct     = array();
		$firstlast_obj = array();
		if ( $dbobjs ) {
			$last_strandid  = '';
			$last_standardid= '';
			//Build the array structure for display purpose
			foreach($dbobjs as $record) {
				if ( $last_strandid != $record->strandid) {
					 $db_struct[$record->strandid][0] = $record->strand;
					 $last_strandid  = $record->strandid;
				}
				if ($last_standardid != $record->standardid) {
					$db_struct[$record->strandid][$record->standardid][0] = $record->standard;
					$last_standardid  = $record->standardid;
				}
				if ( is_array($schools) && array_key_exists($record->schoolid, $schools) )
					$schools_name[ $record->strandid] = $schools[$record->schoolid]->name;

				$db_struct[$record->strandid][$record->standardid][] = $record;
			}
		}

	 	$select_array["icon1"] = $this->getval('_select1');
	 	$select_array["icon2"] = $this->getval('_select2');

		//cssid for compare version highlight
		if (isset($params->use_cssid) && $params->use_cssid===TRUE)
			$use_cssid = TRUE;

		$this->html = '<div class="sb_body">';
	 	$last_schoolname='';
	 	//print_r($resobjs);
		//Loop thru the arrays for html output
		foreach ($db_struct as $strandid => $strand) {
			if (is_array($schools_name) && ($last_schoolname == '' || $last_schoolname != $schools_name[$strandid] )) {
				$last_schoolname = $schools_name[$strandid];
				$value = $last_schoolname;
				if ( $this->action() == CMS_ACTION_EDIT ) {
					$this->html .= "<div style='margin-top:-7px;'><i>$value</i></div>";
				}
				else {
					$this->html .= "<i>$value</i>";
				}
			}
			if ( $strandid == 0 ) continue;
			if ($use_cssid)
				 $cssid_str = "cssid='{$pre_str}{$strandid}'";

			$this->html .= "<div class=\"sb_strand\" $cssid_str>" . $this->getval('_strand_title') . ": {$strand[0]}";
			foreach ($strand as $standardid => $standard) {

				if ( $standardid == 0 ) continue;
				if ($use_cssid)
				    $cssid_sta = "cssid='{$pre_sta}{$standardid}'";

				$this->html .= "<div class=\"sb_std\" $cssid_sta>" . $this->getval('_standard_title') . ": {$standard[0]}</div>";

				$this->color_track_reset();
				$this->html .= "<div class=\"sb_benchtitle\">" . $this->getval('_bench_title') . ":</div>";

				$last_targetid='';
				foreach ($standard as $index => $record) {
					if ( $index == 0 ) continue;
					if ($use_cssid) {
						 $cssid_ben = "cssid='{$pre_ben}{$record->benchmarkid}'";
						 $color = 'lt_item2';
					}
					else
						 $color = $this->color_track('lt_item1','lt_item2');
						//$class = $this->color_track('sb_bench1','sb_bench2');

					$this->html .= "<div class=\"$color\" $cssid_ben><table border=0px; width=\"100%\" style=\"margin:0px;\"><tr><td class=\"lt_symbol\"></td>";

					if ($last_targetid !== $record->targetid) {
						//show benchmark

						$this->html .= "<td colspan=2 >{$record->benchmark}</td>";
						$this->html .= '<td class="lt_symbol" >';

						$bigt = "";
						$bigl = "";
						if ( !is_null($record->select1) && $select_array && array_key_exists($record->select1, $select_array["icon1"] )) {
							$bigt = $select_array["icon1"][$record->select1];
						}
						if ( !is_null($record->select2) && $select_array && array_key_exists($record->select2, $select_array["icon2"] )) {
							$bigl = $select_array["icon2"][$record->select2]."&nbsp;";
						}
						if (!$this->CI->config->item('cms_use_tail') || !$this->CI->config->item('cms_use_gc'))
							$this->html .=	$bigt . $bigl;
						$this->html .= '</td>';

						//$this->html .=  $this->render_sort_button($firstlast_obj, $record);

						//Buttons
						if ( is_array($buttons = $this->getval('_button')) ) {
							$this->html .= '<td width="1%" valign="middle" align="right" class="itembuttons">';
							$tmpparams = $this->params;
							$tmpparams->resid = $record->targetid; //assign the resource id
							$this->html .= $this->buttonsobj->render($buttons, $tmpparams);
							$this->html .= '</td>';
						}//Buttons
						else {
							$this->html .= '<td class="itembuttons"></td>';
						}
					}

					$link = '';
					//Think this is for sorting with resources but it is not used yet.
					/* TODO: Delete this code when you are sure
			 	 	if ( FALSE && isset($resobjs) && is_array($resobjs)  ) {
						  if ( array_key_exists($record->targetid, $resobjs) ) {
						       $resources = $resobjs[$record->targetid];
		    				   $last_resid ='';
		    				   $last_url ='';

		    				   $link .= "<tr><td class=\"lt_symbol\"></td><td class=\"lt_symbol\"></td><td>";
							   foreach ($resources as $uploads) {
								   if  ($last_resid != $uploads->resid) {
									    $link .= $uploads->text1;
									    if (!is_null($uploads->url1) && $this->getval('_url_flag') !== FALSE ) {
											$last_url .= '<div class="urlitem">' . lang('unit_uploadedurl') . ': ';
											$last_url .= '<a target="_blank" href="http://'.$uploads->url1.'">'.$uploads->url1.'</a>';
										}
								   }

								   $href= base_url() . "unit/resource/file/{$uploads->uploadid}/" . urlencode($uploads->filename);
								   $link .= '<div class="uploaditem">' . lang('unit_uploadedfile') . ': ';
								   $link  .= "<a onclick=\"return downloadWindow('{$href}')\" target=\"_blank\" href=\"" . $href . '">' .
											$uploads->filename. '</a><span class="uploadsize">' . ' (' . osa_filesizestr($uploads->size) . ')';
								   $link .= '</span></div>';

								   if  ($last_resid != $uploads->resid) {

										//Buttons resource
										$button = '&nbsp';
										if ( is_array($buttons = $this->getval('_button_upload')) ) {
											$button .= '<td width="1" valign="middle" align="right" class="itembuttons">';
											$tmpparams = $this->params;
											$tmpparams->resid = $uploads->resid;
											$tmpparams->targetid = $record->targetid;
											$button .= $this->buttonsobj->render($buttons, $tmpparams);
											$button .= '</td>';
										}//Buttons resource

										$last_resid  = $uploads->resid;
									}
								}

								$link .= $last_url;
								$link .= "<td>&nbsp</td>";
								$link .= "</td></tr>";
						    }

						//  $this->html .= $link;
					} */

					$this->html .= '</tr></table></div>';
					$last_targetid = $record->targetid;
				}
			}
			$this->html .= '</div>';
		}
		$this->html .= '</div>';
		return $this->html;
	}
/*
	private function render_sort_button($dbobjs, $record) {
		$buttons_sort_n = $this->getval('_button_sortnormal');
		$buttons_sort_f = $this->getval('_button_sortfirst');
		$buttons_sort_l = $this->getval('_button_sortlast');

		if ( !is_array( $buttons_sort_n ) || !is_array( $buttons_sort_f ) || !is_array( $buttons_sort_l ) ) {
			return '';
		}

		$html = '';
		$count_data = count($dbobjs);
		if ($count_data != 2) {
			return '';
		}
		$tmpparams = $this->params;
		$tmpparams->resid = $record->targetid; //assign the resource id

		//var_dump($dbobjs);
		//return '';

		$check_firstid  = $dbobjs[0]->targetid;
		$check_lastid   = $dbobjs[1]->targetid;
		$check_buttonid = $record->targetid;

		$html .= '<td width="1%" valign="middle" align="right" class="itembuttons">';
		if ($check_buttonid == $check_firstid) {
			$html .= $this->buttonsobj->render($buttons_sort_f, $tmpparams);
		} elseif ($check_buttonid == $check_lastid) {
			$html .= $this->buttonsobj->render($buttons_sort_l, $tmpparams);
		} else {
			$html .= $this->buttonsobj->render($buttons_sort_n, $tmpparams);
		}
		$html .= '</td>';

		return $html;
	} */
	}
