<?php
/**
 * paging_base.php - paging handle base class.
 *
 * @author $Author: dtong $
 * @version $Id: paging_base.php,v 1.2 2011/04/13 10:20:09 dtong Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/

abstract class paging_base {
	protected $CI = NULL;
	//The template object
	protected $template = NULL;
	//The handle array from the template
	protected $handle_check_array = FALSE;
	//The page number that is being processed
	protected $pagenumber = FALSE;
	protected $data_input = FALSE;
	//The action is either 'read' or 'edit'
	protected $action = '';
	//This can be unitid, goalid, surveyid, check the $template_identifier first.
	protected $unitid;
	//The identifier like goal, unit and survey
	protected $template_identifier;
	//All handles must define the valid tags in this array.
	protected $handle_param_list = array();
	//All handles must check this flag before proceeding. It tells does the data array containd valid tags or not
	protected $valid_params_checked = TRUE;

	//This has to be implemented in the handle;
	abstract function invoke();

	function __construct() {
		$this->CI = &get_instance();
	}

	//This needs to be called before runing the handle invoke.
	function reset($pagenumber, &$template, &$handle_check_array, &$data_input) {
		if ( !isset($data_input['action']) ) {
			osa_errorlog(__METHOD__ . " - action is missing from param array.", $data_input);
			return FALSE;
		}
		if ( !isset($data_input['unitid']) ) {
			osa_errorlog(__METHOD__ . " - unitid/extid is missing from param array.", $data_input);
			return FALSE;
		}
		if ( !isset($template->template_identifier) ) {
			osa_errorlog(__METHOD__ . " - template_identifier is missing from \$template.");
			return FALSE;
		}

		$this->template = & $template;
		$this->handle_check_array = & $handle_check_array;
		$this->pagenumber = $pagenumber;
		$this->data_input = & $data_input;
		$this->action = $data_input['action'];
		$this->unitid = $data_input['unitid'];
		$this->template_identifier = $template->template_identifier;

		$this->valid_params_checked = TRUE;
		return $this->valid_handle_params();
	}

	//Checks to see if all the handle parameters from a particular handle in the template are valid
	//We do the check here instead in Page_handle_main so we can have some flexibility for future growth.
	//We can modify this code a little later to let the handle class to determine if tag checking necessary or not.
	private function valid_handle_params() {
		foreach ($this->handle_check_array as $param_key => $dummy_value) {
			if ( $param_key == '_handle' ) {
				continue;
			}
			if ( !in_array($param_key, $this->handle_param_list) ) {
				$this->valid_params_checked = FALSE;
				osa_errorlog(__METHOD__ . " - Invalid handle parameter found - $param_key.", $this->handle_check_array);
				return FALSE;
			}
		}
		return TRUE;
	}
}