<?php
/**
 * handle_base.php - Base class for template module event handles.
 * 						Should not modify this file unless you know what you are doing.
 *
 * @author $Author: dtong $
 * @version $Id: handle_base.php,v 1.6 2011/05/11 05:34:32 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

abstract class handle_base {
	private $use_cache = TRUE; //Use DB cache for handles or not, can turn it off if there are problems
	protected $CI = NULL;
	public $error_flag = FALSE; //This is used to tell the calling routine to print builder error message.

	//Data related to the 2 input parameters - $data and $params
	//Reassign some of the $params data to this class so easier/cleaner to access, also check to make sure they exist
	private $params = NULL; //Original params from Unitmain. Very messy array so better hide(private) it
	protected $handle_data = NULL; //The handle parameters in an array.
	protected $data = NULL; //The array contains the whole template module array config like LT, resource etc.
	protected $template_obj = NULL; //This is the whole template
	protected $action = NULL; //Action in $params
	protected $template_identifier = NULL; //The template identifier and it is usually assigned in the factory calss
	protected $unitid = NULL; //This is more like external id, can be unit, goal , survey etc.
	protected $coursedid = NULL; //Can be null and not always defined. Whatever handle that uses courseid should check for null first

	//The main routine for a handle.
	abstract protected function invoke();

	function __construct() {
		$this->CI = & get_instance();
	}

	//This takes the input parameters and check & assign the necessary data
	//Always call this before invoking the event handler invoke() function.
	//This is done so reusing the object is OK and also does data checking.
	//All handle objects are cached and reused in Unitmain.php
	function reset($handle_data, $data, $params) {
		$this->handle_data = NULL;
		$this->data = NULL;
		$this->params = NULL;
		$this->template_obj = NULL;
		$this->action = NULL;
		$this->template_identifier = NULL;
		$this->unitid = NULL;
		$this->coursedid = NULL;
		$this->error_flag = FALSE;

		//Make sure the data types are correct
		if ( !is_array($data) || !is_object($params) ) {
			osa_errorlog(__METHOD__ . ' - Input data or params is not set.', array($data, $params));
			$this->error_flag = TRUE;
			return FALSE;
		}

		//Make sure we have the whole template object
		if ( !isset($params->template_object) || !is_object($params->template_object) ) {
			osa_errorlog(__METHOD__ . ' - $params contains no template_object.', $this->params);
			$this->error_flag = TRUE;
			return FALSE;
		}

		//Make sure we have the action
		if ( !isset($params->action) || !is_string ($params->action) ) {
			osa_errorlog(__METHOD__ . ' - $params contains no action.', $this->params);
			$this->error_flag = TRUE;
			return FALSE;
		}

		//Make sure we have the template_identifier
		if ( !isset($params->template_object->template_identifier) || !is_string ($params->template_object->template_identifier) ) {
			osa_errorlog(__METHOD__ . ' - $params contains no template_identifier.', $this->params);
			$this->error_flag = TRUE;
			return FALSE;
		}

		//Make sure we have the action
		if ( !isset($params->unitid) || !is_string ($params->unitid) ) {
			osa_errorlog(__METHOD__ . ' - $params contains no unitid.', $this->params);
			$this->error_flag = TRUE;
			return FALSE;
		}

		$this->handle_data = $handle_data;
		$this->data = $data;
		$this->params = $params;
		$this->template_obj = $params->template_object;
		$this->action = $params->action;
		$this->template_identifier = $params->template_object->template_identifier;
		$this->unitid = $params->unitid;
		//Don't want to make courseid a required property since it is not needed for non-unit templates
		//Whatever handle uses courseid should check for null first
		if ( isset($params->courseid) && osa_is_int($params->courseid) ) {
			$this->courseid = $params->courseid;
		}
		return TRUE;
	}

	//Since object $params is passed in by reference therefore this will change the action back to Unitmain.php
	protected function change_action2read () {
		//Unitmain.php changes the action back to the original after processing the module
		$this->params->action = CMS_ACTION_READ;
	}

	protected function change_action2edit () {
		global $g_pdf_mode;
		if ( (isset($g_pdf_mode) && $g_pdf_mode === TRUE) || $this->params->use_cssid) {
			//pdf doc and unit compare don't need edit mode
			return;
		}
		//Unitmain.php changes the action back to the original after processing the module
		$this->params->action = CMS_ACTION_EDIT;
	}

	protected function is_action_read() {
		return ($this->action == CMS_ACTION_READ);
	}

	protected function is_action_edit() {
		return ($this->action == CMS_ACTION_EDIT);
	}

	protected function handle_value($param) {
		return osa_value($this->handle_data, $param, FALSE);
	}

	//Checks to see all the handle parameters from a particular handle in the template are valid
	//If invalid parameter is found then sets the error flag to true so calling routine would print Browser error message.
	protected function valid_handle_params($param_list) {
		foreach ($this->handle_data as $param_key => $dummy_value) {
			if ( $param_key == '_handle' )
				continue;
			if ( strpos($param_list, $param_key)===FALSE ) {
				osa_errorlog(__METHOD__ . " - Invalid handle parameter found - $param_key.", $this->handle_data);
				$this->error_flag = TRUE;
				return FALSE;
			}
		}
		return TRUE;
	}
}