<?php
/**
 * unit_compare.php - compare unit object
 *
 * @author $Author: dtong $
 * @version $Id: unit_compare.php,v 1.4 2011/05/09 04:48:53 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class unit_compare {
	function __construct () {
		$this->CI = & get_instance();
		//$this->CI->load->model('sort/sort_model');
		$this->CI->load->model('compare/compare_model');

		osa_load_lang('unit');
		osa_load_lang('general');
		$this->CI->load->helper('date');
		$this->CI->load->library('unit/unit_init');
		$this->CI->load->library('unit/compare/compare_data');

	}

	function highlight_title($unitleft , $unitright) {
		$cssnormal    = 'unit_compare_normal';
		$csshighlight = 'unit_compare_highlight';
		$css = array('coursename'=>$cssnormal,'title'=>$cssnormal,
					    'description'=>$cssnormal, 'type'=>$cssnormal,
					    'startdate'=>$cssnormal, 'enddate'=>$cssnormal
				 );
		$subobj = FALSE;
		$objleft = FALSE;
		$objright = FALSE;
		foreach ($css as $key => $value) {
			if (isset($unitleft->$key)===FALSE || isset($unitright->$key)===FALSE)
				 if (isset($unitleft->unit) && isset($unitright->unit))
				 	  $subobj = 'unit';

			if ($subobj===FALSE) {
				$objleft = $unitleft->$key;
				$objright = $unitright->$key;
			}
			else {
				$objleft = $unitleft->$subobj->$key;
				$objright = $unitright->$subobj->$key;
			}

			if ($objleft !== FALSE && $objright !== FALSE && $objleft != $objright)
				 $css[$key] = $csshighlight;
		}
		return $css;
	}

	function highlight($unitleft , $unitright) {
		$unit = $unitleft;
		if (isset($unit->unit) == FALSE || isset($unit->unit->template) == FALSE)
			 $unit = $unitright;
		if (isset($unit->unit) == FALSE && isset($unit->unit->template) == FALSE)
			 return FALSE;

		$color = '#FFCCCC';
		$modules = $this->get_modules($unit->unit->template);
		$left = CMS_UNIT_COMPARE_LEFT;
		$right= CMS_UNIT_COMPARE_RIGHT;
		$temp = array($left=>$unitleft, $right=>$unitright);
		foreach ($modules as $key => $item) {
			foreach ($item as $type) {
				$this->CI->compare_data->compare_highlight($temp, $type, $color, $key);
			}
		}
		return $temp;
	}
	//Tells a template get modules.
   private function get_modules($template) {
   	if ( $template === FALSE ){
			osa_errorlog(__METHOD__ . " -  Invalidate template filename in Function get_modules ", $template);
			echo osa_ajaxmsg(lang('unit_no_permissionmsg'));
			exit;
		}
   	$this->CI->load->library('cms/cms_template/cms_template');
		return $this->CI->cms_template->filename_modules($template);
   }
}
?>