<?php
/**
 * compare_data_config.php - class for compare data config.
 *
 * @author $Author: dtong $
 * @version $Id: compare_data_config.php,v 1.4 2010/09/20 02:48:03 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class compare_data_config {

	public static function get_data_module($type=FALSE) {
		if ($type === FALSE )
			return FALSE;
		$data = array();

		$data[CMS_MODULE_RESOURCE] =
			array (
				'model'=>'compare_model',
				'function'=>'get_resources',
				'skipid'=> TRUE,
				'alllevel'=> TRUE,
				'db_id'=> array('id'),
				'db_text'=> array('text1'),
				'db_type'=> array($type),
				'pre_css'=> array('text1'=> CMS_CSS_STAGE1_RESOURCE.$type.'_'),

				'sub_config'=> array(
					 array(
						'model'=>'compare_model',
						'function'=>'get_upload',
						'skipid'=> TRUE,
						'alllevel'=> TRUE,
						'db_id'=> array('id'),
						'db_text'=> array('filelength'),
						'db_type'=> array($type),
						'pre_css'=> array('filelength'=> CMS_CSS_RESOURCE_UPLOAD.$type.'_'),
					),
					array(
						'model'=>'compare_model',
						'function'=>'get_resource_url',
						'skipid'=> TRUE,
						'alllevel'=> TRUE,
						'db_id'=> array('id'),
						'db_text'=> array('url'),
						'db_type'=> array($type),
						'pre_css'=> array('url'=> CMS_CSS_STAGE2_RESOURCE_URL.$type.'_'),
					),
					array(
						'model'=>'compare_model',
						'function'=>'get_resource_select',
						'skipid'=> TRUE,
						'alllevel'=> TRUE,
						'groupbytext'=> TRUE, // fix bug : more importance for grouping sub data with md5(text1)
						'db_id'=> array('id'),
						'db_text'=> array('choice1'),
						'db_type'=> array($type),
						'pre_css'=> array('choice1'=> CMS_CSS_STAGE2_RESOURCE_SELECT.'_'),
					)
				)
			);

		$data[CMS_MODULE_SELECT] =
			array (
				'model'=>'compare_model',
				'function'=>'get_unit_selection',
				'skipid'=> TRUE,
				'db_id'=> array('id'),
				'db_text'=> array('catid'),
				'db_type'=> array($type),
				'pre_css'=> array(
									 'catid'=>CMS_MODULE_SELECT.$type.'_'
								),
			);

		$data[CMS_MODULE_STD_BENCH] =
			array (
				'model'=>'compare_model',
				'function'=>'get_strand_bench',
				'skipid'=> FALSE,
				'alllevel'=> TRUE,
				'db_id'=> array('strandid', 'standardid', 'id'),
				'db_text'=> array('strand', 'standard', 'data'),
				'db_type'=> array($type),
				'pre_css'=> array('strand'=> CMS_CSS_LEARNING_TARGETS_STRAND.$type.'_',
										'standard'=> CMS_CSS_LEARNING_TARGETS_STANDARD.$type.'_',
										'data'=> CMS_CSS_LEARNING_TARGETS_BENCHMARK.$type.'_',
								),
			);

		$data[CMS_MODULE_LEARNING_TARGETS] =
			array (
				'model'=>'compare_model',
				'function'=>'get_learning_targets',
				'skipid'=> FALSE,
				'alllevel'=> TRUE,
				'db_id'=> array('id'),
				'db_text'=> array('data'),
				'db_type'=> array($type),
				'pre_css'=> array('data'=> CMS_MODULE_LEARNING_TARGETS.'_'
								),
			);

		//This is for the new lt_extended. It combines strands, standards, benchmarks and LTs on the unit page
		//We just combine the 2 existing compare configurations.
		$data['lt_extended'] = $data[CMS_MODULE_STD_BENCH];
		$data['lt_extended']['sub_config'] = array($data[CMS_MODULE_LEARNING_TARGETS]);

		$data[CMS_MODULE_ITSTANDARDS] =
			array (
				'model'=>'compare_model',
				'function'=>'get_itstandards',
				'skipid'=> TRUE,
				'alllevel'=> TRUE,
				'db_id'=> array('strandid', 'standardid', 'benchmarkid', 'benchmarkid', 'benchmarkid'),
				'db_text'=> array('strand', 'standard', 'benchmark', 'select1', 'select2'),
				'db_type'=> array($type),
				'pre_css'=> array('strand'=> CMS_CSS_ITSTANDARDS_STRAND.'_',
										'standard'=> CMS_CSS_ITSTANDARDS_STANDARD.'_',
										'benchmark'=> CMS_CSS_ITSTANDARDS_BENCHMARK.'_',
										'select1'=> CMS_CSS_ITSTANDARDS_BENCHMARK.'_',
										'select2'=> CMS_CSS_ITSTANDARDS_BENCHMARK.'_',
								)
			);

		$data[CMS_MODULE_ZMS_OUTCOMES] =
			array (
				'model'=>'compare_model',
				'function'=>'get_outcomes_skills',
				'skipid'=> FALSE,
				'db_id'=> array('skillsid'),
				'db_text'=> array('skills'),
				'db_type'=> array($type),
				'pre_css'=> array(
									'skills'=> CMS_MODULE_ZMS_OUTCOMES.$type.'_'
								),
			);
		return $data;
	}
}