<?php
/**
 * input_search.php - Class to deal with individual searches on a search page.
 * 						 This is the heart of the search page generation.
 *
 * @author $Author: dtong $
 * @version $Id: input_search.php,v 1.25 2011/04/01 14:55:57 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class input_search {
	private $data=NULL;
	private $searchid=NULL;
	private $html='';
	private $CI = NULL;

	function __construct() {
		$this->CI = & get_instance();
		$this->CI->load->helper('form');
		osa_load_lang('mapping');
	}

	function reset($searchid=NULL, $data=NULL) {
		$this->searchid = $searchid;
		$this->data = $data;
		$this->html = '';
	}

	/*
	 * This takes the array data (_data) from type=_search and render it
	 */
	function render() {
		if ( $this->data == NULL || $this->searchid == NULL )
			return FALSE;
		//var_dump($this->data);
		$searches = osa_value($this->data, '_search', FALSE);
		if ( $searches === FALSE ) {
			osa_errorlog(__METHOD__ . " - search array '_search' missing.", $this->data);
			return FALSE;
		}
		$formname = osa_value($this->data, '_form', FALSE);
		$handle = osa_value($this->data, '_handle', FALSE);
		if ( $formname === FALSE || $handle === FALSE ) {
			osa_errorlog(__METHOD__ . " - form name or handle is missing.", $this->data);
			return FALSE;
		}
		$url = base_url() . "map/search/get/{$handle}/{$this->searchid}";
		$notForm = osa_value($this->data, 'notForm', FALSE);
		if ($notForm===FALSE)
		    $this->html .= "<form name='{$formname}' method='post' action='{$url}'>";
		//This will generate the individual search inputs and selections
		foreach ($searches as $search_item) {
			$divid = osa_value($this->data, '_divid', FALSE);  //divid for ajax change control
			$type = osa_value($search_item, '_type', FALSE);
			$html = osa_value($search_item, '_htmlbefore', FALSE);
			if ( $html !== FALSE )
				$this->html .= $html;
			switch ($type) {
				case 'date_range':
					$this->html .= '<div id="'.$divid.'">'.$this->date_range().'</div>';
					break;
				case 'date_range_current':
					$this->html .= '<div id="'.$divid.'">'.$this->date_range_current().'</div>';
					break;
				case 'last_select':
						$this->html .= '<div id="'.$divid.'">'.$this->date_range(TRUE).'</div>';
					break;
				case 'all_select':
					$this->html .= $this->month_year('_month_selected', '_year_selected',TRUE);
					break;
				case 'newline':
					$size = osa_value($search_item, '_px', FALSE);
					if ( $size === FALSE )
						$size=0;
					$this->html .= "<div style='margin-top:{$size}px'></div>";
					break;
				case 'html_select':
					$this->html .= $this->html_select($search_item);
					break;
				case 'html_checkbox':
					$this->html .= $this->html_checkbox($search_item);
					break;
				case 'html_text':
					if ( ($text = osa_value($search_item, '_text', FALSE)) !== FALSE )
					$this->html .= $text;
					break;
				case 'html_radio':
					$this->html .= $this->html_radio($search_item);
					break;
				default:
					//Too lazy to write a factory object, but the idea is the same.
					//Add new type in template and add the new class file and you are all set. OOP is great!
					//Example: The type "general" would become inputobj_general.php
					$classname = 'inputobj_' . $type;
					$filename = $classname . '.php';
					if (include_once($filename)) {
						$search_item['_div']=$this->searchid;
						$searchobj = new $classname($search_item);
						$this->html .= $searchobj->render();
					}
					else {
						osa_errorlog(__METHOD__ . " - unknown search _type {$type}.", $search_item);
					}
			} //switch
			$html = osa_value($search_item, '_htmlafter', FALSE);
			if ( $html !== FALSE )
				$this->html .= $html;
		}
		$title = osa_value($this->data, '_wintitle', FALSE);
		$width = osa_value($this->data, '_width', FALSE);
		$height = osa_value($this->data, '_height', FALSE);
		$divid = osa_value($this->data, '_divid', FALSE);
		// (issue: 136)
		$divid_from_config = $divid;
		$single_divid = $this->CI->config->item('cms_mapping_divid');
		if ( !empty($single_divid) ) {
			$divid = $single_divid;
		}
		$ischart = osa_value($this->data, '_ischart', FALSE);
		$jsfunction = 'searchWindow';
		$flashparams = 'false';
		if ( $ischart === TRUE ) {
			$swfurl = osa_include_path() . 'flashchart.swf';
			$j_divid = osa_value($this->data, '_chart_divid', FALSE); //_chart_divid 'flashchart_assessment';
			$j_width = osa_value($this->data, '_chart_width', FALSE);;
			$j_height = osa_value($this->data, '_chart_height', FALSE);;
			$bustcache = time();
			//Encode in jscript so don't need it here, unencoded version needed in jscript also
			//$dataurl = urlencode(base_url() . "chart/chart/get/$j_divid/$bustcache");
			$dataurl = base_url() . "chart/chart/get/$j_divid";
			//Future enhancement, make the following a multi-dimension jscript array to support more than one chart
			$flashparams = "['$swfurl','$j_divid',$j_width,$j_height,'$dataurl']";
		}
		if (isset($this->data['isAjax']) && $this->data['isAjax']) {
			//nothing : for disable button
		}
		else {
			$this->html .= '<div style="margin-top:10px"></div><input type="button" value="' . lang('map_show') . '" ' .
				osa_btn(FALSE) . " onclick=\"$jsfunction('$url', '$title', $width, $height, '$divid', '$formname', $flashparams)\" />";
			$this->html .= '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
			//TODO: Should make the following more generic instead of relying on the divid
			if($divid_from_config=='map_lthistory'){
				$this->html .= '<input type="button" value="' . lang('map_reset') . '" ' . osa_btn(FALSE) .
								" onclick=\"ajax_select(".CMS_LT_HIST_LAST.",'map/select/get/lthistory/','map_lthistory');document.{$formname}.reset(); return false;\" />";
			}
			else{
				$this->html .= '<input type="button" value="' . lang('map_reset') . '" ' . osa_btn(FALSE) .
								" onclick=\"document.{$formname}.reset();return false;\" />";
			}
		}
		if ($notForm===FALSE)
		    $this->html .= '</form>';
		return $this->html;
	}

	private function html_radio($data) {
		if ( ($name = osa_value($data, '_name', FALSE)) === FALSE ) {
			osa_errorlog(__METHOD__ . " - _name is missing", $data);
			return '';
		}
		if ( ($value = osa_value($data, '_value', FALSE)) === FALSE ) {
			osa_errorlog(__METHOD__ . " - _name is missing", $data);
			return '';
		}
		$checked='';
		if ( osa_value($data, '_checked', FALSE) !== FALSE )
			$checked=' checked="checked" ';
		return "<input type=\"radio\" name=\"$name\" value=\"$value\" $checked/>";
	}

	private function html_select($data) {
		if ( ($name = osa_value($data, '_name', FALSE)) === FALSE ) {
			osa_errorlog(__METHOD__ . " - _name is missing", $data);
			return '';
		}
		if ( ($dataarray = osa_value($data, '_data', FALSE)) === FALSE ) {
			osa_errorlog(__METHOD__ . " - _data is missing", $data);
			return '';
		}
		//A hack to make the data obtained from PYP,UBD to work with selects
		if (array_key_exists(1,$dataarray)) {
			$tmp_item = $dataarray[1];
			if (is_array($tmp_item))
				$dataarray = $tmp_item;
		}
		$default = osa_value($data, '_default', FALSE);
		$options = osa_value($data, '_options', FALSE);
		if ( $options !== FALSE )
			return form_dropdown($name, $dataarray, $default, $options);
		return form_dropdown($name, $dataarray, $default);
	}

	private function html_checkbox($data) {
		if ( ($name = osa_value($data, '_name', FALSE)) === FALSE ) {
			osa_errorlog(__METHOD__ . " - _name is missing", $data);
			return '';
		}
		if ( ($value = osa_value($data, '_value', FALSE)) === FALSE ) {
			osa_errorlog(__METHOD__ . " - _data is missing", $data);
			return '';
		}
		$checked = '';
		if ( osa_value($data, '_checked', FALSE) !== FALSE )
			$checked = 'checked="checked"';
		return "<input type=\"checkbox\" name=\"$name\" value=\"$value\" $checked />";
	}

	private function date_range_current() {
		return $this->date_range(TRUE);
	}

	//Prints the date range selections
	private function date_range($current=FALSE) {
		$html = lang('map_from') . ' ' . $this->month_year('_month_from', '_year_from', $current) . '&nbsp;&nbsp;&nbsp;&nbsp;' .
				  lang('map_to') . ' ' . $this->month_year('_month_to', '_year_to', $current);
		return $html;
	}

	//Prints a month and year selection
	private function month_year($monthname, $yearname, $current=FALSE) {
		$html = '';
		$timestamp = time();
		$year = date('Y', $timestamp);
		$month = date('n', $timestamp);
		$montharray = array();
		for ($i=1; $i<=12; $i++) {
			$montharray[$i] = lang('map_month' . $i);
		}
		if ( $current )
			$yeararray=array($year-3=>$year-3, $year-2=>$year-2, $year-1=>$year-1, $year=>$year);
		else
			$yeararray=array($year-3=>$year-3, $year-2=>$year-2, $year-1=>$year-1, $year=>$year, $year+1=>$year+1, $year+2=>$year+2, $year+3=>$year+3);
		$html .= form_dropdown($monthname, $montharray, $month);
		$html .= ' ' . form_dropdown($yearname, $yeararray, $year);
		return $html;
	}
}
?>