<?php
/**
 * Handle_unittype.php - Search handle for handling ICT tech lib searches
 *
 * @author $Author: dtong $
 * @version $Id: Handle_unittype.php,v 1.8 2011/04/11 12:02:16 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once('Handle_base.php');
require_once('display_list.php');

class Handle_unittype extends Handle_base{

	private $tech = array();
	private $lib = array();
	private $techlib = array();

	function __construct($params) {
		parent::__construct($params);
		$this->CI->load->model('mapping/unittype_model');
	}

	function process() {
		$course_query = $this->get_calendar_query();
		$normal = $this->get_requestvalue('_normal');
		$meta = $this->get_requestvalue('_meta');
		$integrated = $this->get_requestvalue('_integrated');
		$unified = $this->get_requestvalue('_unified');
		if ( !$normal && !$meta && !$integrated && !$unified ) {
			echo osa_ajaxmsg(lang('map_no_unittype_select'));
			exit;
		}
		$type = '';
		$sep = '';
		if ($normal){
			$type .= $normal;
		}
		if ($meta){
			if ($type!=FALSE)
				$sep = ',';
			$type .= $sep.$meta;
		}
		if ($integrated){
			if ($type!=FALSE)
				$sep = ',';
			$type .= $sep.$integrated;
		}
		if ($unified){
			if ($type!=FALSE)
				$sep = ',';
			$type .= $sep.$unified;
		}

		$res = $this->CI->unittype_model->get($course_query, $type);

		$display = & $this->get_display_obj();
		$display->pagetitle = $this->get_templatevalue('_title');
		$display->titles = array(lang('map_course'),lang('map_unit'),lang('map_unitdescription'),lang('map_unitype'));
		$display->widths = array('20%','20%','50%','10%');
		$display->divid = $this->get_inputvalue('_divid');

		if ( $res ) {
			$this->add_urllink_template_str(1, $display);
			foreach ( $res as $item ) {
				$url = base_url() . "unit/unit/read/{$item->unitid}";
				$unithtml = "<a class=\"cmslink\" href=\"$url\" onclick=\"newDhtmlWindow('$url','" . lang('map_unit') .
									"',900,800,'unitread');return false;\">{$item->unit_title}</a>";
				$coursename = $item->coursename;
				$description = $item->description;
				$data = FALSE;
				switch ($item->type) {
				        case CMS_UNIT_TYPE_NORMAL:
					        $data = array($item->coursename, $item->unit_title, $description, lang('map_normal'));
					        break;
				        case CMS_UNIT_TYPE_META:
					       $data = array($item->coursename, $item->unit_title, $description, lang('map_meta'));
					        break;
				        case CMS_UNIT_TYPE_INTEGRATED:
				        case CMS_UNIT_TYPE_INTEGRATED_CHILD:
					       $data = array($item->coursename, $item->unit_title, $description, lang('map_integrated'));
					        break;
				        case CMS_UNIT_TYPE_UNIFIED :
				        case CMS_UNIT_TYPE_UNIFIED_CHILD:
					       $data = array($item->coursename, $item->unit_title, $description, lang('map_unified'));
					        break;
					}
					if ( $data ) {
						$this->add_hidden_data(1, $data, "'$item->unitid','$item->unitid'");
						$display->add($data);
					}
			}
		}
		$this->load_view($display);
	}

}
?>