<?php
/**
 * Handle_techlib.php - Search handle for handling ICT tech lib searches
 *
 * @author $Author: dtong $
 * @version $Id: Handle_techlib.php,v 1.13 2011/04/11 12:02:16 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once('Handle_base.php');
require_once('display_list.php');

class Handle_techlib extends Handle_base{

	private $tech = array();
	private $lib = array();
	private $techlib = array();

	function __construct($params) {
		parent::__construct($params);
		$this->CI->load->model('mapping/techlib_model');
	}

	function process() {
		$course_query = $this->get_calendar_query();
		//$sort = $this->valid_sortparam($this->valid_sortparam($this->get_requestvalue('_sortorder')));
		$tech = $this->get_requestvalue('_tech');
		$lib = $this->get_requestvalue('_lib');
		if ( !$tech && !$lib ) {
			echo osa_ajaxmsg(lang('map_no_techlib_select'));
			exit;
		}
		$type = $this->get_templatevalue('_type');
		$res = $this->CI->techlib_model->get($course_query, $type, $tech, $lib);

		$display = & $this->get_display_obj();
		$display->pagetitle = $this->get_templatevalue('_title');
		$display->titles = array(lang('map_course'),lang('map_unit'),lang('map_ict'),lang('map_benchmark'));
		//Set the size for each TD
		//$display->widths = array(150,150,130,470);
		$display->widths = array('17%','17%','15%','51%');
		$display->divid = $this->get_inputvalue('_divid');
		//$display->closebutton = TRUE; //divid has to be defined for this to work
		if ( $res ) {
			$last_coursename = '';
			$lastunitid = '';
			$newline='';
			$this->add_urllink_template_str(1, $display);
			//This loop will consolidate the different selections from the same units into one entry
			foreach ( $res as $item ) {
				if ( $lastunitid == '' ) {
					//Firs time in the loop, set the last vars.
					$lastunitid = $item->unitid;
					$last_coursename = $item->coursename;
				}
				if ( $lastunitid != $item->unitid) {
					//Looping over a different unit so add existing data to display
					$benchamrks = $this->get($this->tech);
					if ( $benchamrks != '' ) {
						$data = array($last_coursename , $last_unittitle, lang('map_technology'), $benchamrks);
						$this->add_hidden_data(1, $data, "'$lastunitid','$lastunitid'");
						$display->add($data);
					}
					$benchamrks = $this->get($this->lib);
					if ( $benchamrks != '' ) {
						$data = array($last_coursename , $last_unittitle, lang('map_library'), $benchamrks);
						$this->add_hidden_data(1, $data, "'$lastunitid','$lastunitid'");
						$display->add($data);
					}
					$benchamrks = $this->get($this->techlib);
					if ( $benchamrks != '' ) {
						$data = array($last_coursename, $last_unittitle, lang('map_techandlib'), $benchamrks);
						$this->add_hidden_data(1, $data, "'$lastunitid','$lastunitid'");
						$display->add($data);
					}
					$this->reset();
					$lastunitid = $item->unitid;
					$last_coursename = $item->coursename;
				}
				$last_unittitle = $item->unit_title;
				$coursename = $item->coursename;
				//Group data based on the same unit id first before adding to display
				$this->add($item->benchmarkid, $item->benchmark, $item->tech, $item->lib);
			}
			//Most likely, the very last unit id data in the loop didn't get added to display so add it here
			$benchamrks = $this->get($this->tech);
			if ( $benchamrks != '' ) {
				$this->add_hidden_data(1, $data, "'$lastunitid','$lastunitid'");
				$data = array($item->coursename, $item->unit_title, lang('map_technology'), $benchamrks);
				$display->add($data);
			}
			$benchamrks = $this->get($this->lib);
			if ( $benchamrks != '' ) {
				$this->add_hidden_data(1, $data, "'$lastunitid','$lastunitid'");
				$data = array($item->coursename, $item->unit_title, lang('map_library'), $benchamrks);
				$display->add($data);
			}
			$benchamrks = $this->get($this->techlib);
			if ( $benchamrks != '' ) {
				$this->add_hidden_data(1, $data, "'$lastunitid','$lastunitid'");
				$data = array($item->coursename, $item->unit_title, lang('map_techandlib'), $benchamrks);
				$display->add($data);
			}
		}
		$this->load_view($display);
	}

	//Get the benchmarks (either tech, lib or tech&lib) belonging to a unit id
	private function get($data) {
		if ( !is_array($data) || count($data)<1 )
			return '';
		$newline = '';
		$ret = '';
		foreach ($data as $item) {
			$ret .= "{$newline}&#8226; {$item}";
			$newline='<br />';
		}
		return $ret;
	}

	//Adds a benchmark to the proper array (3 of them, either tech, lib or tech&lib )
	private function add($benchmarkid, $benchmark, $sel_tech, $sel_lib) {
		if ( !is_null($sel_tech) &&  $sel_tech == 1  && !is_null($sel_lib) &&  $sel_lib == 1 ) {
			$this->techlib[$benchmarkid] = $benchmark;
		}
		elseif (!is_null($sel_tech) &&  $sel_tech == 1) {
			$this->tech[$benchmarkid] = $benchmark;
		}
		elseif (!is_null($sel_lib) &&  $sel_lib == 1) {
			$this->lib[$benchmarkid] = $benchmark;
		}
	}

	//Resets the 3 arrays
	private function reset() {
		$this->tech = array();
		$this->lib = array();
		$this->techlib = array();
	}
}