<?php
/**
 * Handle_tail_gc.php - Search handle for handling Tail and Gc searches
 *
 * @author $Author: dtong $
 * @version $Id: Handle_tail_gc.php,v 1.8 2011/04/11 12:02:16 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
 */
require_once('Handle_base.php');
require_once('display_list.php');

class Handle_tail_gc extends Handle_base{

	private $tail_gc = array();
	private $type_tail_gc = array();

	function __construct($params) {
		parent::__construct($params);
		$this->CI->load->model('mapping/tail_gc_model');
	}

	function process() {
		$course_query = $this->get_calendar_query();
		$tail = $this->get_requestvalue('_tech');
		$gc = $this->get_requestvalue('_lib');
		if ( !$tail && !$gc ) {
			echo osa_ajaxmsg(lang('map_no_tail_gc'));
			exit;
		}
		$params = array();
		if ($tail != '')
		$params[] = $tail;
		if ($gc != '')
		$params[] = $gc;

		$res = $this->CI->tail_gc_model->get($course_query, $params);

		$display = & $this->get_display_obj();
		$display->pagetitle = $this->get_templatevalue('_title');
		$display->titles = array(lang('map_course'),lang('map_unit'),lang('map_tail_gc'),lang('map_benchmark'));
		$display->widths = array('17%','17%','15%','51%');
		$display->divid = $this->get_inputvalue('_divid');

		$type = false;
		if ( !empty($tail) && !empty($gc) ) {
			$type = $tail + $gc;
		}

		if ( $res ) {
			$lastunitid = '';
			$newline='';
			$this->add_urllink_template_str(1, $display);
			foreach ( $res as $item ) {
				if ( $lastunitid == '' ) {
					$lastunitid = $item->unitid;
					$lastunittitle = $item->unit_title;
				}

				if ( $lastunitid != $item->unitid) {
					// add benchmark group by unitid to data
					foreach ($this->get_templatevalue('_multitype') as $keytype => $value) {
						if ($type == $keytype) {
							$benchmarks = $this->get($this->tail_gc);
							$type_name = $this->get_type($this->type_tail_gc);
							if ( $benchmarks != '' ) {
								$data = array($coursename, $lastunittitle, $type_name, $benchmarks);
								$this->add_hidden_data(1, $data, "'$lastunitid','$lastunitid'");
								$display->add($data);
							}
						}
					}
					$lastunitid = $item->unitid;
					$lastunittitle = $item->unit_title;
					$this->reset();
				}

				//if ($type == false)
				$type = $item->target_type;
				$coursename = $item->coursename;
				$this->add($item->benchmarkid, $item->benchmark,$type);
			}
			//add last item to data
			foreach ($this->get_templatevalue('_multitype') as $keytype => $value) {
				if ($type == $keytype) {
					$benchmarks = $this->get($this->tail_gc);
					$type_name = $this->get_type($this->type_tail_gc);
					if ( $benchmarks != '' ) {
						$data = array($coursename, $item->unit_title, $type_name, $benchmarks);
						$this->add_hidden_data(1, $data, "'$item->unitid','$item->unitid'");
						$display->add($data);
					}
				}
			}
		}
		$this->load_view($display);
	}

	private function get($data) {
		if ( !is_array($data) || count($data)<1 )
		return '';
		$newline = '';
		$ret = '';
		foreach ($data as $item) {
			$ret .= "{$newline}&#8226; {$item}";
			$newline='<br />';
		}
		return $ret;
	}
	private function get_type($data) {
		if ( !is_array($data) || count($data)<1 )
		return '';
		$newline = '';
		$ret = '';
		$type = '';
		$sep = '';
		asort($data,SORT_NUMERIC);
		foreach ($data as $item) {
			if ( $type != $item) {
				$type = $item;
				foreach ($this->get_templatevalue('_multitype') as $keytype => $value) {
					if ($type == $keytype){
						$ret .= $sep . $value['_lang'];
						$sep = '&nbsp;&nbsp;';
					}
				}
			}
		}
		return $ret;
	}
	private function add($benchmarkid, $benchmark,$type) {
		$this->tail_gc[$benchmarkid] = $benchmark;
		$this->type_tail_gc[$benchmarkid] = $type;
	}
	private function reset() {
		$this->tail_gc = array();
		$this->type_tail_gc = array();
	}
}
?>