<?php
/**
 * Handle_staticresource -
 *
 * Search for a static resource type. Designed for admin notes but will work with any static resource.
 *
 * @author $Author: dtong $
 * @version $Id: Handle_staticresource.php,v 1.2 2011/06/02 06:35:13 dtong Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/

require_once('Handle_base.php');

class Handle_staticresource extends Handle_base{

function __construct($params) {
		parent::__construct($params);
		$this->CI->load->model('mapping/staticresource_model');
	}

	function process() {
		$course_query = $this->get_calendar_query();
		$type = $this->get_requestvalue('_type');
		if ( !$type ) {
			// Defaults to admin notes if type is not given
			$type = CMS_ADMIN_COMMENT_TYPE;
		}
		$display = & $this->get_display_obj();
		$display->pagetitle = $this->get_templatevalue('_title');
		$display->titles = array(lang('map_course'),lang('map_staticres_published_unit'), lang('map_staticres_editing_unit'),
										 lang('map_staticres_notes'), lang('map_staticres_note_modified'));
		$display->widths = array('15%','15%','15%','45%','10%');
		$display->divid = $this->get_inputvalue('_divid');

		$res = $this->CI->staticresource_model->get($course_query, $type);
		if ( $res ) {
			$current = reset($res);
			$last_groupid = $current->unitid;
			$editid = FALSE;
			$publishid = FALSE;
			$notes = '';
			$modified = FALSE;
			$title = '';
			$resid_tracking = array();
			$this->add_urllink_template_str(1, $display);
			$this->add_urllink_template_str(2, $display);
			foreach ($res as $row) {
				if ( $last_groupid != $row->unitid ) {
					$publish_title = '';
					$edit_title = '';
					if ( $publishid ) {
						$publish_title = $title;
					}
					if ( $editid ) {
						$edit_title = $title;
					}
					$data = array($coursename, $publish_title, $edit_title,
								  $notes, osa_date_format($modified));
					if ( $publishid ) {
						$this->add_hidden_data(1, $data, "'$publishid','$publishid'");
					}
					if ( $editid ) {
						$this->add_hidden_data(2, $data, "'$editid','$editid'");
					}
					$display->add($data);
					$notes = '';
					$modified = FALSE;
					$last_groupid = $row->unitid;
					$publishid = FALSE;
					$editid = FALSE;
					$resid_tracking = array();
				}
				if ( $row->unit_status == CMS_UNIT_STATUS_PUBLISH ) {
					$publishid = $row->real_unitid;
				}
				else {
					$editid = $row->real_unitid;
				}
				$coursename = $row->coursename;
				$title = $row->unit_title;
				if ( !array_key_exists($row->id, $resid_tracking) ) {
					//(issue: 217) text contains encoded html tags
					$notes .= '<div>&#8226; ' . strip_tags(html_entity_decode($row->text1)) . '</div>';
					$resid_tracking[$row->id] = $row->id;
				}
				if ( !$modified ) {
					$modified = $row->createdate;
				}
				if ( $modified < $row->createdate ) {
					$modified = $row->createdate;
				}
				if ( $row->modifydate && $modified < $row->modifydate ) {
					$modified = $row->modifydate;
				}
			}
			$publish_title = '';
			$edit_title = '';
			if ( $publishid ) {
				$publish_title = $title;
			}
			if ( $editid ) {
				$edit_title = $title;
			}
			$data = array($coursename, $publish_title, $edit_title,
						  $notes, osa_date_format($modified));
			if ( $publishid ) {
				$this->add_hidden_data(1, $data, "'$publishid','$publishid'");
			}
			if ( $editid ) {
				$this->add_hidden_data(2, $data, "'$editid','$editid'");
			}
			$display->add($data);
		}
		$this->load_view($display);
	}
}